/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilterSetRef
extends Reference {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterSetRef.class);
    private String id;

    public FilterSetRef() {
    }

    public FilterSetRef(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public FilterSetRef(FilterSetRef orig) {
        super(orig);
        this.id = orig.id;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("FilterSetRef missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element FilterSetRef_element) {
        if (FilterSetRef_element == null) {
            FilterSetRef_element = document.createElementNS(NAMESPACE, "FilterSetRef");
        }
        super.asXMLElement(document, FilterSetRef_element);
        if (this.id != null) {
            FilterSetRef_element.setAttribute("ID", this.id.toString());
        }
        return FilterSetRef_element;
    }
}

