/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.FolderRef;
import ome.xml.model.Image;
import ome.xml.model.ImageRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Folder
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Folder.class);
    private String id;
    private String name;
    private String description;
    private List<Folder> folders = new ReferenceList<Folder>();
    private List<Image> imageLinks = new ReferenceList<Image>();
    private List<ROI> roiLinks = new ReferenceList<ROI>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private List<Folder> folder = new ReferenceList<Folder>();

    public Folder() {
    }

    public Folder(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Folder(Folder orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.description = orig.description;
        this.folders = orig.folders;
        this.imageLinks = orig.imageLinks;
        this.roiLinks = orig.roiLinks;
        this.annotationLinks = orig.annotationLinks;
        this.folder = orig.folder;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Folder missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((Description_nodeList = Folder.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> FolderRef_nodeList = Folder.getChildrenByTagName(element, "FolderRef");
        for (Element element2 : FolderRef_nodeList) {
            FolderRef folderRef = new FolderRef();
            folderRef.setID(element2.getAttribute("ID"));
            model.addReference(this, folderRef);
        }
        List<Element> ImageRef_nodeList = Folder.getChildrenByTagName(element, "ImageRef");
        for (Element element3 : ImageRef_nodeList) {
            ImageRef imageLinks_reference = new ImageRef();
            imageLinks_reference.setID(element3.getAttribute("ID"));
            model.addReference(this, imageLinks_reference);
        }
        List<Element> list = Folder.getChildrenByTagName(element, "ROIRef");
        for (Element ROIRef_element : list) {
            ROIRef roiLinks_reference = new ROIRef();
            roiLinks_reference.setID(ROIRef_element.getAttribute("ID"));
            model.addReference(this, roiLinks_reference);
        }
        List<Element> list2 = Folder.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : list2) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof FolderRef) {
            Folder o_casted = (Folder)o;
            this.folders.add(o_casted);
            return true;
        }
        if (reference instanceof ImageRef) {
            Image o_casted = (Image)o;
            o_casted.linkFolder(this);
            this.imageLinks.add(o_casted);
            return true;
        }
        if (reference instanceof ROIRef) {
            ROI o_casted = (ROI)o;
            o_casted.linkFolder(this);
            this.roiLinks.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkFolder(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedFolderList() {
        return this.folders.size();
    }

    public List<Folder> copyLinkedFolderList() {
        return new ArrayList<Folder>(this.folders);
    }

    public Folder getLinkedFolder(int index) {
        return this.folders.get(index);
    }

    public Folder setLinkedFolder(int index, Folder o) {
        return this.folders.set(index, o);
    }

    public boolean linkFolder(Folder o) {
        return this.folders.add(o);
    }

    public boolean unlinkFolder(Folder o) {
        return this.folders.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.imageLinks.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.imageLinks);
    }

    public Image getLinkedImage(int index) {
        return this.imageLinks.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.imageLinks.set(index, o);
    }

    public boolean linkImage(Image o) {
        o.linkFolder(this);
        return this.imageLinks.add(o);
    }

    public boolean unlinkImage(Image o) {
        o.unlinkFolder(this);
        return this.imageLinks.remove(o);
    }

    public int sizeOfLinkedROIList() {
        return this.roiLinks.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roiLinks);
    }

    public ROI getLinkedROI(int index) {
        return this.roiLinks.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roiLinks.set(index, o);
    }

    public boolean linkROI(ROI o) {
        o.linkFolder(this);
        return this.roiLinks.add(o);
    }

    public boolean unlinkROI(ROI o) {
        o.unlinkFolder(this);
        return this.roiLinks.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkFolder(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkFolder(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedChildFolderList() {
        return this.folder.size();
    }

    public List<Folder> copyLinkedChildFolderList() {
        return new ArrayList<Folder>(this.folder);
    }

    public Folder getLinkedChildFolder(int index) {
        return this.folder.get(index);
    }

    public Folder setLinkedChildFolder(int index, Folder o) {
        return this.folder.set(index, o);
    }

    public boolean linkChildFolder(Folder o) {
        return this.folder.add(o);
    }

    public boolean unlinkChildFolder(Folder o) {
        return this.folder.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Folder_element) {
        Element child;
        Reference o;
        if (Folder_element == null) {
            Folder_element = document.createElementNS(NAMESPACE, "Folder");
        }
        super.asXMLElement(document, Folder_element);
        if (this.id != null) {
            Folder_element.setAttribute("ID", this.id.toString());
        }
        if (this.name != null) {
            Folder_element.setAttribute("Name", this.name.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Folder_element.appendChild(description_element);
        }
        if (this.folders != null) {
            for (Folder folders_value : this.folders) {
                o = new FolderRef();
                ((FolderRef)o).setID(folders_value.getID());
                child = document.createElementNS(NAMESPACE, "FolderRef");
                ((FolderRef)o).asXMLElement(document, child);
                Folder_element.appendChild(child);
            }
        }
        if (this.imageLinks != null) {
            for (Image imageLinks_value : this.imageLinks) {
                o = new ImageRef();
                ((ImageRef)o).setID(imageLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "ImageRef");
                ((ImageRef)o).asXMLElement(document, child);
                Folder_element.appendChild(child);
            }
        }
        if (this.roiLinks != null) {
            for (ROI roiLinks_value : this.roiLinks) {
                o = new ROIRef();
                ((ROIRef)o).setID(roiLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "ROIRef");
                ((ROIRef)o).asXMLElement(document, child);
                Folder_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "AnnotationRef");
                ((AnnotationRef)o).asXMLElement(document, child);
                Folder_element.appendChild(child);
            }
        }
        if (this.folder != null) {
            // empty if block
        }
        return Folder_element;
    }
}

