/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Arc;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Filament;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.GenericExcitationSource;
import ome.xml.model.Image;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightSource;
import ome.xml.model.Microscope;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Objective;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Instrument
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Instrument.class);
    private String id;
    private Microscope microscope;
    private List<LightSource> lightSources = new ArrayList<LightSource>();
    private List<Detector> detectors = new ArrayList<Detector>();
    private List<Objective> objectives = new ArrayList<Objective>();
    private List<FilterSet> filterSets = new ArrayList<FilterSet>();
    private List<Filter> filters = new ArrayList<Filter>();
    private List<Dichroic> dichroics = new ArrayList<Dichroic>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private List<Image> images = new ReferenceList<Image>();

    public Instrument() {
    }

    public Instrument(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Instrument(Instrument orig) {
        this.id = orig.id;
        this.microscope = orig.microscope;
        this.lightSources = orig.lightSources;
        this.detectors = orig.detectors;
        this.objectives = orig.objectives;
        this.filterSets = orig.filterSets;
        this.filters = orig.filters;
        this.dichroics = orig.dichroics;
        this.annotationLinks = orig.annotationLinks;
        this.images = orig.images;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Microscope_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Instrument missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((Microscope_nodeList = Instrument.getChildrenByTagName(element, "Microscope")).size() > 1) {
            throw new RuntimeException(String.format("Microscope node list size %d != 1", Microscope_nodeList.size()));
        }
        if (Microscope_nodeList.size() != 0) {
            this.setMicroscope(new Microscope(Microscope_nodeList.get(0), model));
        }
        List<Element> Arc_nodeList = Instrument.getChildrenByTagName(element, "Arc");
        for (Element element2 : Arc_nodeList) {
            this.addLightSource(new Arc(element2, model));
        }
        List<Element> Filament_nodeList = Instrument.getChildrenByTagName(element, "Filament");
        for (Element element3 : Filament_nodeList) {
            this.addLightSource(new Filament(element3, model));
        }
        List<Element> list = Instrument.getChildrenByTagName(element, "GenericExcitationSource");
        for (Element element4 : list) {
            this.addLightSource(new GenericExcitationSource(element4, model));
        }
        List<Element> list2 = Instrument.getChildrenByTagName(element, "Laser");
        for (Element element5 : list2) {
            this.addLightSource(new Laser(element5, model));
        }
        List<Element> list3 = Instrument.getChildrenByTagName(element, "LightEmittingDiode");
        for (Element element6 : list3) {
            this.addLightSource(new LightEmittingDiode(element6, model));
        }
        List<Element> list4 = Instrument.getChildrenByTagName(element, "Detector");
        for (Element element7 : list4) {
            this.addDetector(new Detector(element7, model));
        }
        List<Element> list5 = Instrument.getChildrenByTagName(element, "Objective");
        for (Element element8 : list5) {
            this.addObjective(new Objective(element8, model));
        }
        List<Element> list6 = Instrument.getChildrenByTagName(element, "FilterSet");
        for (Element element9 : list6) {
            this.addFilterSet(new FilterSet(element9, model));
        }
        List<Element> list7 = Instrument.getChildrenByTagName(element, "Filter");
        for (Element element10 : list7) {
            this.addFilter(new Filter(element10, model));
        }
        List<Element> list8 = Instrument.getChildrenByTagName(element, "Dichroic");
        for (Element Dichroic_element : list8) {
            this.addDichroic(new Dichroic(Dichroic_element, model));
        }
        List<Element> list9 = Instrument.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : list9) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkInstrument(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Microscope getMicroscope() {
        return this.microscope;
    }

    public void setMicroscope(Microscope microscope) {
        this.microscope = microscope;
    }

    public int sizeOfLightSourceList() {
        return this.lightSources.size();
    }

    public List<LightSource> copyLightSourceList() {
        return new ArrayList<LightSource>(this.lightSources);
    }

    public LightSource getLightSource(int index) {
        return this.lightSources.get(index);
    }

    public LightSource setLightSource(int index, LightSource lightSource) {
        lightSource.setInstrument(this);
        return this.lightSources.set(index, lightSource);
    }

    public void addLightSource(LightSource lightSource) {
        lightSource.setInstrument(this);
        this.lightSources.add(lightSource);
    }

    public void removeLightSource(LightSource lightSource) {
        this.lightSources.remove(lightSource);
    }

    public int sizeOfDetectorList() {
        return this.detectors.size();
    }

    public List<Detector> copyDetectorList() {
        return new ArrayList<Detector>(this.detectors);
    }

    public Detector getDetector(int index) {
        return this.detectors.get(index);
    }

    public Detector setDetector(int index, Detector detector) {
        detector.setInstrument(this);
        return this.detectors.set(index, detector);
    }

    public void addDetector(Detector detector) {
        detector.setInstrument(this);
        this.detectors.add(detector);
    }

    public void removeDetector(Detector detector) {
        this.detectors.remove(detector);
    }

    public int sizeOfObjectiveList() {
        return this.objectives.size();
    }

    public List<Objective> copyObjectiveList() {
        return new ArrayList<Objective>(this.objectives);
    }

    public Objective getObjective(int index) {
        return this.objectives.get(index);
    }

    public Objective setObjective(int index, Objective objective) {
        objective.setInstrument(this);
        return this.objectives.set(index, objective);
    }

    public void addObjective(Objective objective) {
        objective.setInstrument(this);
        this.objectives.add(objective);
    }

    public void removeObjective(Objective objective) {
        this.objectives.remove(objective);
    }

    public int sizeOfFilterSetList() {
        return this.filterSets.size();
    }

    public List<FilterSet> copyFilterSetList() {
        return new ArrayList<FilterSet>(this.filterSets);
    }

    public FilterSet getFilterSet(int index) {
        return this.filterSets.get(index);
    }

    public FilterSet setFilterSet(int index, FilterSet filterSet) {
        filterSet.setInstrument(this);
        return this.filterSets.set(index, filterSet);
    }

    public void addFilterSet(FilterSet filterSet) {
        filterSet.setInstrument(this);
        this.filterSets.add(filterSet);
    }

    public void removeFilterSet(FilterSet filterSet) {
        this.filterSets.remove(filterSet);
    }

    public int sizeOfFilterList() {
        return this.filters.size();
    }

    public List<Filter> copyFilterList() {
        return new ArrayList<Filter>(this.filters);
    }

    public Filter getFilter(int index) {
        return this.filters.get(index);
    }

    public Filter setFilter(int index, Filter filter) {
        filter.setInstrument(this);
        return this.filters.set(index, filter);
    }

    public void addFilter(Filter filter) {
        filter.setInstrument(this);
        this.filters.add(filter);
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
    }

    public int sizeOfDichroicList() {
        return this.dichroics.size();
    }

    public List<Dichroic> copyDichroicList() {
        return new ArrayList<Dichroic>(this.dichroics);
    }

    public Dichroic getDichroic(int index) {
        return this.dichroics.get(index);
    }

    public Dichroic setDichroic(int index, Dichroic dichroic) {
        dichroic.setInstrument(this);
        return this.dichroics.set(index, dichroic);
    }

    public void addDichroic(Dichroic dichroic) {
        dichroic.setInstrument(this);
        this.dichroics.add(dichroic);
    }

    public void removeDichroic(Dichroic dichroic) {
        this.dichroics.remove(dichroic);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkInstrument(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkInstrument(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedImageList() {
        return this.images.size();
    }

    public List<Image> copyLinkedImageList() {
        return new ArrayList<Image>(this.images);
    }

    public Image getLinkedImage(int index) {
        return this.images.get(index);
    }

    public Image setLinkedImage(int index, Image o) {
        return this.images.set(index, o);
    }

    public boolean linkImage(Image o) {
        return this.images.add(o);
    }

    public boolean unlinkImage(Image o) {
        return this.images.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Instrument_element) {
        Element child;
        if (Instrument_element == null) {
            Instrument_element = document.createElementNS(NAMESPACE, "Instrument");
        }
        super.asXMLElement(document, Instrument_element);
        if (this.id != null) {
            Instrument_element.setAttribute("ID", this.id.toString());
        }
        if (this.microscope != null) {
            Element child2 = document.createElementNS(NAMESPACE, "Microscope");
            this.microscope.asXMLElement(document, child2);
            Instrument_element.appendChild(child2);
        }
        if (this.lightSources != null) {
            for (LightSource lightSources_value : this.lightSources) {
                child = document.createElementNS(NAMESPACE, lightSources_value.getClass().getSimpleName());
                lightSources_value.asXMLElement(document, child);
                Instrument_element.appendChild(child);
            }
        }
        if (this.detectors != null) {
            for (Detector detectors_value : this.detectors) {
                child = document.createElementNS(NAMESPACE, "Detector");
                detectors_value.asXMLElement(document, child);
                Instrument_element.appendChild(child);
            }
        }
        if (this.objectives != null) {
            for (Objective objectives_value : this.objectives) {
                child = document.createElementNS(NAMESPACE, "Objective");
                objectives_value.asXMLElement(document, child);
                Instrument_element.appendChild(child);
            }
        }
        if (this.filterSets != null) {
            for (FilterSet filterSets_value : this.filterSets) {
                child = document.createElementNS(NAMESPACE, "FilterSet");
                filterSets_value.asXMLElement(document, child);
                Instrument_element.appendChild(child);
            }
        }
        if (this.filters != null) {
            for (Filter filters_value : this.filters) {
                child = document.createElementNS(NAMESPACE, "Filter");
                filters_value.asXMLElement(document, child);
                Instrument_element.appendChild(child);
            }
        }
        if (this.dichroics != null) {
            for (Dichroic dichroics_value : this.dichroics) {
                child = document.createElementNS(NAMESPACE, "Dichroic");
                dichroics_value.asXMLElement(document, child);
                Instrument_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child3 = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child3);
                Instrument_element.appendChild(child3);
            }
        }
        if (this.images != null) {
            // empty if block
        }
        return Instrument_element;
    }
}

