/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Leader
extends Reference {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Leader.class);
    private String id;
    private List<ExperimenterGroup> experimenterGroups = new ReferenceList<ExperimenterGroup>();

    public Leader() {
    }

    public Leader(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Leader(Leader orig) {
        super(orig);
        this.id = orig.id;
        this.experimenterGroups = orig.experimenterGroups;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Leader missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedExperimenterGroupList() {
        return this.experimenterGroups.size();
    }

    public List<ExperimenterGroup> copyLinkedExperimenterGroupList() {
        return new ArrayList<ExperimenterGroup>(this.experimenterGroups);
    }

    public ExperimenterGroup getLinkedExperimenterGroup(int index) {
        return this.experimenterGroups.get(index);
    }

    public ExperimenterGroup setLinkedExperimenterGroup(int index, ExperimenterGroup o) {
        return this.experimenterGroups.set(index, o);
    }

    public boolean linkExperimenterGroup(ExperimenterGroup o) {
        return this.experimenterGroups.add(o);
    }

    public boolean unlinkExperimenterGroup(ExperimenterGroup o) {
        return this.experimenterGroups.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Leader_element) {
        if (Leader_element == null) {
            Leader_element = document.createElementNS(NAMESPACE, "Leader");
        }
        super.asXMLElement(document, Leader_element);
        if (this.id != null) {
            Leader_element.setAttribute("ID", this.id.toString());
        }
        if (this.experimenterGroups != null) {
            // empty if block
        }
        return Leader_element;
    }
}

