/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.Annotation;
import ome.xml.model.MapPair;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapAnnotation
extends Annotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(MapAnnotation.class);
    private List<MapPair> value;
    private StructuredAnnotations structuredAnnotations;

    public MapAnnotation() {
    }

    public MapAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public MapAnnotation(MapAnnotation orig) {
        super(orig);
        this.value = orig.value;
        this.structuredAnnotations = orig.structuredAnnotations;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        List<Element> Value_nodeList = MapAnnotation.getChildrenByTagName(element, "Value");
        if (Value_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            ArrayList<MapPair> p = new ArrayList<MapPair>();
            NodeList children = Value_nodeList.get(0).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                p.add(new MapPair(((Element)child).getAttribute("K"), child.getTextContent()));
            }
            this.setValue(p);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public List<MapPair> getValue() {
        return this.value;
    }

    public void setValue(List<MapPair> value) {
        this.value = value;
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations_BackReference) {
        this.structuredAnnotations = structuredAnnotations_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element MapAnnotation_element) {
        if (MapAnnotation_element == null) {
            MapAnnotation_element = document.createElementNS(NAMESPACE, "MapAnnotation");
        }
        super.asXMLElement(document, MapAnnotation_element);
        if (this.value != null) {
            Element value_child = document.createElementNS(NAMESPACE, "Value");
            for (MapPair entry : this.value) {
                Element pair = document.createElementNS(NAMESPACE, "M");
                pair.setAttribute("K", entry.getName());
                pair.setTextContent(entry.getValue());
                value_child.appendChild(pair);
            }
            MapAnnotation_element.appendChild(value_child);
        }
        if (this.structuredAnnotations != null) {
            // empty if block
        }
        return MapAnnotation_element;
    }
}

