/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.MicroscopeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Microscope
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Microscope.class);
    private MicroscopeType type;

    public Microscope() {
    }

    public Microscope(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Microscope(Microscope orig) {
        super(orig);
        this.type = orig.type;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("Type")) {
            this.setType(MicroscopeType.fromString(element.getAttribute("Type")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public MicroscopeType getType() {
        return this.type;
    }

    public void setType(MicroscopeType type) {
        this.type = type;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Microscope_element) {
        if (Microscope_element == null) {
            Microscope_element = document.createElementNS(NAMESPACE, "Microscope");
        }
        super.asXMLElement(document, Microscope_element);
        if (this.type != null) {
            Microscope_element.setAttribute("Type", this.type.toString());
        }
        return Microscope_element;
    }
}

