/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.UnitsTime;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.enums.handlers.UnitsTimeEnumHandler;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Plane
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Plane.class);
    private NonNegativeInteger theZ;
    private NonNegativeInteger theT;
    private NonNegativeInteger theC;
    private Time deltaT;
    private Time exposureTime;
    private Length positionX;
    private Length positionY;
    private Length positionZ;
    private String hashSHA1;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Pixels pixels;

    public Plane() {
    }

    public Plane(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Plane(Plane orig) {
        this.theZ = orig.theZ;
        this.theT = orig.theT;
        this.theC = orig.theC;
        this.deltaT = orig.deltaT;
        this.exposureTime = orig.exposureTime;
        this.positionX = orig.positionX;
        this.positionY = orig.positionY;
        this.positionZ = orig.positionZ;
        this.hashSHA1 = orig.hashSHA1;
        this.annotationLinks = orig.annotationLinks;
        this.pixels = orig.pixels;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> HashSHA1_nodeList;
        Double baseValue;
        Enum modelUnit;
        String unitSymbol;
        super.update(element, model);
        String tagName = element.getTagName();
        if (element.hasAttribute("TheZ")) {
            this.setTheZ(NonNegativeInteger.valueOf(element.getAttribute("TheZ")));
        }
        if (element.hasAttribute("TheT")) {
            this.setTheT(NonNegativeInteger.valueOf(element.getAttribute("TheT")));
        }
        if (element.hasAttribute("TheC")) {
            this.setTheC(NonNegativeInteger.valueOf(element.getAttribute("TheC")));
        }
        if (element.hasAttribute("DeltaT")) {
            unitSymbol = element.getAttribute("DeltaTUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Plane.getDeltaTUnitXsdDefault();
            }
            modelUnit = UnitsTime.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("DeltaT"));
            if (baseValue != null) {
                this.setDeltaT(UnitsTimeEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("ExposureTime")) {
            unitSymbol = element.getAttribute("ExposureTimeUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Plane.getExposureTimeUnitXsdDefault();
            }
            modelUnit = UnitsTime.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("ExposureTime"));
            if (baseValue != null) {
                this.setExposureTime(UnitsTimeEnumHandler.getQuantity(baseValue, modelUnit));
            }
        }
        if (element.hasAttribute("PositionX")) {
            unitSymbol = element.getAttribute("PositionXUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Plane.getPositionXUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("PositionX"));
            if (baseValue != null) {
                this.setPositionX(UnitsLengthEnumHandler.getQuantity(baseValue, (UnitsLength)modelUnit));
            }
        }
        if (element.hasAttribute("PositionY")) {
            unitSymbol = element.getAttribute("PositionYUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Plane.getPositionYUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("PositionY"));
            if (baseValue != null) {
                this.setPositionY(UnitsLengthEnumHandler.getQuantity(baseValue, (UnitsLength)modelUnit));
            }
        }
        if (element.hasAttribute("PositionZ")) {
            unitSymbol = element.getAttribute("PositionZUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Plane.getPositionZUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("PositionZ"));
            if (baseValue != null) {
                this.setPositionZ(UnitsLengthEnumHandler.getQuantity(baseValue, (UnitsLength)modelUnit));
            }
        }
        if ((HashSHA1_nodeList = Plane.getChildrenByTagName(element, "HashSHA1")).size() > 1) {
            throw new RuntimeException(String.format("HashSHA1 node list size %d != 1", HashSHA1_nodeList.size()));
        }
        if (HashSHA1_nodeList.size() != 0) {
            this.setHashSHA1(String.valueOf(HashSHA1_nodeList.get(0).getTextContent()));
        }
        List<Element> AnnotationRef_nodeList = Plane.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPlane(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public NonNegativeInteger getTheZ() {
        return this.theZ;
    }

    public void setTheZ(NonNegativeInteger theZ) {
        this.theZ = theZ;
    }

    public NonNegativeInteger getTheT() {
        return this.theT;
    }

    public void setTheT(NonNegativeInteger theT) {
        this.theT = theT;
    }

    public NonNegativeInteger getTheC() {
        return this.theC;
    }

    public void setTheC(NonNegativeInteger theC) {
        this.theC = theC;
    }

    public Time getDeltaT() {
        return this.deltaT;
    }

    public void setDeltaT(Time deltaT) {
        this.deltaT = deltaT;
    }

    public static String getDeltaTUnitXsdDefault() {
        return "s";
    }

    public Time getExposureTime() {
        return this.exposureTime;
    }

    public void setExposureTime(Time exposureTime) {
        this.exposureTime = exposureTime;
    }

    public static String getExposureTimeUnitXsdDefault() {
        return "s";
    }

    public Length getPositionX() {
        return this.positionX;
    }

    public void setPositionX(Length positionX) {
        this.positionX = positionX;
    }

    public static String getPositionXUnitXsdDefault() {
        return "reference frame";
    }

    public Length getPositionY() {
        return this.positionY;
    }

    public void setPositionY(Length positionY) {
        this.positionY = positionY;
    }

    public static String getPositionYUnitXsdDefault() {
        return "reference frame";
    }

    public Length getPositionZ() {
        return this.positionZ;
    }

    public void setPositionZ(Length positionZ) {
        this.positionZ = positionZ;
    }

    public static String getPositionZUnitXsdDefault() {
        return "reference frame";
    }

    public String getHashSHA1() {
        return this.hashSHA1;
    }

    public void setHashSHA1(String hashSHA1) {
        this.hashSHA1 = hashSHA1;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPlane(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPlane(this);
        return this.annotationLinks.remove(o);
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels_BackReference) {
        this.pixels = pixels_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Plane_element) {
        Enum enumUnits;
        if (Plane_element == null) {
            Plane_element = document.createElementNS(NAMESPACE, "Plane");
        }
        super.asXMLElement(document, Plane_element);
        if (this.theZ != null) {
            Plane_element.setAttribute("TheZ", this.theZ.toString());
        }
        if (this.theT != null) {
            Plane_element.setAttribute("TheT", this.theT.toString());
        }
        if (this.theC != null) {
            Plane_element.setAttribute("TheC", this.theC.toString());
        }
        if (this.deltaT != null) {
            if (this.deltaT.value() != null) {
                Plane_element.setAttribute("DeltaT", this.deltaT.value().toString());
            }
            if (this.deltaT.unit() != null) {
                try {
                    enumUnits = UnitsTime.fromString(this.deltaT.unit().getSymbol());
                    Plane_element.setAttribute("DeltaTUnit", ((UnitsTime)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Plane:DeltaTUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.exposureTime != null) {
            if (this.exposureTime.value() != null) {
                Plane_element.setAttribute("ExposureTime", this.exposureTime.value().toString());
            }
            if (this.exposureTime.unit() != null) {
                try {
                    enumUnits = UnitsTime.fromString(this.exposureTime.unit().getSymbol());
                    Plane_element.setAttribute("ExposureTimeUnit", ((UnitsTime)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Plane:ExposureTimeUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.positionX != null) {
            if (this.positionX.value() != null) {
                Plane_element.setAttribute("PositionX", this.positionX.value().toString());
            }
            if (this.positionX.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.positionX.unit().getSymbol());
                    Plane_element.setAttribute("PositionXUnit", ((UnitsLength)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Plane:PositionXUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.positionY != null) {
            if (this.positionY.value() != null) {
                Plane_element.setAttribute("PositionY", this.positionY.value().toString());
            }
            if (this.positionY.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.positionY.unit().getSymbol());
                    Plane_element.setAttribute("PositionYUnit", ((UnitsLength)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Plane:PositionYUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.positionZ != null) {
            if (this.positionZ.value() != null) {
                Plane_element.setAttribute("PositionZ", this.positionZ.value().toString());
            }
            if (this.positionZ.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.positionZ.unit().getSymbol());
                    Plane_element.setAttribute("PositionZUnit", ((UnitsLength)enumUnits).toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Plane:PositionZUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.hashSHA1 != null) {
            Element hashSHA1_element = document.createElementNS(NAMESPACE, "HashSHA1");
            hashSHA1_element.setTextContent(this.hashSHA1.toString());
            Plane_element.appendChild(hashSHA1_element);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Plane_element.appendChild(child);
            }
        }
        if (this.pixels != null) {
            // empty if block
        }
        return Plane_element;
    }
}

