/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.Laser;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Pump
extends Reference {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Pump.class);
    private String id;
    private List<Laser> lasers = new ReferenceList<Laser>();

    public Pump() {
    }

    public Pump(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Pump(Pump orig) {
        super(orig);
        this.id = orig.id;
        this.lasers = orig.lasers;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Pump missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedLaserList() {
        return this.lasers.size();
    }

    public List<Laser> copyLinkedLaserList() {
        return new ArrayList<Laser>(this.lasers);
    }

    public Laser getLinkedLaser(int index) {
        return this.lasers.get(index);
    }

    public Laser setLinkedLaser(int index, Laser o) {
        return this.lasers.set(index, o);
    }

    public boolean linkLaser(Laser o) {
        return this.lasers.add(o);
    }

    public boolean unlinkLaser(Laser o) {
        return this.lasers.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Pump_element) {
        if (Pump_element == null) {
            Pump_element = document.createElementNS(NAMESPACE, "Pump");
        }
        super.asXMLElement(document, Pump_element);
        if (this.id != null) {
            Pump_element.setAttribute("ID", this.id.toString());
        }
        if (this.lasers != null) {
            // empty if block
        }
        return Pump_element;
    }
}

