/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.Screen;
import ome.xml.model.Well;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Reagent
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Reagent.class);
    private String id;
    private String name;
    private String reagentIdentifier;
    private String description;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Screen screen;
    private List<Well> wells = new ReferenceList<Well>();

    public Reagent() {
    }

    public Reagent(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Reagent(Reagent orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.reagentIdentifier = orig.reagentIdentifier;
        this.description = orig.description;
        this.annotationLinks = orig.annotationLinks;
        this.screen = orig.screen;
        this.wells = orig.wells;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Reagent missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (element.hasAttribute("ReagentIdentifier")) {
            this.setReagentIdentifier(String.valueOf(element.getAttribute("ReagentIdentifier")));
        }
        if ((Description_nodeList = Reagent.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> AnnotationRef_nodeList = Reagent.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkReagent(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReagentIdentifier() {
        return this.reagentIdentifier;
    }

    public void setReagentIdentifier(String reagentIdentifier) {
        this.reagentIdentifier = reagentIdentifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkReagent(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkReagent(this);
        return this.annotationLinks.remove(o);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void setScreen(Screen screen_BackReference) {
        this.screen = screen_BackReference;
    }

    public int sizeOfLinkedWellList() {
        return this.wells.size();
    }

    public List<Well> copyLinkedWellList() {
        return new ArrayList<Well>(this.wells);
    }

    public Well getLinkedWell(int index) {
        return this.wells.get(index);
    }

    public Well setLinkedWell(int index, Well o) {
        return this.wells.set(index, o);
    }

    public boolean linkWell(Well o) {
        return this.wells.add(o);
    }

    public boolean unlinkWell(Well o) {
        return this.wells.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Reagent_element) {
        if (Reagent_element == null) {
            Reagent_element = document.createElementNS(NAMESPACE, "Reagent");
        }
        super.asXMLElement(document, Reagent_element);
        if (this.id != null) {
            Reagent_element.setAttribute("ID", this.id.toString());
        }
        if (this.name != null) {
            Reagent_element.setAttribute("Name", this.name.toString());
        }
        if (this.reagentIdentifier != null) {
            Reagent_element.setAttribute("ReagentIdentifier", this.reagentIdentifier.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Reagent_element.appendChild(description_element);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Reagent_element.appendChild(child);
            }
        }
        if (this.screen != null) {
            // empty if block
        }
        if (this.wells != null) {
            // empty if block
        }
        return Reagent_element;
    }
}

