/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plate;
import ome.xml.model.PlateRef;
import ome.xml.model.Reagent;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Screen
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Screen.class);
    private String id;
    private String name;
    private String protocolIdentifier;
    private String protocolDescription;
    private String reagentSetDescription;
    private String reagentSetIdentifier;
    private String type;
    private String description;
    private List<Reagent> reagents = new ArrayList<Reagent>();
    private List<Plate> plateLinks = new ReferenceList<Plate>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();

    public Screen() {
    }

    public Screen(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Screen(Screen orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.protocolIdentifier = orig.protocolIdentifier;
        this.protocolDescription = orig.protocolDescription;
        this.reagentSetDescription = orig.reagentSetDescription;
        this.reagentSetIdentifier = orig.reagentSetIdentifier;
        this.type = orig.type;
        this.description = orig.description;
        this.reagents = orig.reagents;
        this.plateLinks = orig.plateLinks;
        this.annotationLinks = orig.annotationLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Screen missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (element.hasAttribute("ProtocolIdentifier")) {
            this.setProtocolIdentifier(String.valueOf(element.getAttribute("ProtocolIdentifier")));
        }
        if (element.hasAttribute("ProtocolDescription")) {
            this.setProtocolDescription(String.valueOf(element.getAttribute("ProtocolDescription")));
        }
        if (element.hasAttribute("ReagentSetDescription")) {
            this.setReagentSetDescription(String.valueOf(element.getAttribute("ReagentSetDescription")));
        }
        if (element.hasAttribute("ReagentSetIdentifier")) {
            this.setReagentSetIdentifier(String.valueOf(element.getAttribute("ReagentSetIdentifier")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(String.valueOf(element.getAttribute("Type")));
        }
        if ((Description_nodeList = Screen.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> Reagent_nodeList = Screen.getChildrenByTagName(element, "Reagent");
        for (Element element2 : Reagent_nodeList) {
            this.addReagent(new Reagent(element2, model));
        }
        List<Element> PlateRef_nodeList = Screen.getChildrenByTagName(element, "PlateRef");
        for (Element PlateRef_element : PlateRef_nodeList) {
            PlateRef plateLinks_reference = new PlateRef();
            plateLinks_reference.setID(PlateRef_element.getAttribute("ID"));
            model.addReference(this, plateLinks_reference);
        }
        List<Element> list = Screen.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : list) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof PlateRef) {
            Plate o_casted = (Plate)o;
            o_casted.linkScreen(this);
            this.plateLinks.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkScreen(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    public void setProtocolIdentifier(String protocolIdentifier) {
        this.protocolIdentifier = protocolIdentifier;
    }

    public String getProtocolDescription() {
        return this.protocolDescription;
    }

    public void setProtocolDescription(String protocolDescription) {
        this.protocolDescription = protocolDescription;
    }

    public String getReagentSetDescription() {
        return this.reagentSetDescription;
    }

    public void setReagentSetDescription(String reagentSetDescription) {
        this.reagentSetDescription = reagentSetDescription;
    }

    public String getReagentSetIdentifier() {
        return this.reagentSetIdentifier;
    }

    public void setReagentSetIdentifier(String reagentSetIdentifier) {
        this.reagentSetIdentifier = reagentSetIdentifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfReagentList() {
        return this.reagents.size();
    }

    public List<Reagent> copyReagentList() {
        return new ArrayList<Reagent>(this.reagents);
    }

    public Reagent getReagent(int index) {
        return this.reagents.get(index);
    }

    public Reagent setReagent(int index, Reagent reagent) {
        reagent.setScreen(this);
        return this.reagents.set(index, reagent);
    }

    public void addReagent(Reagent reagent) {
        reagent.setScreen(this);
        this.reagents.add(reagent);
    }

    public void removeReagent(Reagent reagent) {
        this.reagents.remove(reagent);
    }

    public int sizeOfLinkedPlateList() {
        return this.plateLinks.size();
    }

    public List<Plate> copyLinkedPlateList() {
        return new ArrayList<Plate>(this.plateLinks);
    }

    public Plate getLinkedPlate(int index) {
        return this.plateLinks.get(index);
    }

    public Plate setLinkedPlate(int index, Plate o) {
        return this.plateLinks.set(index, o);
    }

    public boolean linkPlate(Plate o) {
        o.linkScreen(this);
        return this.plateLinks.add(o);
    }

    public boolean unlinkPlate(Plate o) {
        o.unlinkScreen(this);
        return this.plateLinks.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkScreen(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkScreen(this);
        return this.annotationLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Screen_element) {
        Element child;
        Reference o;
        if (Screen_element == null) {
            Screen_element = document.createElementNS(NAMESPACE, "Screen");
        }
        super.asXMLElement(document, Screen_element);
        if (this.id != null) {
            Screen_element.setAttribute("ID", this.id.toString());
        }
        if (this.name != null) {
            Screen_element.setAttribute("Name", this.name.toString());
        }
        if (this.protocolIdentifier != null) {
            Screen_element.setAttribute("ProtocolIdentifier", this.protocolIdentifier.toString());
        }
        if (this.protocolDescription != null) {
            Screen_element.setAttribute("ProtocolDescription", this.protocolDescription.toString());
        }
        if (this.reagentSetDescription != null) {
            Screen_element.setAttribute("ReagentSetDescription", this.reagentSetDescription.toString());
        }
        if (this.reagentSetIdentifier != null) {
            Screen_element.setAttribute("ReagentSetIdentifier", this.reagentSetIdentifier.toString());
        }
        if (this.type != null) {
            Screen_element.setAttribute("Type", this.type.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Screen_element.appendChild(description_element);
        }
        if (this.reagents != null) {
            for (Reagent reagents_value : this.reagents) {
                Element child2 = document.createElementNS(NAMESPACE, "Reagent");
                reagents_value.asXMLElement(document, child2);
                Screen_element.appendChild(child2);
            }
        }
        if (this.plateLinks != null) {
            for (Plate plateLinks_value : this.plateLinks) {
                o = new PlateRef();
                ((PlateRef)o).setID(plateLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "PlateRef");
                ((PlateRef)o).asXMLElement(document, child);
                Screen_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "AnnotationRef");
                ((AnnotationRef)o).asXMLElement(document, child);
                Screen_element.appendChild(child);
            }
        }
        return Screen_element;
    }
}

