/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.Option;
import com.kscs.util.plugins.xjc.base.PluginUsageBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class PlainTextUsageBuilder
extends PluginUsageBuilder {
    private static final int MAX_LINE_LENGTH = 80;
    private static final int INDENT_MAX_LINE_LENGTH = 70;
    private final StringWriter stringWriter = new StringWriter();
    private final PrintWriter writer = new PrintWriter(this.stringWriter);

    public PlainTextUsageBuilder(ResourceBundle baseResourceBundle, ResourceBundle resourceBundle) {
        super(baseResourceBundle, resourceBundle);
    }

    @Override
    public PlainTextUsageBuilder addMain(String optionName) {
        this.writer.print(this.baseResourceBundle.getString(this.keyBase + ".usage"));
        this.writer.println(": -X" + optionName);
        this.writer.println();
        for (String line : PlainTextUsageBuilder.chopLines(80, this.resourceBundle.getString(this.keyBase))) {
            this.writer.println(line);
        }
        return this;
    }

    @Override
    public <T> PlainTextUsageBuilder addOption(Option<?> option) {
        if (this.firstOption) {
            this.firstOption = false;
            this.writer.println("\n" + this.baseResourceBundle.getString(this.keyBase + ".options") + ":");
        }
        String key = this.keyBase + "." + PlainTextUsageBuilder.transformName(option.getName());
        this.writer.println();
        this.writer.print("\t-");
        this.writer.println(option.getPluginName() + "." + option.getName() + "=" + option.getChoice() + " (" + option.getStringValue() + ")");
        for (String line : PlainTextUsageBuilder.chopLines(70, this.resourceBundle.getString(key))) {
            this.writer.print("\t\t");
            this.writer.println(line);
        }
        this.writer.println();
        return this;
    }

    private static List<String> chopLines(int maxLineLength, String input) {
        String[] words = input.split(" ");
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = null;
        for (String word : words) {
            if (word.length() <= 0) continue;
            if (sb == null || sb.length() <= maxLineLength) {
                if (sb == null) {
                    sb = new StringBuilder(maxLineLength);
                } else {
                    sb.append(" ");
                }
                if (sb.indexOf("\n") >= 0) {
                    result.add(sb.substring(0, sb.indexOf("\n")));
                    String rest = sb.substring(sb.indexOf("\n") + 1);
                    sb = new StringBuilder(maxLineLength);
                    sb.append(rest);
                    sb.append(" ");
                }
                sb.append(word);
                continue;
            }
            result.add(sb.toString());
            sb = new StringBuilder(maxLineLength);
            sb.append(word);
        }
        if (sb != null) {
            result.add(sb.toString());
        }
        return result;
    }

    public String build() {
        this.writer.close();
        return this.stringWriter.toString();
    }
}

