/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.doc;

import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.doc.PluginDocumentationFormatter;
import com.sun.tools.xjc.Plugin;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;

public final class DocumentationGenerator {
    public static final List<Locale> LOCALES = Arrays.asList(Locale.ROOT, Locale.GERMAN);
    public final Path siteDirectory;
    public final Map<Locale, Path> readmeFiles = new HashMap<Locale, Path>();
    public final Map<Locale, List<PluginDocumentationFormatter>> pluginDocumentationFormatters = new HashMap<Locale, List<PluginDocumentationFormatter>>();

    public DocumentationGenerator(Path siteDirectory, Path readmeFileBase, List<AbstractPlugin> plugins, List<Locale> locales) {
        this.siteDirectory = siteDirectory;
        for (Locale locale : locales) {
            String readmeBaseFullName = readmeFileBase.toString();
            String readmeBaseBaseName = readmeBaseFullName.substring(0, readmeBaseFullName.lastIndexOf(46));
            String readmeBaseSuffix = readmeBaseFullName.substring(readmeBaseFullName.lastIndexOf(46));
            Path localeReadme = Locale.ROOT.equals(locale) ? readmeFileBase : Paths.get(readmeBaseBaseName + "_" + locale.toLanguageTag() + readmeBaseSuffix, new String[0]);
            this.readmeFiles.put(locale, localeReadme);
            ArrayList<PluginDocumentationFormatter> list = new ArrayList<PluginDocumentationFormatter>();
            this.pluginDocumentationFormatters.put(locale, list);
            for (AbstractPlugin plugin : plugins) {
                list.add(new PluginDocumentationFormatter(plugin, locale));
            }
        }
    }

    private static List<AbstractPlugin> findPlugins() {
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class);
        ArrayList<AbstractPlugin> plugins = new ArrayList<AbstractPlugin>();
        for (Plugin plugin : serviceLoader) {
            if (!(plugin instanceof AbstractPlugin)) continue;
            plugins.add((AbstractPlugin)plugin);
        }
        return plugins;
    }

    public static void main(String[] args) throws IOException {
        Path siteDirectory = args.length > 0 ? Paths.get(args[0], new String[0]) : Paths.get("src/site/markdown", new String[0]);
        Path readmeFile = args.length > 1 ? Paths.get(args[1], new String[0]) : Paths.get("README.md", new String[0]);
        DocumentationGenerator documentationGenerator = new DocumentationGenerator(siteDirectory, readmeFile, DocumentationGenerator.findPlugins(), LOCALES);
        documentationGenerator.printMarkdownUsageFiles();
        documentationGenerator.printReadme();
    }

    private void printReadme() throws IOException {
        for (Locale locale : this.pluginDocumentationFormatters.keySet()) {
            Path readme = this.readmeFiles.get(locale);
            try (PrintStream ps = new PrintStream(readme.toFile());){
                for (String filename : Arrays.asList("index", "getting", "history", "usage")) {
                    DocumentationGenerator.printFile(this.getLocalizedFile(filename, locale), ps);
                }
                for (PluginDocumentationFormatter pluginDocumentationFormatter : this.pluginDocumentationFormatters.get(locale)) {
                    DocumentationGenerator.printFile(this.siteDirectory.resolve(pluginDocumentationFormatter.getUsageFileName() + ".md"), ps);
                }
                int i = 1;
                for (PluginDocumentationFormatter plugin : this.pluginDocumentationFormatters.get(locale)) {
                    ps.printf("[%d]: #%s\n", i++, plugin.getPlugin().getOptionName().substring(1));
                }
            }
            Files.copy(readme, (readme.getParent() == null ? Path.of("..", new String[0]) : readme.getParent()).resolve(readme.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void printFile(Path filename, PrintStream p) throws IOException {
        for (String line : Files.readAllLines(filename, Charset.defaultCharset())) {
            if (PluginDocumentationFormatter.INDEX_PATTERN.matcher(line).matches()) continue;
            p.println(line);
        }
    }

    private void printMarkdownUsageFiles() throws IOException {
        this.printGeneralUsageFile("usage");
        for (Locale locale : this.pluginDocumentationFormatters.keySet()) {
            for (PluginDocumentationFormatter pluginDocumentationFormatter : this.pluginDocumentationFormatters.get(locale)) {
                String usageMarkdown = pluginDocumentationFormatter.getUsageMarkdown();
                if (this.siteDirectory == null) continue;
                Files.write(this.siteDirectory.resolve(pluginDocumentationFormatter.getUsageFileName() + ".md"), usageMarkdown.getBytes(), new OpenOption[0]);
            }
        }
    }

    private void printGeneralUsageFile(String usageFileBaseName) throws IOException {
        for (Locale locale : this.pluginDocumentationFormatters.keySet()) {
            Path usageFile = this.getLocalizedFile(usageFileBaseName, locale);
            StringWriter sw = new StringWriter();
            boolean skip = false;
            try (PrintWriter p = new PrintWriter(sw);){
                for (String line : Files.readAllLines(usageFile, Charset.defaultCharset())) {
                    if (line.trim().equals("<args>")) {
                        p.println(line);
                        for (PluginDocumentationFormatter pluginDocumentationFormatter : this.pluginDocumentationFormatters.get(locale)) {
                            p.print(pluginDocumentationFormatter.getConfigCheatSheet(6, "<arg>-", "</arg>"));
                        }
                        skip = true;
                    } else if (skip) {
                        boolean bl = skip = !line.trim().equals("</args>");
                    }
                    if (skip) continue;
                    p.println(line);
                }
            }
            Files.write(usageFile, sw.toString().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
    }

    private Path getLocalizedFile(String baseName, Locale locale) {
        Path localizedFile = this.siteDirectory.resolve(baseName + "_" + locale.toLanguageTag() + ".md");
        if (!Files.exists(localizedFile, new LinkOption[0])) {
            localizedFile = this.siteDirectory.resolve(baseName + ".md");
        }
        return localizedFile;
    }
}

