/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.BoundList;
import com.kscs.util.jaxb.BoundListProxy;
import com.kscs.util.jaxb.CollectionChangeEvent;
import com.kscs.util.jaxb.CollectionChangeEventType;
import com.kscs.util.jaxb.CollectionChangeListener;
import com.kscs.util.jaxb.VetoableCollectionChangeListener;
import com.kscs.util.plugins.xjc.ImmutablePlugin;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.Opt;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.ArrayList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BoundPropertiesPlugin
extends AbstractPlugin {
    public static final String PROXY_SUFFIX = "__Proxy";
    public static final String SUPPORT_FIELD_SUFFIX = "__Support";
    public static final String OLD_VALUE_VAR_NAME = "__oldValue";
    @Opt
    private boolean constrained = true;
    @Opt
    private boolean bound = true;
    @Opt
    private boolean setterThrows = false;
    @Opt
    private boolean generateTools = true;

    public String getOptionName() {
        return "Xconstrained-properties";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        if (!this.constrained && !this.bound) {
            return true;
        }
        PluginContext pluginContext = PluginContext.get(outline, opt, errorHandler);
        JCodeModel m = outline.getCodeModel();
        if (this.generateTools) {
            pluginContext.writeSourceFile(BoundList.class);
            pluginContext.writeSourceFile(BoundListProxy.class);
            pluginContext.writeSourceFile(CollectionChangeEventType.class);
            pluginContext.writeSourceFile(CollectionChangeEvent.class);
            pluginContext.writeSourceFile(CollectionChangeListener.class);
            pluginContext.writeSourceFile(VetoableCollectionChangeListener.class);
        }
        if (pluginContext.hasPlugin(ImmutablePlugin.class)) {
            errorHandler.error(new SAXParseException(this.getMessage("error.immutableAndConstrainedProperties"), outline.getModel().getLocator()));
        }
        boolean setterAccess = true;
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass definedClass = classOutline.implClass;
            for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
                if (!fieldOutline.getPropertyInfo().isCollection() || ((JFieldVar)definedClass.fields().get(fieldOutline.getPropertyInfo().getName(false))).type().isArray()) continue;
                this.generateProxyField(classOutline, fieldOutline);
                this.generateLazyProxyInitGetter(classOutline, fieldOutline);
            }
            if (this.constrained && this.setterThrows) {
                for (JMethod method : definedClass.methods()) {
                    if (!method.name().startsWith("with") || "withVetoableChangeListener".equals(method.name()) || "withPropertyChangeListener".equals(method.name())) continue;
                    method._throws(PropertyVetoException.class);
                }
            }
            if (this.constrained) {
                this.createSupportProperty(outline, classOutline, VetoableChangeSupport.class, VetoableChangeListener.class, "vetoableChange");
            }
            if (this.bound) {
                this.createSupportProperty(outline, classOutline, PropertyChangeSupport.class, PropertyChangeListener.class, "propertyChange");
            }
            for (JFieldVar field : definedClass.fields().values()) {
                JMethod oldSetter = definedClass.getMethod("set" + outline.getModel().getNameConverter().toPropertyName(field.name()), new JType[]{field.type()});
                if (oldSetter == null || field.type().isArray()) continue;
                definedClass.methods().remove(oldSetter);
                JMethod setter = definedClass.method(1, (JType)m.VOID, "set" + outline.getModel().getNameConverter().toPropertyName(field.name()));
                JVar setterArg = setter.param(8, field.type(), "value");
                JBlock body = setter.body();
                JVar oldValueVar = body.decl(8, field.type(), OLD_VALUE_VAR_NAME, (JExpression)JExpr._this().ref((JVar)field));
                if (this.constrained) {
                    JBlock block;
                    if (this.setterThrows) {
                        block = body;
                        setter._throws(PropertyVetoException.class);
                    } else {
                        JTryBlock tryBlock = body._try();
                        block = tryBlock.body();
                        JCatchBlock catchBlock = tryBlock._catch(m.ref(PropertyVetoException.class));
                        JVar exceptionVar = catchBlock.param("x");
                        catchBlock.body()._throw((JExpression)JExpr._new((JClass)m.ref(RuntimeException.class)).arg((JExpression)exceptionVar));
                    }
                    this.invokeListener(block, field, oldValueVar, setterArg, "vetoableChange");
                }
                body.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)setterArg);
                if (!this.bound) continue;
                this.invokeListener(body, field, oldValueVar, setterArg, "propertyChange");
            }
        }
        return true;
    }

    private void createSupportProperty(Outline outline, ClassOutline classOutline, Class<?> supportClass, Class<?> listenerClass, String aspectName) {
        JCodeModel m = outline.getCodeModel();
        JDefinedClass definedClass = classOutline.implClass;
        String aspectNameCap = aspectName.substring(0, 1).toUpperCase() + aspectName.substring(1);
        if (classOutline.getSuperClass() == null) {
            JFieldVar supportField = definedClass.field(266, supportClass, aspectName + SUPPORT_FIELD_SUFFIX, (JExpression)JExpr._new((JClass)m.ref(supportClass)).arg(JExpr._this()));
            JMethod addMethod = definedClass.method(1, (JType)m.VOID, "add" + aspectNameCap + "Listener");
            JVar addParam = addMethod.param(8, listenerClass, aspectName + "Listener");
            addMethod.body().invoke((JExpression)JExpr._this().ref((JVar)supportField), "add" + aspectNameCap + "Listener").arg((JExpression)addParam);
            JMethod removeMethod = definedClass.method(1, (JType)m.VOID, "remove" + aspectNameCap + "Listener");
            JVar removeParam = removeMethod.param(8, listenerClass, aspectName + "Listener");
            removeMethod.body().invoke((JExpression)JExpr._this().ref((JVar)supportField), "remove" + aspectNameCap + "Listener").arg((JExpression)removeParam);
        }
        JMethod withMethod = definedClass.method(1, (JType)definedClass, "with" + aspectNameCap + "Listener");
        JVar withParam = withMethod.param(8, listenerClass, aspectName + "Listener");
        withMethod.body().invoke("add" + aspectNameCap + "Listener").arg((JExpression)withParam);
        withMethod.body()._return(JExpr._this());
        if (classOutline.getSuperClass() != null) {
            withMethod.annotate(Override.class);
        }
    }

    private JInvocation invokeListener(JBlock block, JFieldVar field, JVar oldValueVar, JVar setterArg, String aspectName) {
        String aspectNameCap = aspectName.substring(0, 1).toUpperCase() + aspectName.substring(1);
        JInvocation fvcInvoke = block.invoke((JExpression)JExpr._this().ref(aspectName + SUPPORT_FIELD_SUFFIX), "fire" + aspectNameCap);
        fvcInvoke.arg(JExpr.lit((String)field.name()));
        fvcInvoke.arg((JExpression)oldValueVar);
        fvcInvoke.arg((JExpression)setterArg);
        return fvcInvoke;
    }

    private JFieldVar generateProxyField(ClassOutline classOutline, FieldOutline fieldOutline) {
        JCodeModel m = classOutline.parent().getCodeModel();
        JDefinedClass definedClass = classOutline.implClass;
        JFieldVar collectionField = (JFieldVar)definedClass.fields().get(fieldOutline.getPropertyInfo().getName(false));
        JClass elementType = (JClass)((JClass)collectionField.type()).getTypeParameters().get(0);
        return definedClass.field(260, (JType)m.ref(BoundList.class).narrow(elementType), collectionField.name() + PROXY_SUFFIX, JExpr._null());
    }

    private JMethod generateLazyProxyInitGetter(ClassOutline classOutline, FieldOutline fieldOutline) {
        JCodeModel m = classOutline.parent().getCodeModel();
        JDefinedClass definedClass = classOutline.implClass;
        String fieldName = fieldOutline.getPropertyInfo().getName(false);
        String getterName = "get" + fieldOutline.getPropertyInfo().getName(true);
        JFieldVar collectionField = (JFieldVar)definedClass.fields().get(fieldName);
        JClass elementType = (JClass)((JClass)collectionField.type()).getTypeParameters().get(0);
        JClass proxyFieldType = m.ref(BoundList.class).narrow(elementType);
        JFieldRef collectionFieldRef = JExpr._this().ref((JVar)collectionField);
        JFieldRef proxyField = JExpr._this().ref(collectionField.name() + PROXY_SUFFIX);
        JMethod oldGetter = definedClass.getMethod(getterName, new JType[0]);
        definedClass.methods().remove(oldGetter);
        JMethod newGetter = definedClass.method(1, (JType)proxyFieldType, getterName);
        newGetter.body()._if(collectionFieldRef.eq(JExpr._null()))._then().assign((JAssignmentTarget)collectionFieldRef, (JExpression)JExpr._new((JClass)m.ref(ArrayList.class).narrow(elementType)));
        JBlock ifProxyNull = newGetter.body()._if(proxyField.eq(JExpr._null()))._then();
        ifProxyNull.assign((JAssignmentTarget)proxyField, (JExpression)JExpr._new((JClass)m.ref(BoundListProxy.class).narrow(elementType)).arg((JExpression)collectionFieldRef));
        newGetter.body()._return((JExpression)proxyField);
        return newGetter;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public boolean isSetterThrows() {
        return this.setterThrows;
    }
}

