/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.plugins.xjc.BuilderGeneratorSettings;
import com.kscs.util.plugins.xjc.BuilderOutline;
import com.kscs.util.plugins.xjc.CopyGenerator;
import com.kscs.util.plugins.xjc.GroupInterfacePlugin;
import com.kscs.util.plugins.xjc.JavadocUtils;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.PropertyTreeVarGenerator;
import com.kscs.util.plugins.xjc.base.PluginUtil;
import com.kscs.util.plugins.xjc.codemodel.ClassName;
import com.kscs.util.plugins.xjc.codemodel.GenerifiedClass;
import com.kscs.util.plugins.xjc.outline.DefinedInterfaceOutline;
import com.kscs.util.plugins.xjc.outline.DefinedPropertyOutline;
import com.kscs.util.plugins.xjc.outline.DefinedTypeOutline;
import com.kscs.util.plugins.xjc.outline.PropertyOutline;
import com.kscs.util.plugins.xjc.outline.ReferencedRuntimeClassOutline;
import com.kscs.util.plugins.xjc.outline.TypeOutline;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.v2.model.core.TypeInfo;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class BuilderGenerator {
    public static final String PRODUCT_VAR_NAME = "_product";
    public static final String PARENT_BUILDER_TYPE_PARAMETER_NAME = "_B";
    public static final String PRODUCT_TYPE_PARAMETER_NAME = "_P";
    public static final String OTHER_PARAM_NAME = "_other";
    public static final String OTHER_VAR_NAME = "_my";
    public static final String PARENT_BUILDER_PARAM_NAME = "_parentBuilder";
    public static final String STORED_VALUE_PARAM_NAME = "_storedValue";
    public static final String NEW_BUILDER_VAR_NAME = "_newBuilder";
    public static final String COPY_FLAG_PARAM_NAME = "_copy";
    private static final String ITEM_VAR_NAME = "_item";
    private final PluginContext pluginContext;
    private final JDefinedClass definedClass;
    private final GenerifiedClass builderClass;
    private final DefinedTypeOutline typeOutline;
    private final Map<String, BuilderOutline> builderOutlines;
    private final JFieldVar parentBuilderField;
    private final JAssignmentTarget storedValueField;
    private final boolean implement;
    private final BuilderGeneratorSettings settings;
    private final ResourceBundle resources;

    BuilderGenerator(PluginContext pluginContext, Map<String, BuilderOutline> builderOutlines, BuilderOutline builderOutline, BuilderGeneratorSettings settings) {
        this.pluginContext = pluginContext;
        this.settings = settings;
        this.builderOutlines = builderOutlines;
        this.typeOutline = (DefinedTypeOutline)builderOutline.getClassOutline();
        this.definedClass = this.typeOutline.getImplClass();
        this.builderClass = new GenerifiedClass(builderOutline.getDefinedBuilderClass(), PARENT_BUILDER_TYPE_PARAMETER_NAME);
        this.resources = ResourceBundle.getBundle(BuilderGenerator.class.getName());
        boolean bl = this.implement = !this.builderClass.raw.isInterface();
        if (!this.isSuperClassBuildable(builderOutline.getClassOutline())) {
            JMethod endMethod = this.builderClass.raw.method(1, (JType)this.builderClass.typeParam, this.settings.getEndMethodName());
            if (this.implement) {
                this.parentBuilderField = this.builderClass.raw.field(10, (JType)this.builderClass.typeParam, PARENT_BUILDER_PARAM_NAME);
                endMethod.body()._return((JExpression)JExpr._this().ref((JVar)this.parentBuilderField));
                this.storedValueField = this.settings.isCopyAlways() ? null : this.builderClass.raw.field(10, (JType)this.definedClass, STORED_VALUE_PARAM_NAME);
            } else {
                this.parentBuilderField = null;
                this.storedValueField = null;
            }
        } else {
            this.parentBuilderField = null;
            JFieldRef jFieldRef = this.storedValueField = this.implement ? JExpr.ref((String)STORED_VALUE_PARAM_NAME) : null;
        }
        if (this.implement) {
            this.generateCopyConstructor(false);
            if (this.settings.isGeneratingPartialCopy()) {
                this.generateCopyConstructor(true);
            }
        }
    }

    void generateBuilderMember(DefinedPropertyOutline propertyOutline, JBlock initBody, JVar productParam) {
        JType fieldType = propertyOutline.getRawType();
        if (propertyOutline.isCollection()) {
            if (propertyOutline.getRawType().isArray()) {
                this.generateArrayProperty(initBody, productParam, propertyOutline, fieldType.elementType(), (JType)this.builderClass.type);
            } else {
                List typeParameters = ((JClass)fieldType).getTypeParameters();
                JClass elementType = (JClass)typeParameters.get(0);
                this.generateCollectionProperty(initBody, productParam, propertyOutline, elementType);
                if (propertyOutline.isChoice()) {
                    this.generateCollectionChoiceProperty(propertyOutline);
                }
            }
        } else {
            this.generateSingularProperty(initBody, productParam, propertyOutline);
            if (propertyOutline.isChoice()) {
                this.generateSingularChoiceProperty(propertyOutline);
            }
        }
    }

    private void generateSingularChoiceProperty(PropertyOutline propertyOutline) {
        for (PropertyOutline.TagRef typeInfo : propertyOutline.getChoiceProperties()) {
            CClassInfo classInfo = (CClassInfo)typeInfo.getTypeInfo();
            QName elementName = typeInfo.getTagName();
            JClass elementType = classInfo.toType(this.pluginContext.outline, Aspect.EXPOSED);
            String variableName = this.pluginContext.toVariableName(elementName.getLocalPart());
            String propertyName = this.pluginContext.toPropertyName(elementName.getLocalPart());
            BuilderOutline childBuilderOutline = this.getBuilderDeclaration((JType)elementType);
            if (childBuilderOutline == null) {
                JMethod withMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + propertyName);
                JVar param = withMethod.param(8, (JType)elementType, variableName);
                this.generateWithMethodJavadoc(withMethod, param, propertyOutline.getSchemaAnnotationText(typeInfo).orElse(null));
                if (!this.implement) continue;
                withMethod.body().assign((JAssignmentTarget)JExpr._this().ref(propertyOutline.getFieldName()), (JExpression)param);
                withMethod.body()._return(JExpr._this());
                continue;
            }
            JClass builderFieldElementType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type);
            JClass builderWithMethodReturnType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard());
            JMethod withValueMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + propertyName);
            JVar param = withValueMethod.param(8, (JType)elementType, variableName);
            this.generateWithMethodJavadoc(withValueMethod, param, propertyOutline.getSchemaAnnotationText(typeInfo).orElse(null));
            JMethod withBuilderMethod = this.builderClass.raw.method(1, (JType)builderWithMethodReturnType, "with" + propertyName);
            this.generateBuilderMethodJavadoc(withBuilderMethod, "with", variableName, propertyOutline.getSchemaAnnotationText(typeInfo).orElse(null));
            if (!this.implement) continue;
            withValueMethod.body().assign((JAssignmentTarget)JExpr._this().ref(propertyOutline.getFieldName()), PluginUtil.nullSafe((JExpression)param, (JExpression)JExpr._new((JClass)builderFieldElementType).arg(JExpr._this()).arg((JExpression)param).arg(this.settings.isCopyAlways() ? JExpr.TRUE : JExpr.FALSE)));
            withValueMethod.body()._return(JExpr._this());
            JVar tempVar = withBuilderMethod.body().decl((JType)builderFieldElementType, propertyOutline.getFieldName(), (JExpression)JExpr._new((JClass)builderFieldElementType).arg(JExpr._this()).arg(JExpr._null()).arg(this.settings.isCopyAlways() ? JExpr.TRUE : JExpr.FALSE));
            withBuilderMethod.body().assign((JAssignmentTarget)JExpr._this().ref(propertyOutline.getFieldName()), (JExpression)tempVar);
            withBuilderMethod.body()._return((JExpression)tempVar);
        }
    }

    private void generateCollectionChoiceProperty(PropertyOutline propertyOutline) {
        for (PropertyOutline.TagRef tagRef : propertyOutline.getChoiceProperties()) {
            TypeInfo<NType, NClass> typeInfo = tagRef.getTypeInfo();
            QName elementName = tagRef.getTagName();
            JType elementType = ((NType)typeInfo.getType()).toType(this.pluginContext.outline, Aspect.EXPOSED);
            this.generateAddMethods(propertyOutline, elementName, elementType, propertyOutline.getSchemaAnnotationText(tagRef).orElse(null));
        }
    }

    private void generateAddMethods(PropertyOutline propertyOutline, QName elementName, JType jType, String schemaAnnotation) {
        JMethod addMethod;
        JClass elementType = jType.boxify();
        JClass iterableType = this.pluginContext.iterableClass.narrow(elementType.wildcard());
        String fieldName = this.pluginContext.toVariableName(elementName.getLocalPart());
        String propertyName = this.pluginContext.toPropertyName(elementName.getLocalPart());
        JMethod addIterableMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + propertyName);
        JVar addIterableParam = addIterableMethod.param(8, (JType)iterableType, fieldName + "_");
        this.generateAddMethodJavadoc(addIterableMethod, addIterableParam, schemaAnnotation);
        JMethod addVarargsMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + propertyName);
        JVar addVarargsParam = addVarargsMethod.varParam((JType)elementType, fieldName + "_");
        this.generateAddMethodJavadoc(addVarargsMethod, addVarargsParam, schemaAnnotation);
        BuilderOutline childBuilderOutline = this.getBuilderDeclaration((JType)elementType);
        if (childBuilderOutline != null && !childBuilderOutline.getClassOutline().getImplClass().isAbstract()) {
            JClass builderWithMethodReturnType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard());
            addMethod = this.builderClass.raw.method(1, (JType)builderWithMethodReturnType, "add" + propertyName);
            this.generateBuilderMethodJavadoc(addMethod, "add", fieldName, schemaAnnotation);
        } else {
            addMethod = null;
        }
        if (this.implement) {
            BuilderOutline choiceChildBuilderOutline = this.getBuilderDeclaration(propertyOutline.getElementType());
            JClass childBuilderType = childBuilderOutline == null ? this.pluginContext.buildableInterface : childBuilderOutline.getBuilderClass().narrow(this.builderClass.type);
            JClass builderFieldElementType = choiceChildBuilderOutline == null ? this.pluginContext.buildableInterface : choiceChildBuilderOutline.getBuilderClass().narrow(this.builderClass.type);
            JClass builderArrayListClass = propertyOutline.getMutableListClass().narrow(builderFieldElementType);
            JFieldVar builderField = (JFieldVar)this.builderClass.raw.fields().get(propertyOutline.getFieldName());
            addVarargsMethod.body()._return((JExpression)JExpr.invoke((JMethod)addIterableMethod).arg((JExpression)this.pluginContext.asList((JExpression)addVarargsParam)));
            if (addMethod == null) {
                addIterableMethod.body()._return((JExpression)JExpr.invoke((String)("add" + propertyOutline.getBaseName())).arg((JExpression)addIterableParam));
            } else {
                JConditional addIterableIfParamNull = addIterableMethod.body()._if(addIterableParam.ne(JExpr._null()));
                JConditional addIterableIfNull = addIterableIfParamNull._then()._if(JExpr._this().ref((JVar)builderField).eq(JExpr._null()));
                addIterableIfNull._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)builderField), (JExpression)JExpr._new((JClass)builderArrayListClass));
                JForEach addIterableForEach = addIterableIfParamNull._then().forEach((JType)elementType, ITEM_VAR_NAME, (JExpression)addIterableParam);
                JInvocation builderCreationExpression = JExpr._new((JClass)childBuilderType).arg(JExpr._this()).arg((JExpression)addIterableForEach.var()).arg(this.settings.isCopyAlways() ? JExpr.TRUE : JExpr.FALSE);
                addIterableForEach.body().add((JStatement)JExpr._this().ref((JVar)builderField).invoke("add").arg((JExpression)builderCreationExpression));
                addIterableMethod.body()._return(JExpr._this());
                JConditional addIfNull = addMethod.body()._if(JExpr._this().ref((JVar)builderField).eq(JExpr._null()));
                addIfNull._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)builderField), (JExpression)JExpr._new((JClass)builderArrayListClass));
                JVar childBuilderVar = addMethod.body().decl(8, (JType)childBuilderType, fieldName + this.settings.getBuilderFieldSuffix(), (JExpression)JExpr._new((JClass)childBuilderType).arg(JExpr._this()).arg(JExpr._null()).arg(JExpr.FALSE));
                addMethod.body().add((JStatement)JExpr._this().ref((JVar)builderField).invoke("add").arg((JExpression)childBuilderVar));
                addMethod.body()._return((JExpression)childBuilderVar);
            }
        }
    }

    private void overrideAddMethods(PropertyOutline propertyOutline, QName elementName, JType elementType) {
        JMethod addMethod;
        JClass iterableType = this.pluginContext.iterableClass.narrow((JType)(elementType instanceof JClass ? ((JClass)elementType).wildcard() : elementType));
        String fieldName = this.pluginContext.toVariableName(elementName.getLocalPart());
        String propertyName = this.pluginContext.toPropertyName(elementName.getLocalPart());
        JMethod addIterableMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + propertyName);
        addIterableMethod.annotate(Override.class);
        JVar addIterableParam = addIterableMethod.param(8, (JType)iterableType, fieldName + "_");
        this.generateAddMethodJavadoc(addIterableMethod, addIterableParam, propertyOutline.getSchemaAnnotationText().orElse(null));
        JMethod addVarargsMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + propertyName);
        addVarargsMethod.annotate(Override.class);
        JVar addVarargsParam = addVarargsMethod.varParam(elementType, fieldName + "_");
        this.generateAddMethodJavadoc(addVarargsMethod, addVarargsParam, propertyOutline.getSchemaAnnotationText().orElse(null));
        BuilderOutline childBuilderOutline = this.getBuilderDeclaration(elementType);
        if (childBuilderOutline != null && !childBuilderOutline.getClassOutline().getImplClass().isAbstract()) {
            addMethod = this.builderClass.raw.method(1, (JType)childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard()), "add" + propertyName);
            addMethod.annotate(Override.class);
            this.generateBuilderMethodJavadoc(addMethod, "add", fieldName, propertyOutline.getSchemaAnnotationText().orElse(null));
        } else {
            addMethod = null;
        }
        if (this.implement) {
            addVarargsMethod.body().add((JStatement)JExpr._super().invoke(addVarargsMethod).arg((JExpression)addVarargsParam));
            addVarargsMethod.body()._return(JExpr._this());
            addIterableMethod.body().add((JStatement)JExpr._super().invoke(addIterableMethod).arg((JExpression)addIterableParam));
            addIterableMethod.body()._return(JExpr._this());
            if (addMethod != null) {
                addMethod.body()._return((JExpression)JExpr.cast((JType)childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard()), (JExpression)JExpr._super().invoke(addMethod)));
            }
        }
    }

    private void generateCollectionProperty(JBlock initBody, JVar productParam, PropertyOutline propertyOutline, JClass elementType) {
        JMethod addMethod;
        String fieldName = propertyOutline.getFieldName();
        String propertyName = propertyOutline.getBaseName();
        JClass iterableType = this.pluginContext.iterableClass.narrow(elementType.wildcard());
        JMethod addIterableMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + propertyName);
        JVar addIterableParam = addIterableMethod.param(8, (JType)iterableType, fieldName);
        this.generateAddMethodJavadoc(addIterableMethod, addIterableParam, propertyOutline.getSchemaAnnotationText().orElse(null));
        JMethod withIterableMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + propertyName);
        JVar withIterableParam = withIterableMethod.param(8, (JType)iterableType, fieldName);
        this.generateWithMethodJavadoc(withIterableMethod, withIterableParam, propertyOutline.getSchemaAnnotationText().orElse(null));
        JMethod addVarargsMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + propertyName);
        JVar addVarargsParam = addVarargsMethod.varParam((JType)elementType, fieldName);
        this.generateAddMethodJavadoc(addVarargsMethod, addVarargsParam, propertyOutline.getSchemaAnnotationText().orElse(null));
        JMethod withVarargsMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + propertyName);
        JVar withVarargsParam = withVarargsMethod.varParam((JType)elementType, fieldName);
        this.generateWithMethodJavadoc(withVarargsMethod, withVarargsParam, propertyOutline.getSchemaAnnotationText().orElse(null));
        BuilderOutline childBuilderOutline = this.getBuilderDeclaration((JType)elementType);
        if (childBuilderOutline != null && !childBuilderOutline.getClassOutline().getImplClass().isAbstract()) {
            JClass builderWithMethodReturnType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard());
            addMethod = this.builderClass.raw.method(1, (JType)builderWithMethodReturnType, "add" + propertyName);
            this.generateBuilderMethodJavadoc(addMethod, "add", propertyName, propertyOutline.getSchemaAnnotationText().orElse(null));
        } else {
            addMethod = null;
        }
        if (this.implement) {
            JClass childBuilderType = childBuilderOutline == null ? this.pluginContext.buildableInterface : childBuilderOutline.getBuilderClass().narrow(this.builderClass.type);
            JClass builderArrayListClass = propertyOutline.getMutableListClass().narrow(childBuilderType);
            JClass builderListClass = this.pluginContext.listClass.narrow(childBuilderType);
            JFieldVar builderField = this.builderClass.raw.field(4, (JType)builderListClass, fieldName);
            addVarargsMethod.body().invoke(addIterableMethod).arg((JExpression)this.pluginContext.asList((JExpression)addVarargsParam));
            addVarargsMethod.body()._return(JExpr._this());
            withVarargsMethod.body().invoke(withIterableMethod).arg((JExpression)this.pluginContext.asList((JExpression)withVarargsParam));
            withVarargsMethod.body()._return(JExpr._this());
            JConditional addIterableIfParamNull = addIterableMethod.body()._if(addIterableParam.ne(JExpr._null()));
            JConditional addIterableIfNull = addIterableIfParamNull._then()._if(JExpr._this().ref((JVar)builderField).eq(JExpr._null()));
            addIterableIfNull._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)builderField), (JExpression)JExpr._new((JClass)builderArrayListClass));
            JForEach jForEach = addIterableIfParamNull._then().forEach((JType)elementType, ITEM_VAR_NAME, (JExpression)addIterableParam);
            JInvocation builderCreationExpression = childBuilderOutline == null ? JExpr._new((JClass)this.pluginContext.buildableClass).arg((JExpression)jForEach.var()) : JExpr._new((JClass)childBuilderType).arg(JExpr._this()).arg((JExpression)jForEach.var()).arg(this.settings.isCopyAlways() ? JExpr.TRUE : JExpr.FALSE);
            jForEach.body().add((JStatement)JExpr._this().ref((JVar)builderField).invoke("add").arg((JExpression)builderCreationExpression));
            addIterableMethod.body()._return(JExpr._this());
            JConditional withIterableIfNull = withIterableMethod.body()._if(JExpr._this().ref((JVar)builderField).ne(JExpr._null()));
            withIterableIfNull._then().add((JStatement)JExpr._this().ref((JVar)builderField).invoke("clear"));
            withIterableMethod.body()._return((JExpression)JExpr.invoke((JMethod)addIterableMethod).arg((JExpression)withIterableParam));
            JConditional ifNull = initBody._if(JExpr._this().ref((JVar)builderField).ne(JExpr._null()));
            JInvocation newMutableListExpression = JExpr._new((JClass)propertyOutline.getMutableListClass().narrow(elementType));
            String mutableListClassFullName = propertyOutline.getMutableListClass().fullName();
            JInvocation newMutableListExpressionWithArg = mutableListClassFullName.equals("java.util.ArrayList") ? newMutableListExpression.arg((JExpression)JExpr._this().ref((JVar)builderField).invoke("size")) : newMutableListExpression;
            JVar collectionVar = ifNull._then().decl(8, (JType)this.pluginContext.listClass.narrow(elementType), fieldName, (JExpression)newMutableListExpressionWithArg);
            JForEach initForEach = ifNull._then().forEach((JType)childBuilderType, ITEM_VAR_NAME, (JExpression)JExpr._this().ref((JVar)builderField));
            JInvocation buildMethodInvocation = initForEach.var().invoke(this.settings.getBuildMethodName());
            JInvocation buildExpression = childBuilderOutline == null ? JExpr.cast((JType)elementType, (JExpression)buildMethodInvocation) : buildMethodInvocation;
            initForEach.body().add((JStatement)collectionVar.invoke("add").arg((JExpression)buildExpression));
            ifNull._then().assign((JAssignmentTarget)productParam.ref(fieldName), (JExpression)collectionVar);
            if (addMethod != null) {
                JConditional addIfNull = addMethod.body()._if(JExpr._this().ref((JVar)builderField).eq(JExpr._null()));
                addIfNull._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)builderField), (JExpression)JExpr._new((JClass)builderArrayListClass));
                JVar childBuilderVar = addMethod.body().decl(8, (JType)childBuilderType, fieldName + this.settings.getBuilderFieldSuffix(), (JExpression)JExpr._new((JClass)childBuilderType).arg(JExpr._this()).arg(JExpr._null()).arg(JExpr.FALSE));
                addMethod.body().add((JStatement)JExpr._this().ref((JVar)builderField).invoke("add").arg((JExpression)childBuilderVar));
                addMethod.body()._return((JExpression)childBuilderVar);
            }
            this.pluginContext.generateImmutableFieldInit(initBody, (JExpression)productParam, propertyOutline);
        }
    }

    private void generateSingularProperty(JBlock initBody, JVar productParam, DefinedPropertyOutline propertyOutline) {
        String propertyName = propertyOutline.getBaseName();
        String fieldName = propertyOutline.getFieldName();
        JType fieldType = propertyOutline.getRawType();
        BuilderOutline childBuilderOutline = this.getReferencedBuilderDeclaration(propertyOutline);
        if (childBuilderOutline == null) {
            JMethod withMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + propertyName);
            JVar param = withMethod.param(8, fieldType, fieldName);
            this.generateWithMethodJavadoc(withMethod, param, propertyOutline.getSchemaAnnotationText().orElse(null));
            if (this.implement) {
                JFieldVar builderField = propertyOutline.getFieldOutline().getPropertyInfo().defaultValue != null ? this.builderClass.raw.field(4, fieldType, fieldName, propertyOutline.getFieldOutline().getPropertyInfo().defaultValue.compute(this.pluginContext.outline)) : this.builderClass.raw.field(4, fieldType, fieldName);
                withMethod.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)builderField), (JExpression)param);
                withMethod.body()._return(JExpr._this());
                if (propertyOutline.isChoice() && fieldType.fullName().equals(Object.class.getName())) {
                    JConditional ifBlock = initBody._if(JExpr._this().ref((JVar)builderField)._instanceof((JType)this.pluginContext.buildableInterface));
                    ifBlock._then().assign((JAssignmentTarget)productParam.ref(fieldName), (JExpression)JExpr.cast((JType)this.pluginContext.buildableInterface, (JExpression)JExpr._this().ref((JVar)builderField)).invoke("build"));
                    ifBlock._else().assign((JAssignmentTarget)productParam.ref(fieldName), (JExpression)JExpr._this().ref((JVar)builderField));
                } else {
                    initBody.assign((JAssignmentTarget)productParam.ref(fieldName), (JExpression)JExpr._this().ref((JVar)builderField));
                }
            }
        } else {
            JMethod withBuilderMethod;
            JClass elementType = (JClass)fieldType;
            JClass builderFieldElementType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type);
            JClass builderWithMethodReturnType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard());
            JMethod withValueMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + propertyName);
            JVar param = withValueMethod.param(8, (JType)elementType, fieldName);
            this.generateWithMethodJavadoc(withValueMethod, param, propertyOutline.getSchemaAnnotationText().orElse(null));
            JMethod jMethod = withBuilderMethod = childBuilderOutline.getClassOutline().getImplClass().isAbstract() ? null : this.builderClass.raw.method(1, (JType)builderWithMethodReturnType, "with" + propertyName);
            if (withBuilderMethod != null) {
                this.generateBuilderMethodJavadoc(withBuilderMethod, "with", fieldName, propertyOutline.getSchemaAnnotationText().orElse(null));
            }
            if (this.implement) {
                JFieldVar builderField = this.builderClass.raw.field(4, (JType)builderFieldElementType, fieldName);
                withValueMethod.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)builderField), PluginUtil.nullSafe((JExpression)param, (JExpression)JExpr._new((JClass)builderFieldElementType).arg(JExpr._this()).arg((JExpression)param).arg(this.settings.isCopyAlways() ? JExpr.TRUE : JExpr.FALSE)));
                withValueMethod.body()._return(JExpr._this());
                if (withBuilderMethod != null) {
                    withBuilderMethod.body()._if(JExpr._this().ref((JVar)builderField).ne(JExpr._null()))._then()._return((JExpression)JExpr._this().ref((JVar)builderField));
                    withBuilderMethod.body()._return(JExpr._this().ref((JVar)builderField).assign((JExpression)JExpr._new((JClass)builderFieldElementType).arg(JExpr._this()).arg(JExpr._null()).arg(this.settings.isCopyAlways() ? JExpr.TRUE : JExpr.FALSE)));
                }
                initBody.assign((JAssignmentTarget)productParam.ref(fieldName), PluginUtil.nullSafe((JExpression)JExpr._this().ref((JVar)builderField), (JExpression)JExpr._this().ref((JVar)builderField).invoke(this.settings.getBuildMethodName())));
            }
        }
    }

    void generateBuilderMemberOverride(PropertyOutline superPropertyOutline, PropertyOutline propertyOutline, String superPropertyName) throws SAXException {
        JType fieldType = propertyOutline.getRawType();
        String fieldName = propertyOutline.getFieldName();
        if (superPropertyOutline.isCollection()) {
            if (!fieldType.isArray()) {
                BuilderOutline childBuilderOutline;
                if (superPropertyOutline.getChoiceProperties().size() > 1) {
                    for (PropertyOutline.TagRef tagRef : propertyOutline.getChoiceProperties()) {
                        JClass elementType;
                        QName elementName = tagRef.getTagName();
                        if (tagRef.getTypeInfo() instanceof CClassInfo) {
                            CClassInfo classInfo = (CClassInfo)tagRef.getTypeInfo();
                            elementType = classInfo.toType(this.pluginContext.outline, Aspect.EXPOSED);
                            this.overrideAddMethods(superPropertyOutline, elementName, (JType)elementType);
                            continue;
                        }
                        if (tagRef.getTypeInfo() instanceof CElementInfo) {
                            elementType = ((CElementInfo)tagRef.getTypeInfo()).toType(this.pluginContext.outline, Aspect.EXPOSED);
                            this.overrideAddMethods(superPropertyOutline, elementName, (JType)elementType);
                            continue;
                        }
                        this.pluginContext.errorHandler.warning(new SAXParseException("Encountered unsupported child type \"" + String.valueOf(tagRef.getTypeInfo()) + "\" in choice children collection. Unable to generate choice expansion.", this.pluginContext.outline.getModel().getLocator()));
                    }
                }
                JClass elementType = (JClass)((JClass)fieldType).getTypeParameters().get(0);
                JClass iterableType = this.pluginContext.iterableClass.narrow(elementType.wildcard());
                JClass collectionType = this.pluginContext.collectionClass.narrow(elementType.wildcard());
                JMethod addIterableMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + superPropertyName);
                JVar addIterableParam = addIterableMethod.param(8, (JType)iterableType, fieldName);
                this.generateAddMethodJavadoc(addIterableMethod, addIterableParam, propertyOutline.getSchemaAnnotationText().orElse(null));
                JMethod addVarargsMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "add" + superPropertyName);
                JVar addVarargsParam = addVarargsMethod.varParam((JType)elementType, fieldName);
                this.generateAddMethodJavadoc(addVarargsMethod, addVarargsParam, propertyOutline.getSchemaAnnotationText().orElse(null));
                JMethod withIterableMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + superPropertyName);
                JVar withIterableParam = withIterableMethod.param(8, (JType)iterableType, fieldName);
                this.generateWithMethodJavadoc(withIterableMethod, withIterableParam, propertyOutline.getSchemaAnnotationText().orElse(null));
                JMethod withVarargsMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + superPropertyName);
                JVar withVarargsParam = withVarargsMethod.varParam((JType)elementType, fieldName);
                this.generateWithMethodJavadoc(withVarargsMethod, withVarargsParam, propertyOutline.getSchemaAnnotationText().orElse(null));
                if (this.implement) {
                    addIterableMethod.annotate(Override.class);
                    addIterableMethod.body().invoke(JExpr._super(), "add" + superPropertyName).arg((JExpression)addIterableParam);
                    addIterableMethod.body()._return(JExpr._this());
                    addVarargsMethod.annotate(Override.class);
                    addVarargsMethod.body().invoke(JExpr._super(), "add" + superPropertyName).arg((JExpression)addVarargsParam);
                    addVarargsMethod.body()._return(JExpr._this());
                    withIterableMethod.annotate(Override.class);
                    withIterableMethod.body().invoke(JExpr._super(), "with" + superPropertyName).arg((JExpression)withIterableParam);
                    withIterableMethod.body()._return(JExpr._this());
                    withVarargsMethod.annotate(Override.class);
                    withVarargsMethod.body().invoke(JExpr._super(), "with" + superPropertyName).arg((JExpression)withVarargsParam);
                    withVarargsMethod.body()._return(JExpr._this());
                }
                if ((childBuilderOutline = this.getReferencedBuilderDeclaration(propertyOutline)) != null && !childBuilderOutline.getClassOutline().getImplClass().isAbstract()) {
                    JClass builderFieldElementType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard());
                    JMethod addMethod = this.builderClass.raw.method(1, (JType)builderFieldElementType, "add" + superPropertyName);
                    this.generateBuilderMethodJavadoc(addMethod, "add", superPropertyOutline.getFieldName(), propertyOutline.getSchemaAnnotationText().orElse(null));
                    if (this.implement) {
                        addMethod.annotate(Override.class);
                        addMethod.body()._return((JExpression)JExpr.cast((JType)builderFieldElementType, (JExpression)JExpr._super().invoke(addMethod)));
                    }
                }
            } else {
                JType elementType = fieldType.elementType();
                JClass iterableType = this.pluginContext.iterableClass.narrow(elementType);
                JMethod withVarargsMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + superPropertyName);
                JVar withVarargsParam = withVarargsMethod.varParam((JType)((JClass)fieldType).getTypeParameters().get(0), fieldName);
                this.generateWithMethodJavadoc(withVarargsMethod, withVarargsParam, propertyOutline.getSchemaAnnotationText().orElse(null));
                if (this.implement) {
                    withVarargsMethod.annotate(Override.class);
                    withVarargsMethod.body().invoke(JExpr._super(), "with" + superPropertyName).arg((JExpression)withVarargsParam);
                    withVarargsMethod.body()._return(JExpr._this());
                }
            }
        } else {
            BuilderOutline childBuilderOutline;
            JMethod withMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "with" + superPropertyName);
            JVar param = withMethod.param(8, superPropertyOutline.getRawType(), fieldName);
            this.generateWithMethodJavadoc(withMethod, param, propertyOutline.getSchemaAnnotationText().orElse(null));
            if (this.implement) {
                withMethod.annotate(Override.class);
                withMethod.body().invoke(JExpr._super(), "with" + superPropertyName).arg((JExpression)param);
                withMethod.body()._return(JExpr._this());
            }
            if ((childBuilderOutline = this.getBuilderDeclaration(fieldType)) != null && !childBuilderOutline.getClassOutline().getImplClass().isAbstract()) {
                JClass builderFieldElementType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type.wildcard());
                JMethod withChildBuilderMethod = this.builderClass.raw.method(1, (JType)builderFieldElementType, "with" + superPropertyName);
                this.generateBuilderMethodJavadoc(withChildBuilderMethod, "with", superPropertyOutline.getFieldName(), propertyOutline.getSchemaAnnotationText().orElse(null));
                if (this.implement) {
                    withChildBuilderMethod.body()._return((JExpression)JExpr.cast((JType)builderFieldElementType, (JExpression)JExpr._super().invoke(withChildBuilderMethod)));
                }
            }
        }
    }

    JDefinedClass generateExtendsClause(BuilderOutline superClassBuilder) {
        return this.builderClass.raw._extends(superClassBuilder.getBuilderClass().narrow((JClass)this.builderClass.typeParam));
    }

    void generateImplementsClause() throws SAXException {
        if (this.typeOutline.isLocal()) {
            GroupInterfacePlugin groupInterfacePlugin = this.pluginContext.findPlugin(GroupInterfacePlugin.class);
            if (groupInterfacePlugin != null) {
                for (TypeOutline interfaceOutline : groupInterfacePlugin.getGroupInterfacesForClass(this.pluginContext, this.typeOutline.getImplClass().fullName())) {
                    JClass parentClass = interfaceOutline.getImplClass();
                    this.builderClass.raw._implements(this.getBuilderInterface(parentClass).narrow((JClass)this.builderClass.typeParam));
                }
            }
            this.builderClass.raw._implements(Buildable.class);
        }
    }

    private JClass getBuilderInterface(JClass parentClass) {
        return this.pluginContext.ref(parentClass, "BuildSupport", true, false, this.pluginContext.codeModel.ref(Object.class));
    }

    JMethod generateBuildMethod(JMethod initMethod) {
        JMethod buildMethod = this.builderClass.raw.method(1, (JType)this.definedClass, this.settings.getBuildMethodName());
        if (this.builderClass.type._extends() != null && !this.builderClass.type._extends().name().equals("java.lang.Object")) {
            buildMethod.annotate(Override.class);
        }
        if (this.implement) {
            JInvocation buildExpression = JExpr._this().invoke(initMethod).arg((JExpression)JExpr._new((JClass)this.definedClass));
            if (this.settings.isCopyAlways()) {
                buildMethod.body()._return((JExpression)buildExpression);
            } else if (this.definedClass.isAbstract()) {
                buildMethod.body()._return((JExpression)JExpr.cast((JType)this.definedClass, (JExpression)this.storedValueField));
            } else {
                JConditional jConditional = buildMethod.body()._if(this.storedValueField.eq(JExpr._null()));
                jConditional._then()._return((JExpression)buildExpression);
                jConditional._else()._return((JExpression)JExpr.cast((JType)this.definedClass, (JExpression)this.storedValueField));
            }
        }
        return buildMethod;
    }

    JMethod generateNewBuilderMethod() {
        JMethod builderMethod = this.definedClass.method(17, (JType)this.builderClass.raw.narrow(Void.class), this.settings.getNewBuilderMethodName());
        builderMethod.body()._return((JExpression)JExpr._new((JClass)this.builderClass.raw.narrow(Void.class)).arg(JExpr._null()).arg(JExpr._null()).arg(JExpr.FALSE));
        return builderMethod;
    }

    JMethod generateCopyOfMethod(TypeOutline paramType, boolean partial) {
        if (this.isSuperClassBuildable(paramType)) {
            this.generateCopyOfMethod(paramType.getSuperClass(), partial);
        }
        JMethod copyOfMethod = this.definedClass.method(17, (JType)this.builderClass.raw.narrow(Void.class), this.pluginContext.buildCopyMethodName);
        JTypeVar copyOfMethodTypeParam = copyOfMethod.generify(PARENT_BUILDER_TYPE_PARAMETER_NAME);
        copyOfMethod.type((JType)this.builderClass.raw.narrow((JClass)copyOfMethodTypeParam));
        JVar otherParam = copyOfMethod.param(8, (JType)paramType.getImplClass(), OTHER_PARAM_NAME);
        CopyGenerator copyGenerator = this.pluginContext.createCopyGenerator(copyOfMethod, partial);
        JVar newBuilderVar = copyOfMethod.body().decl(8, copyOfMethod.type(), NEW_BUILDER_VAR_NAME, (JExpression)JExpr._new((JType)copyOfMethod.type()).arg(JExpr._null()).arg(JExpr._null()).arg(JExpr.FALSE));
        copyOfMethod.body().add((JStatement)copyGenerator.generatePartialArgs(this.pluginContext.invoke((JExpression)otherParam, this.settings.getCopyToMethodName()).arg((JExpression)newBuilderVar)));
        copyOfMethod.body()._return((JExpression)newBuilderVar);
        return copyOfMethod;
    }

    JMethod generateNewCopyBuilderMethod(boolean partial) {
        JDefinedClass typeDefinition;
        JDefinedClass jDefinedClass = typeDefinition = this.typeOutline.isInterface() && ((DefinedInterfaceOutline)this.typeOutline).getSupportInterface() != null ? ((DefinedInterfaceOutline)this.typeOutline).getSupportInterface() : this.definedClass;
        int mods = this.implement ? (this.definedClass.isAbstract() ? 33 : 1) : 0;
        JMethod copyBuilderMethod = typeDefinition.method(mods, (JType)this.builderClass.raw, this.settings.getNewCopyBuilderMethodName());
        JTypeVar copyBuilderMethodTypeParam = copyBuilderMethod.generify(PARENT_BUILDER_TYPE_PARAMETER_NAME);
        JVar parentBuilderParam = copyBuilderMethod.param(8, (JType)copyBuilderMethodTypeParam, PARENT_BUILDER_PARAM_NAME);
        CopyGenerator copyGenerator = this.pluginContext.createCopyGenerator(copyBuilderMethod, partial);
        copyBuilderMethod.type((JType)this.builderClass.raw.narrow((JClass)copyBuilderMethodTypeParam));
        JMethod copyBuilderConvenienceMethod = typeDefinition.method(mods, (JType)this.builderClass.raw.narrow(this.pluginContext.voidClass), this.settings.getNewCopyBuilderMethodName());
        CopyGenerator copyConvenienceGenerator = this.pluginContext.createCopyGenerator(copyBuilderConvenienceMethod, partial);
        if (this.implement && !this.definedClass.isAbstract()) {
            copyBuilderMethod.body()._return((JExpression)copyGenerator.generatePartialArgs(this.pluginContext._new((JClass)copyBuilderMethod.type()).arg((JExpression)parentBuilderParam).arg(JExpr._this()).arg(JExpr.TRUE)));
            copyBuilderConvenienceMethod.body()._return((JExpression)copyConvenienceGenerator.generatePartialArgs(this.pluginContext.invoke(this.settings.getNewCopyBuilderMethodName()).arg(JExpr._null())));
        }
        if (this.isSuperClassBuildable(this.typeOutline)) {
            copyBuilderMethod.annotate(Override.class);
            copyBuilderConvenienceMethod.annotate(Override.class);
        }
        return copyBuilderMethod;
    }

    private JMethod generateConveniencePartialCopyMethod(TypeOutline paramType, JMethod partialCopyOfMethod, String methodName, JExpression propertyTreeUseArg) {
        if (this.isSuperClassBuildable(paramType)) {
            this.generateConveniencePartialCopyMethod(paramType.getSuperClass(), partialCopyOfMethod, methodName, propertyTreeUseArg);
        }
        JMethod conveniencePartialCopyMethod = this.definedClass.method(17, (JType)this.builderClass.raw.narrow(Void.class), methodName);
        JVar partialOtherParam = conveniencePartialCopyMethod.param(8, (JType)paramType.getImplClass(), OTHER_PARAM_NAME);
        JVar propertyPathParam = conveniencePartialCopyMethod.param(8, PropertyTree.class, "_propertyTree");
        conveniencePartialCopyMethod.body()._return((JExpression)JExpr.invoke((JMethod)partialCopyOfMethod).arg((JExpression)partialOtherParam).arg((JExpression)propertyPathParam).arg(propertyTreeUseArg));
        return conveniencePartialCopyMethod;
    }

    final void generateCopyOfBuilderMethods() {
        if (this.implement) {
            JMethod builderCopyOfValueMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "copyOf");
            JVar paramOtherValue = builderCopyOfValueMethod.param(8, (JType)this.definedClass, OTHER_PARAM_NAME);
            builderCopyOfValueMethod.body().add((JStatement)JExpr.invoke((JExpression)paramOtherValue, (String)"copyTo").arg(JExpr._this()))._return(JExpr._this());
            JMethod builderCopyOfBuilderMethod = this.builderClass.raw.method(1, (JType)this.builderClass.type, "copyOf");
            JVar paramOtherBuilder = builderCopyOfBuilderMethod.param(8, (JType)this.builderClass.raw, OTHER_PARAM_NAME);
            builderCopyOfBuilderMethod.body()._return((JExpression)JExpr.invoke((JMethod)builderCopyOfValueMethod).arg((JExpression)JExpr.invoke((JExpression)paramOtherBuilder, (String)"build")));
        }
    }

    final void generateCopyToMethod(boolean partial) {
        if (this.implement) {
            JDefinedClass typeDefinition = this.typeOutline.isInterface() && ((DefinedInterfaceOutline)this.typeOutline).getSupportInterface() != null ? ((DefinedInterfaceOutline)this.typeOutline).getSupportInterface() : this.definedClass;
            JMethod copyToMethod = typeDefinition.method(1, this.pluginContext.voidType, this.settings.getCopyToMethodName());
            JTypeVar typeVar = copyToMethod.generify(PARENT_BUILDER_TYPE_PARAMETER_NAME);
            JVar otherParam = copyToMethod.param(8, (JType)this.builderClass.raw.narrow((JClass)typeVar), OTHER_PARAM_NAME);
            CopyGenerator cloneGenerator = this.pluginContext.createCopyGenerator(copyToMethod, partial);
            JBlock body = copyToMethod.body();
            if (this.isSuperClassBuildable(this.typeOutline)) {
                body.add((JStatement)cloneGenerator.generatePartialArgs(this.pluginContext.invoke(JExpr._super(), copyToMethod.name()).arg((JExpression)otherParam)));
            }
            JVar otherRef = otherParam;
            this.generateFieldCopyExpressions(cloneGenerator, body, (JExpression)otherRef, JExpr._this());
            copyToMethod.javadoc().append((Object)JavadocUtils.hardWrapTextForJavadoc(this.getMessage("javadoc.method.copyTo", new Object[0])));
            copyToMethod.javadoc().addParam(otherParam).append((Object)JavadocUtils.hardWrapTextForJavadoc(this.getMessage("javadoc.method.copyTo.param.other", new Object[0])));
        }
    }

    final void generateCopyConstructor(boolean partial) {
        JBlock body;
        JMethod constructor = this.builderClass.raw.constructor(this.builderClass.raw.isAbstract() ? 2 : 1);
        JVar parentBuilderParam = constructor.param(8, (JType)this.builderClass.typeParam, PARENT_BUILDER_PARAM_NAME);
        JVar otherParam = constructor.param(8, (JType)this.typeOutline.getImplClass(), OTHER_PARAM_NAME);
        JVar copyParam = constructor.param(8, (JType)this.pluginContext.codeModel.BOOLEAN, COPY_FLAG_PARAM_NAME);
        CopyGenerator cloneGenerator = this.pluginContext.createCopyGenerator(constructor, partial);
        if (this.isSuperClassBuildable(this.typeOutline)) {
            constructor.body().add((JStatement)cloneGenerator.generatePartialArgs(this.pluginContext._super().arg((JExpression)parentBuilderParam).arg((JExpression)otherParam).arg((JExpression)copyParam)));
        } else {
            constructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)this.parentBuilderField), (JExpression)parentBuilderParam);
        }
        JConditional ifNullStmt = constructor.body()._if(otherParam.ne(JExpr._null()));
        if (!this.settings.isCopyAlways() && !this.isSuperClassBuildable(this.typeOutline)) {
            JConditional ifCopyStmt = ifNullStmt._then()._if((JExpression)copyParam);
            ifCopyStmt._else().assign(this.storedValueField, (JExpression)otherParam);
            ifNullStmt._else().assign(this.storedValueField, JExpr._null());
            body = ifCopyStmt._then();
            body.assign(this.storedValueField, JExpr._null());
        } else {
            body = ifNullStmt._then();
        }
        this.generateFieldCopyExpressions(cloneGenerator, body, JExpr._this(), (JExpression)otherParam);
    }

    private void generateFieldCopyExpressions(CopyGenerator cloneGenerator, JBlock body, JExpression targetObject, JExpression sourceObject) {
        for (DefinedPropertyOutline fieldOutline : this.typeOutline.getDeclaredFields()) {
            JFieldVar field = fieldOutline.getFieldVar();
            if (field == null || (field.mods().getValue() & 0x18) != 0) continue;
            JFieldRef targetField = targetObject.ref(field.name());
            JFieldRef sourceRef = sourceObject.ref(field.name());
            PropertyTreeVarGenerator treeVarGenerator = cloneGenerator.createPropertyTreeVarGenerator(body, fieldOutline.getFieldName());
            JType fieldType = fieldOutline.getRawType();
            JBlock currentBlock = treeVarGenerator.generateEnclosingBlock(body);
            if (fieldType.isReference()) {
                JClass fieldClass = (JClass)fieldType;
                if (this.pluginContext.collectionClass.isAssignableFrom(fieldClass)) {
                    JForEach forLoop;
                    JForEach forLoop2;
                    JClass childBuilderType;
                    JClass elementType = (JClass)fieldClass.getTypeParameters().get(0);
                    BuilderOutline childBuilderOutline = this.getBuilderDeclaration((JType)elementType);
                    if (this.settings.isGeneratingNarrowCopy() && this.pluginContext.canInstantiate((JType)elementType)) {
                        childBuilderType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type);
                        forLoop2 = this.loop(currentBlock, (JExpression)sourceRef, (JType)elementType, (JAssignmentTarget)targetField, (JType)childBuilderType, fieldOutline);
                        forLoop2.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop2.var(), treeVarGenerator.generatePartialArgs((JExpression)this.pluginContext.invoke((JType)elementType, this.pluginContext.buildCopyMethodName).narrow((JType)this.builderClass.type).arg((JExpression)forLoop2.var()))));
                        continue;
                    }
                    if (childBuilderOutline != null) {
                        childBuilderType = childBuilderOutline.getBuilderClass().narrow(this.builderClass.type);
                        forLoop2 = this.loop(currentBlock, (JExpression)sourceRef, (JType)elementType, (JAssignmentTarget)targetField, (JType)childBuilderType, fieldOutline);
                        forLoop2.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop2.var(), treeVarGenerator.generatePartialArgs((JExpression)this.pluginContext.invoke((JExpression)forLoop2.var(), this.settings.getNewCopyBuilderMethodName()).arg(targetObject))));
                        continue;
                    }
                    if (this.pluginContext.partialCopyableInterface.isAssignableFrom(elementType)) {
                        forLoop = this.loop(currentBlock, (JExpression)sourceRef, (JType)elementType, (JAssignmentTarget)targetField, (JType)elementType, fieldOutline);
                        forLoop.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop.var(), (JExpression)JExpr._new((JClass)this.pluginContext.buildableClass).arg(treeVarGenerator.generatePartialArgs((JExpression)forLoop.var().invoke(this.pluginContext.copyMethodName)))));
                        continue;
                    }
                    if (this.pluginContext.copyableInterface.isAssignableFrom(elementType)) {
                        forLoop = this.loop(currentBlock, (JExpression)sourceRef, (JType)elementType, (JAssignmentTarget)targetField, (JType)elementType, fieldOutline);
                        forLoop.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop.var(), (JExpression)JExpr._new((JClass)this.pluginContext.buildableClass).arg((JExpression)forLoop.var().invoke(this.pluginContext.copyMethodName))));
                        continue;
                    }
                    if (this.pluginContext.cloneableInterface.isAssignableFrom(elementType)) {
                        JBlock maybeTryBlock = this.pluginContext.catchCloneNotSupported(currentBlock, elementType);
                        forLoop2 = this.loop(maybeTryBlock, (JExpression)sourceRef, (JType)elementType, (JAssignmentTarget)targetField, (JType)this.pluginContext.buildableInterface, fieldOutline);
                        forLoop2.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop2.var(), (JExpression)JExpr._new((JClass)this.pluginContext.buildableClass).arg((JExpression)forLoop2.var().invoke(this.pluginContext.cloneMethodName))));
                        continue;
                    }
                    forLoop = this.loop(currentBlock, (JExpression)sourceRef, (JType)elementType, (JAssignmentTarget)targetField, (JType)this.pluginContext.buildableInterface, fieldOutline);
                    forLoop.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop.var(), (JExpression)JExpr._new((JClass)this.pluginContext.buildableClass).arg((JExpression)forLoop.var())));
                    continue;
                }
                BuilderOutline childBuilderOutline = this.getReferencedBuilderDeclaration(fieldOutline);
                if (this.settings.isGeneratingNarrowCopy() && this.pluginContext.canInstantiate(fieldType)) {
                    currentBlock.assign((JAssignmentTarget)targetField, PluginUtil.nullSafe((JExpression)sourceRef, treeVarGenerator.generatePartialArgs((JExpression)this.pluginContext.invoke(fieldType, this.pluginContext.buildCopyMethodName).narrow((JType)this.builderClass.type).arg((JExpression)sourceRef))));
                    continue;
                }
                if (childBuilderOutline != null) {
                    currentBlock.assign((JAssignmentTarget)targetField, PluginUtil.nullSafe((JExpression)sourceRef, treeVarGenerator.generatePartialArgs((JExpression)this.pluginContext.invoke((JExpression)sourceRef, this.settings.getNewCopyBuilderMethodName()).arg(targetObject))));
                    continue;
                }
                if (this.pluginContext.partialCopyableInterface.isAssignableFrom(fieldClass)) {
                    currentBlock.assign((JAssignmentTarget)targetField, PluginUtil.nullSafe((JExpression)sourceRef, this.pluginContext.castOnDemand(fieldType, treeVarGenerator.generatePartialArgs((JExpression)sourceRef.invoke(this.pluginContext.copyMethodName)))));
                    continue;
                }
                if (this.pluginContext.copyableInterface.isAssignableFrom(fieldClass)) {
                    currentBlock.assign((JAssignmentTarget)targetField, PluginUtil.nullSafe((JExpression)sourceRef, this.pluginContext.castOnDemand(fieldType, (JExpression)sourceRef.invoke(this.pluginContext.copyMethodName))));
                    continue;
                }
                if (this.pluginContext.cloneableInterface.isAssignableFrom(fieldClass)) {
                    JBlock maybeTryBlock = this.pluginContext.catchCloneNotSupported(currentBlock, fieldClass);
                    maybeTryBlock.assign((JAssignmentTarget)targetField, PluginUtil.nullSafe((JExpression)sourceRef, this.pluginContext.castOnDemand(fieldType, (JExpression)sourceRef.invoke(this.pluginContext.cloneMethodName))));
                    continue;
                }
                currentBlock.assign((JAssignmentTarget)targetField, (JExpression)sourceRef);
                continue;
            }
            currentBlock.assign((JAssignmentTarget)targetField, (JExpression)sourceRef);
        }
    }

    public void buildProperties() throws SAXException {
        JBlock initBody;
        JVar productParam;
        JMethod initMethod;
        if (this.implement) {
            initMethod = this.builderClass.raw.method(2, (JType)this.definedClass, "init");
            JTypeVar typeVar = initMethod.generify(PRODUCT_TYPE_PARAMETER_NAME, (JClass)this.definedClass);
            initMethod.type((JType)typeVar);
            productParam = initMethod.param(8, (JType)typeVar, PRODUCT_VAR_NAME);
            initBody = initMethod.body();
        } else {
            initMethod = null;
            initBody = null;
            productParam = null;
        }
        this.generateDefinedClassJavadoc();
        if (this.typeOutline.getDeclaredFields() != null) {
            for (DefinedPropertyOutline propertyOutline : this.typeOutline.getDeclaredFields()) {
                if (!propertyOutline.hasGetter()) continue;
                this.generateBuilderMember(propertyOutline, initBody, productParam);
            }
        }
        if (this.isSuperClassBuildable(this.typeOutline)) {
            TypeOutline superClass = this.typeOutline.getSuperClass();
            BuilderOutline superClassBuilder = this.getBuilderDeclaration((JType)superClass.getImplClass());
            if (superClassBuilder == null) {
                throw new RuntimeException("Cannot find builder class name " + this.settings.getBuilderClassName().getClassName() + " of: " + String.valueOf(superClass.getImplClass()));
            }
            this.generateExtendsClause(superClassBuilder);
            if (this.implement) {
                initBody._return((JExpression)JExpr._super().invoke(initMethod).arg((JExpression)productParam));
            }
            this.generateBuilderMemberOverrides(superClass);
        } else if (this.implement) {
            initBody._return(productParam);
        }
        this.generateImplementsClause();
        this.generateBuildMethod(initMethod);
        this.generateCopyToMethod(false);
        this.generateNewCopyBuilderMethod(false);
        if (this.implement && !this.definedClass.isAbstract()) {
            this.generateNewBuilderMethod();
            this.generateCopyOfMethod(this.typeOutline, false);
        }
        if (this.settings.isGeneratingPartialCopy()) {
            this.generateCopyToMethod(true);
            this.generateNewCopyBuilderMethod(true);
            if (this.implement && !this.definedClass.isAbstract()) {
                JMethod partialCopyOfMethod = this.generateCopyOfMethod(this.typeOutline, true);
                this.generateConveniencePartialCopyMethod(this.typeOutline, partialCopyOfMethod, this.pluginContext.copyExceptMethodName, this.pluginContext.excludeConst);
                this.generateConveniencePartialCopyMethod(this.typeOutline, partialCopyOfMethod, this.pluginContext.copyOnlyMethodName, this.pluginContext.includeConst);
            }
        }
        this.generateCopyOfBuilderMethods();
    }

    private void generateDefinedClassJavadoc() {
        if (this.settings.isGeneratingJavadocFromAnnotations()) {
            this.typeOutline.getImplClass().methods().forEach(jMethod -> {
                String fieldName = this.getCorrespondingFieldName((JMethod)jMethod);
                this.typeOutline.getDeclaredFields().stream().filter(typeOutline -> this.pluginContext.areVariableNamesEqual(typeOutline.getFieldName(), fieldName)).findAny().flatMap(DefinedPropertyOutline::getSchemaAnnotationText).ifPresent(schemaAnnotation -> {
                    if (this.settings.isGeneratingJavadocFromAnnotations()) {
                        JavadocUtils.appendJavadocParagraph((JDocCommentable)jMethod, schemaAnnotation);
                    }
                });
            });
        }
    }

    private String getCorrespondingFieldName(JMethod jMethod) {
        String methodName;
        return this.pluginContext.toVariableName(methodName.substring((methodName = jMethod.name()).startsWith("is") ? 2 : 3));
    }

    private void generateBuilderMemberOverrides(TypeOutline superClass) throws SAXException {
        if (superClass.getDeclaredFields() != null) {
            for (PropertyOutline propertyOutline : superClass.getDeclaredFields()) {
                if (!propertyOutline.hasGetter()) continue;
                String superPropertyName = propertyOutline.getBaseName();
                this.generateBuilderMemberOverride(propertyOutline, propertyOutline, superPropertyName);
            }
        }
        if (superClass.getSuperClass() != null) {
            this.generateBuilderMemberOverrides(superClass.getSuperClass());
        }
    }

    BuilderOutline getReferencedBuilderDeclaration(PropertyOutline propertyOutline) {
        JDefinedClass referencedDefinedClass = propertyOutline.getReferencedModelClass();
        if (referencedDefinedClass != null) {
            return this.builderOutlines.get(referencedDefinedClass.fullName());
        }
        return this.getBuilderDeclaration(propertyOutline.getRawType());
    }

    BuilderOutline getBuilderDeclaration(JType type) {
        BuilderOutline builderOutline = this.builderOutlines.get(type.fullName());
        if (builderOutline == null) {
            builderOutline = this.getReferencedBuilderOutline(type);
        }
        return builderOutline;
    }

    void generateArrayProperty(JBlock initBody, JVar productParam, PropertyOutline fieldOutline, JType elementType, JType builderType) {
        String fieldName = fieldOutline.getFieldName();
        String propertyName = fieldOutline.getBaseName();
        JType fieldType = fieldOutline.getRawType();
        JMethod withVarargsMethod = this.builderClass.raw.method(1, builderType, "with" + propertyName);
        JVar withVarargsParam = withVarargsMethod.varParam(elementType, fieldName);
        if (this.implement) {
            JFieldVar builderField = this.builderClass.raw.field(4, fieldType, fieldName, JExpr._null());
            withVarargsMethod.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)builderField), (JExpression)withVarargsParam);
            withVarargsMethod.body()._return(JExpr._this());
            initBody.assign((JAssignmentTarget)productParam.ref(fieldName), (JExpression)JExpr._this().ref((JVar)builderField));
        }
    }

    JForEach loop(JBlock block, JExpression source, JType sourceElementType, JAssignmentTarget target, JType targetElementType, PropertyOutline propertyOutline) {
        JConditional ifNull = block._if(source.eq(JExpr._null()));
        ifNull._then().assign(target, JExpr._null());
        ifNull._else().assign(target, (JExpression)JExpr._new((JClass)propertyOutline.getMutableListClass().narrow(targetElementType)));
        return ifNull._else().forEach(sourceElementType, ITEM_VAR_NAME, source);
    }

    private void generateAddMethodJavadoc(JMethod method, JVar param, String schemaAnnotation) {
        String propertyName = param.name();
        JavadocUtils.appendJavadocCommentParagraphs(method.javadoc(), this.settings.isGeneratingJavadocFromAnnotations() ? schemaAnnotation : null, MessageFormat.format(this.resources.getString("comment.addMethod"), propertyName)).addParam(param).append((Object)JavadocUtils.hardWrapTextForJavadoc(MessageFormat.format(this.resources.getString("comment.addMethod.param"), propertyName)));
    }

    private void generateWithMethodJavadoc(JMethod method, JVar param, String schemaAnnotation) {
        String propertyName = param.name();
        JavadocUtils.appendJavadocCommentParagraphs(method.javadoc(), this.settings.isGeneratingJavadocFromAnnotations() ? schemaAnnotation : null, MessageFormat.format(this.resources.getString("comment.withMethod"), propertyName)).addParam(param).append((Object)JavadocUtils.hardWrapTextForJavadoc(MessageFormat.format(this.resources.getString("comment.withMethod.param"), propertyName)));
    }

    private void generateBuilderMethodJavadoc(JMethod method, String methodPrefix, String propertyName, String schemaAnnotation) {
        String endMethodClassName = method.type().erasure().fullName();
        JavadocUtils.appendJavadocCommentParagraphs(method.javadoc(), this.settings.isGeneratingJavadocFromAnnotations() ? schemaAnnotation : null, MessageFormat.format(this.resources.getString("comment." + methodPrefix + "BuilderMethod"), propertyName, endMethodClassName)).addReturn().append((Object)JavadocUtils.hardWrapTextForJavadoc(MessageFormat.format(this.resources.getString("comment." + methodPrefix + "BuilderMethod.return"), propertyName, endMethodClassName)));
    }

    private BuilderOutline getReferencedBuilderOutline(JType type) {
        BuilderOutline builderOutline = null;
        if (this.pluginContext.getClassOutline(type) == null && this.pluginContext.getEnumOutline(type) == null && type.isReference() && !type.isArray() && type.fullName().contains(".")) {
            Class<?> runtimeParentClass;
            try {
                runtimeParentClass = Class.forName(type.binaryName(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            JClass builderClass = this.reflectRuntimeInnerClass(runtimeParentClass, this.settings.getBuilderClassName());
            if (builderClass != null) {
                ReferencedRuntimeClassOutline referencedClassOutline = new ReferencedRuntimeClassOutline(this.pluginContext.codeModel, runtimeParentClass);
                builderOutline = new BuilderOutline(referencedClassOutline, builderClass);
            }
        }
        return builderOutline;
    }

    private JClass reflectRuntimeInnerClass(Class<?> runtimeParentClass, ClassName className) {
        JClass parentClass = this.pluginContext.codeModel.ref(runtimeParentClass);
        String innerClassName = className.getName(runtimeParentClass.isInterface());
        Class<?> runtimeInnerClass = PluginContext.findInnerClass(runtimeParentClass, innerClassName);
        if (runtimeInnerClass != null && Buildable.class.isAssignableFrom(runtimeInnerClass)) {
            JClass innerSuperClass = runtimeParentClass.getSuperclass() != null ? this.pluginContext.codeModel.ref(runtimeInnerClass.getSuperclass()) : null;
            return this.pluginContext.ref(parentClass, innerClassName, runtimeInnerClass.isInterface(), Modifier.isAbstract(runtimeInnerClass.getModifiers()), innerSuperClass);
        }
        return null;
    }

    private String getMessage(String resourceKey, Object ... args) {
        return MessageFormat.format(this.resources.getString(resourceKey), args);
    }

    private boolean isSuperClassBuildable(TypeOutline classOutline) {
        TypeOutline superClass = classOutline.getSuperClass();
        if (superClass == null) {
            return false;
        }
        return superClass.isLocal() || this.getReferencedBuilderOutline((JType)superClass.getImplClass()) != null;
    }
}

