/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.Opt;
import com.kscs.util.plugins.xjc.base.PluginUtil;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class DeepClonePlugin
extends AbstractPlugin {
    @Opt
    private boolean cloneThrows = true;

    public boolean isCloneThrows() {
        return this.cloneThrows;
    }

    public String getOptionName() {
        return "Xclone";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        PluginContext pluginContext = PluginContext.get(outline, opt, errorHandler);
        for (ClassOutline classOutline : outline.getClasses()) {
            classOutline.implClass._implements(Cloneable.class);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.generateCloneMethod(pluginContext, classOutline);
        }
        return true;
    }

    private void generateCloneMethod(PluginContext pluginContext, ClassOutline classOutline) {
        JDefinedClass definedClass = classOutline.implClass;
        JMethod cloneMethod = definedClass.method(1, (JType)definedClass, pluginContext.cloneMethodName);
        cloneMethod.annotate(Override.class);
        JBlock body = cloneMethod.body();
        JVar newObjectVar = body.decl(8, (JType)definedClass, "_newObject", null);
        JBlock superMaybeTryBlock = pluginContext.catchCloneNotSupported(body, definedClass._extends());
        superMaybeTryBlock.assign((JAssignmentTarget)newObjectVar, (JExpression)JExpr.cast((JType)definedClass, (JExpression)JExpr._super().invoke(pluginContext.cloneMethodName)));
        boolean cloneNotSupportedExceptionPossible = false;
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            JFieldVar field = PluginUtil.getDeclaredField(fieldOutline);
            if (field == null || !field.type().isReference()) continue;
            JClass fieldType = (JClass)field.type();
            JFieldRef newField = JExpr.ref((JExpression)newObjectVar, (JVar)field);
            JFieldRef fieldRef = JExpr._this().ref((JVar)field);
            if (pluginContext.collectionClass.isAssignableFrom(fieldType)) {
                JClass elementType = (JClass)fieldType.getTypeParameters().get(0);
                if (pluginContext.cloneableInterface.isAssignableFrom(elementType)) {
                    JBlock maybeTryBlock = this.cloneThrows ? body : pluginContext.catchCloneNotSupported(body, elementType);
                    cloneNotSupportedExceptionPossible |= pluginContext.mustCatch(elementType);
                    JForEach forLoop = pluginContext.loop(maybeTryBlock, (JExpression)fieldRef, (JType)elementType, (JAssignmentTarget)newField, (JType)elementType, fieldOutline);
                    forLoop.body().invoke((JExpression)newField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop.var(), pluginContext.castOnDemand((JType)elementType, (JExpression)forLoop.var().invoke(pluginContext.cloneMethodName))));
                } else {
                    body.assign((JAssignmentTarget)newField, PluginUtil.nullSafe((JExpression)fieldRef, (JExpression)pluginContext.newArrayList(PluginContext.extractMutableListClass(fieldOutline), elementType).arg((JExpression)fieldRef)));
                }
                pluginContext.generateImmutableFieldInit(body, (JExpression)newObjectVar, field);
                continue;
            }
            if (!pluginContext.cloneableInterface.isAssignableFrom(fieldType)) continue;
            JBlock maybeTryBlock = this.cloneThrows ? body : pluginContext.catchCloneNotSupported(body, fieldType);
            cloneNotSupportedExceptionPossible |= pluginContext.mustCatch(fieldType);
            maybeTryBlock.assign((JAssignmentTarget)newField, PluginUtil.nullSafe((JExpression)fieldRef, pluginContext.castOnDemand((JType)fieldType, (JExpression)JExpr._this().ref((JVar)field).invoke(pluginContext.cloneMethodName))));
        }
        body._return((JExpression)newObjectVar);
        if (this.cloneThrows && cloneNotSupportedExceptionPossible) {
            cloneMethod._throws(CloneNotSupportedException.class);
        }
    }
}

