/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.plugins.xjc.CopyGenerator;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.PropertyTreeVarGenerator;
import com.kscs.util.plugins.xjc.base.PluginUtil;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class DeepCopyGenerator {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(DeepCopyGenerator.class.getName());
    public static final String OTHER_PARAM_NAME = "_other";
    private final PluginContext pluginContext;
    private final ClassOutline classOutline;

    public DeepCopyGenerator(PluginContext pluginContext, ClassOutline classOutline) {
        this.pluginContext = pluginContext;
        this.classOutline = classOutline;
    }

    public void generateFieldCopyExpression(CopyGenerator cloneGenerator, JBlock body, JExpression targetObject, JFieldVar field, JAssignmentTarget targetField, JExpression sourceField, FieldOutline fieldOutline) {
        PropertyTreeVarGenerator treeVarGenerator = cloneGenerator.createPropertyTreeVarGenerator(body, field.name());
        JBlock currentBlock = treeVarGenerator.generateEnclosingBlock(body);
        if (field.type().isReference()) {
            JClass fieldType = (JClass)field.type();
            if (this.pluginContext.collectionClass.isAssignableFrom(fieldType)) {
                JClass elementType = (JClass)fieldType.getTypeParameters().get(0);
                if (this.pluginContext.partialCopyableInterface.isAssignableFrom(elementType)) {
                    JForEach forLoop = this.pluginContext.loop(currentBlock, sourceField, (JType)elementType, targetField, (JType)elementType, fieldOutline);
                    forLoop.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop.var(), this.pluginContext.castOnDemand((JType)elementType, treeVarGenerator.generatePartialArgs((JExpression)forLoop.var().invoke(this.pluginContext.copyMethodName)))));
                } else if (this.pluginContext.copyableInterface.isAssignableFrom(elementType)) {
                    JForEach forLoop = this.pluginContext.loop(currentBlock, sourceField, (JType)elementType, targetField, (JType)elementType, fieldOutline);
                    forLoop.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop.var(), this.pluginContext.castOnDemand((JType)elementType, (JExpression)forLoop.var().invoke(this.pluginContext.copyMethodName))));
                } else if (this.pluginContext.cloneableInterface.isAssignableFrom(elementType)) {
                    JBlock maybeTryBlock = this.pluginContext.catchCloneNotSupported(currentBlock, elementType);
                    JForEach forLoop = this.pluginContext.loop(maybeTryBlock, sourceField, (JType)elementType, targetField, (JType)elementType, fieldOutline);
                    forLoop.body().invoke((JExpression)targetField, "add").arg(PluginUtil.nullSafe((JExpression)forLoop.var(), this.pluginContext.castOnDemand((JType)elementType, (JExpression)forLoop.var().invoke(this.pluginContext.cloneMethodName))));
                } else {
                    currentBlock.assign(targetField, PluginUtil.nullSafe(sourceField, (JExpression)this.pluginContext.newArrayList(PluginContext.extractMutableListClass(fieldOutline), elementType).arg(sourceField)));
                }
                this.pluginContext.generateImmutableFieldInit(body, targetObject, field);
            } else if (this.pluginContext.partialCopyableInterface.isAssignableFrom(fieldType)) {
                currentBlock.assign(targetField, PluginUtil.nullSafe(sourceField, this.pluginContext.castOnDemand((JType)fieldType, treeVarGenerator.generatePartialArgs((JExpression)sourceField.invoke(this.pluginContext.copyMethodName)))));
            } else if (this.pluginContext.copyableInterface.isAssignableFrom(fieldType)) {
                currentBlock.assign(targetField, PluginUtil.nullSafe(sourceField, this.pluginContext.castOnDemand((JType)fieldType, (JExpression)sourceField.invoke(this.pluginContext.copyMethodName))));
            } else if (this.pluginContext.cloneableInterface.isAssignableFrom(fieldType)) {
                JBlock maybeTryBlock = this.pluginContext.catchCloneNotSupported(currentBlock, fieldType);
                maybeTryBlock.assign(targetField, PluginUtil.nullSafe(sourceField, this.pluginContext.castOnDemand((JType)fieldType, (JExpression)sourceField.invoke(this.pluginContext.cloneMethodName))));
            } else {
                currentBlock.assign(targetField, sourceField);
            }
        } else {
            currentBlock.assign(targetField, sourceField);
        }
    }

    JMethod generateCreateCopyMethod(boolean partial) {
        JVar newObjectVar;
        JDefinedClass definedClass = this.classOutline.implClass;
        JMethod cloneMethod = definedClass.method(1, (JType)definedClass, this.pluginContext.copyMethodName);
        CopyGenerator cloneGenerator = this.pluginContext.createCopyGenerator(cloneMethod, partial);
        cloneMethod.annotate(Override.class);
        JBlock body = cloneMethod.body();
        boolean superPartialCopyable = this.pluginContext.partialCopyableInterface.isAssignableFrom(definedClass._extends());
        boolean superCopyable = this.pluginContext.copyableInterface.isAssignableFrom(definedClass._extends());
        if (superPartialCopyable) {
            newObjectVar = body.decl(8, (JType)definedClass, this.pluginContext.newObjectVarName, (JExpression)JExpr.cast((JType)definedClass, (JExpression)cloneGenerator.generatePartialArgs(this.pluginContext.invoke(JExpr._super(), this.pluginContext.copyMethodName))));
        } else if (superCopyable) {
            newObjectVar = body.decl(8, (JType)definedClass, this.pluginContext.newObjectVarName, (JExpression)JExpr.cast((JType)definedClass, (JExpression)JExpr._super().invoke(this.pluginContext.copyMethodName)));
        } else {
            newObjectVar = body.decl(8, (JType)definedClass, this.pluginContext.newObjectVarName, null);
            JBlock maybeTryBlock = this.pluginContext.catchCloneNotSupported(body, definedClass._extends());
            maybeTryBlock.assign((JAssignmentTarget)newObjectVar, (JExpression)JExpr.cast((JType)definedClass, (JExpression)JExpr._super().invoke(this.pluginContext.cloneMethodName)));
        }
        this.generateFieldCopyExpressions(cloneGenerator, body, (JExpression)newObjectVar, JExpr._this());
        body._return((JExpression)newObjectVar);
        return cloneMethod;
    }

    private void generateFieldCopyExpressions(CopyGenerator cloneGenerator, JBlock body, JExpression targetObject, JExpression sourceObject) {
        for (FieldOutline fieldOutline : this.classOutline.getDeclaredFields()) {
            JFieldVar field = PluginUtil.getDeclaredField(fieldOutline);
            if (field == null || (field.mods().getValue() & 0x18) != 0) continue;
            this.generateFieldCopyExpression(cloneGenerator, body, targetObject, field, (JAssignmentTarget)targetObject.ref(field.name()), (JExpression)sourceObject.ref(field.name()), fieldOutline);
        }
    }

    JMethod generateConveniencePartialCopyMethod(JMethod cloneMethod, String methodName, JExpression secondParam) {
        JDefinedClass definedClass = this.classOutline.implClass;
        JMethod cloneExceptMethod = definedClass.method(1, (JType)definedClass, methodName);
        JVar propertyTreeParam = cloneExceptMethod.param(8, PropertyTree.class, "_propertyTree");
        cloneExceptMethod.body()._return((JExpression)JExpr.invoke((JMethod)cloneMethod).arg((JExpression)propertyTreeParam).arg(secondParam));
        cloneExceptMethod.annotate(Override.class);
        return cloneExceptMethod;
    }

    void generateDefaultConstructor() {
        JMethod defaultConstructor = this.classOutline.implClass.constructor(this.classOutline.implClass.isAbstract() ? 2 : 1);
        defaultConstructor.body().directStatement("// " + this.getMessage("defaultConstructor.bodyComment", new Object[0]));
        defaultConstructor.javadoc().append((Object)this.getMessage("defaultConstructor.javadoc.desc", new Object[0]));
    }

    void generateCopyConstructor(boolean partial) {
        JDefinedClass definedClass;
        JMethod constructor = definedClass.constructor((definedClass = this.classOutline.implClass).isAbstract() ? 2 : 1);
        JVar otherParam = constructor.param(8, (JType)this.classOutline.implClass, OTHER_PARAM_NAME);
        CopyGenerator cloneGenerator = this.pluginContext.createCopyGenerator(constructor, partial);
        JDocComment docComment = constructor.javadoc();
        docComment.append((Object)this.getMessage("copyConstructor.javadoc.desc", definedClass.name()));
        docComment.addParam(otherParam).append((Object)this.getMessage("copyConstructor.javadoc.param.other", definedClass.name()));
        if (partial) {
            docComment.addParam(cloneGenerator.getPropertyTreeParam()).append((Object)this.getMessage("copyConstructor.javadoc.param.propertyPath", definedClass.name()));
            docComment.addParam(cloneGenerator.getPropertyTreeUseParam()).append((Object)this.getMessage("copyConstructor.javadoc.param.propertyPathUse", definedClass.name()));
        }
        if (this.classOutline.getSuperClass() != null) {
            constructor.body().add((JStatement)cloneGenerator.generatePartialArgs(this.pluginContext._super().arg((JExpression)otherParam)));
        }
        JBlock body = constructor.body();
        this.generateFieldCopyExpressions(cloneGenerator, body, JExpr._this(), (JExpression)otherParam);
    }

    private String getMessage(String resourceKey, Object ... args) {
        return MessageFormat.format(RESOURCE_BUNDLE.getString(resourceKey), args);
    }
}

