/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.InterfaceBinding;
import com.kscs.util.plugins.xjc.PluginContext;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.fmt.JTextFile;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.txw2.output.XmlSerializer;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSFunction;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.jaxb.core.v2.schemagen.episode.Bindings;
import org.glassfish.jaxb.core.v2.schemagen.episode.SchemaBindings;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EpisodeBuilder {
    private final PluginContext pluginContext;
    private final String episodeFileName;
    private final List<OutlineAdaptor> outlines = new ArrayList<OutlineAdaptor>();

    public EpisodeBuilder(PluginContext pluginContext, String episodeFileName) {
        this.pluginContext = pluginContext;
        this.episodeFileName = episodeFileName;
    }

    public EpisodeBuilder addInterface(XSDeclaration schemaComponent, JDefinedClass iface) {
        this.outlines.add(new OutlineAdaptor((XSComponent)schemaComponent, OutlineAdaptor.OutlineType.INTERFACE, iface));
        return this;
    }

    public EpisodeBuilder addClass(ClassOutline classOutline) {
        this.outlines.add(new OutlineAdaptor(classOutline.target.getSchemaComponent(), OutlineAdaptor.OutlineType.CLASS, classOutline.implClass));
        return this;
    }

    public EpisodeBuilder addEnum(EnumOutline enumOutline) {
        this.outlines.add(new OutlineAdaptor(enumOutline.target.getSchemaComponent(), OutlineAdaptor.OutlineType.ENUM, enumOutline.clazz));
        return this;
    }

    public void build() throws SAXException {
        LinkedHashMap<XSSchema, PerSchemaOutlineAdaptors> perSchema = new LinkedHashMap<XSSchema, PerSchemaOutlineAdaptors>();
        boolean hasComponentInNoNamespace = false;
        for (OutlineAdaptor oa : this.outlines) {
            XSDeclaration xSDeclaration;
            XSComponent sc = oa.schemaComponent;
            if (sc == null || !(sc instanceof XSDeclaration) || (xSDeclaration = (XSDeclaration)sc).isLocal()) continue;
            PerSchemaOutlineAdaptors list = (PerSchemaOutlineAdaptors)perSchema.get(xSDeclaration.getOwnerSchema());
            if (list == null) {
                list = new PerSchemaOutlineAdaptors();
                perSchema.put(xSDeclaration.getOwnerSchema(), list);
            }
            list.add(oa);
            if (!"".equals(xSDeclaration.getTargetNamespace())) continue;
            hasComponentInNoNamespace = true;
        }
        try (StringWriter stringWriter = new StringWriter();){
            Bindings bindings = (Bindings)TXW.create(Bindings.class, (XmlSerializer)new StreamSerializer((Writer)stringWriter));
            if (hasComponentInNoNamespace) {
                bindings._namespace("https://jakarta.ee/xml/ns/jaxb", "jaxb");
            } else {
                bindings._namespace("https://jakarta.ee/xml/ns/jaxb", "");
            }
            bindings._namespace("http://www.kscs.com/util/jaxb/bindings", "kscs");
            bindings.version("3.0");
            bindings._comment((Object)("\n\n" + this.pluginContext.opt.getPrologComment() + "\n  "));
            for (Map.Entry entry : perSchema.entrySet()) {
                String packageName;
                PerSchemaOutlineAdaptors ps = (PerSchemaOutlineAdaptors)entry.getValue();
                Bindings group = bindings.bindings();
                String tns = ((XSSchema)entry.getKey()).getTargetNamespace();
                if ("http://www.w3.org/XML/1998/namespace".equals(tns)) {
                    group._namespace(tns, "xml");
                } else if (!"".equals(tns)) {
                    group._namespace(tns, "tns");
                }
                group.scd("x-schema::" + ("".equals(tns) ? "" : ("http://www.w3.org/XML/1998/namespace".equals(tns) ? "xml" : "tns")));
                group._attribute("if-exists", (Object)"true");
                SchemaBindings schemaBindings = group.schemaBindings();
                schemaBindings.map(false);
                if (ps.packageNames.size() == 1 && (packageName = ps.packageNames.iterator().next()) != null && packageName.length() > 0) {
                    schemaBindings._package().name(packageName);
                }
                for (OutlineAdaptor oa : ps.outlineAdaptors) {
                    Bindings child = group.bindings();
                    oa.buildBindings(child);
                }
                group.commit(true);
            }
            bindings.commit();
            String unqualifiedEpisodeFileName = this.episodeFileName.substring(this.episodeFileName.lastIndexOf(47) + 1);
            JPackage jPackage = this.pluginContext.codeModel._package(this.episodeFileName.substring(0, this.episodeFileName.lastIndexOf(47)).replace('/', '.'));
            JTextFile jTextFile = new JTextFile(unqualifiedEpisodeFileName);
            jTextFile.setContents(stringWriter.toString());
            jPackage.addResourceFile((JResourceFile)jTextFile);
        }
        catch (IOException e) {
            this.pluginContext.errorHandler.error(new SAXParseException("Failed to write to " + this.episodeFileName, null, e));
        }
    }

    static final class OutlineAdaptor {
        private static final XSFunction<String> SCD = new XSFunction<String>(){

            private String name(XSDeclaration decl) {
                if ("".equals(decl.getTargetNamespace())) {
                    return decl.getName();
                }
                if ("http://www.w3.org/XML/1998/namespace".equals(decl.getTargetNamespace())) {
                    return "xml:" + decl.getName();
                }
                return "tns:" + decl.getName();
            }

            public String complexType(XSComplexType type) {
                return "~" + this.name((XSDeclaration)type);
            }

            public String simpleType(XSSimpleType simpleType) {
                return "~" + this.name((XSDeclaration)simpleType);
            }

            public String elementDecl(XSElementDecl decl) {
                return this.name((XSDeclaration)decl);
            }

            public String modelGroupDecl(XSModelGroupDecl decl) {
                return "group::" + this.name((XSDeclaration)decl);
            }

            public String attGroupDecl(XSAttGroupDecl decl) {
                return "attributeGroup::" + this.name((XSDeclaration)decl);
            }

            public String annotation(XSAnnotation ann) {
                throw new UnsupportedOperationException();
            }

            public String attributeDecl(XSAttributeDecl decl) {
                throw new UnsupportedOperationException();
            }

            public String attributeUse(XSAttributeUse use) {
                throw new UnsupportedOperationException();
            }

            public String schema(XSSchema schema) {
                throw new UnsupportedOperationException();
            }

            public String facet(XSFacet facet) {
                throw new UnsupportedOperationException();
            }

            public String notation(XSNotation notation) {
                throw new UnsupportedOperationException();
            }

            public String identityConstraint(XSIdentityConstraint decl) {
                throw new UnsupportedOperationException();
            }

            public String xpath(XSXPath xpath) {
                throw new UnsupportedOperationException();
            }

            public String particle(XSParticle particle) {
                throw new UnsupportedOperationException();
            }

            public String empty(XSContentType empty) {
                throw new UnsupportedOperationException();
            }

            public String wildcard(XSWildcard wc) {
                throw new UnsupportedOperationException();
            }

            public String modelGroup(XSModelGroup group) {
                throw new UnsupportedOperationException();
            }
        };
        final XSComponent schemaComponent;
        final OutlineType outlineType;
        final String implName;
        final String packageName;

        public OutlineAdaptor(XSComponent schemaComponent, OutlineType outlineType, String implName, String packageName) {
            this.schemaComponent = schemaComponent;
            this.outlineType = outlineType;
            this.implName = implName;
            this.packageName = packageName;
        }

        public OutlineAdaptor(XSComponent schemaComponent, OutlineType outlineType, JDefinedClass javaType) {
            this.schemaComponent = schemaComponent;
            this.outlineType = outlineType;
            this.implName = javaType.fullName();
            this.packageName = javaType.getPackage().name();
        }

        void buildBindings(Bindings bindings) {
            bindings.scd((String)this.schemaComponent.apply(SCD));
            this.outlineType.bindingsBuilder.build(this, bindings);
        }

        public static enum OutlineType {
            CLASS(new BindingsBuilder(){

                @Override
                public void build(OutlineAdaptor adaptor, Bindings bindings) {
                    bindings.klass().ref(adaptor.implName);
                }
            }),
            ENUM(new BindingsBuilder(){

                @Override
                public void build(OutlineAdaptor adaptor, Bindings bindings) {
                    bindings.typesafeEnumClass().ref(adaptor.implName);
                }
            }),
            INTERFACE(new BindingsBuilder(){

                @Override
                public void build(OutlineAdaptor adaptor, Bindings bindings) {
                    ((InterfaceBinding)bindings._element("http://www.kscs.com/util/jaxb/bindings", "interface", InterfaceBinding.class)).ref(adaptor.implName);
                }
            });

            public final BindingsBuilder bindingsBuilder;

            private OutlineType(BindingsBuilder bindingsBuilder) {
                this.bindingsBuilder = bindingsBuilder;
            }

            public static interface BindingsBuilder {
                public void build(OutlineAdaptor var1, Bindings var2);
            }
        }
    }

    private static final class PerSchemaOutlineAdaptors {
        private final List<OutlineAdaptor> outlineAdaptors = new ArrayList<OutlineAdaptor>();
        private final Set<String> packageNames = new HashSet<String>();

        private PerSchemaOutlineAdaptors() {
        }

        private void add(OutlineAdaptor outlineAdaptor) {
            this.outlineAdaptors.add(outlineAdaptor);
            this.packageNames.add(outlineAdaptor.packageName);
        }
    }
}

