/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.Selector;
import com.kscs.util.plugins.xjc.BuilderGenerator;
import com.kscs.util.plugins.xjc.BuilderGeneratorSettings;
import com.kscs.util.plugins.xjc.BuilderOutline;
import com.kscs.util.plugins.xjc.DeepCopyPlugin;
import com.kscs.util.plugins.xjc.JavadocUtils;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.SchemaAnnotationUtils;
import com.kscs.util.plugins.xjc.SelectorGenerator;
import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.Opt;
import com.kscs.util.plugins.xjc.codemodel.ClassName;
import com.kscs.util.plugins.xjc.outline.DefinedClassOutline;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.LinkedHashMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FluentBuilderPlugin
extends AbstractPlugin {
    @Opt
    private final String rootSelectorClassName = "Select";
    @Opt
    protected String newBuilderMethodName = "builder";
    @Opt
    protected String newCopyBuilderMethodName = "newCopyBuilder";
    @Opt
    protected String copyToMethodName = "copyTo";
    @Opt
    protected String builderFieldSuffix = "_Builder";
    @Opt
    protected boolean generateTools = true;
    @Opt
    protected boolean narrow = false;
    @Opt
    protected boolean copyPartial = true;
    @Opt
    protected String selectorClassName = "Selector";
    @Opt
    protected String builderClassName = "Builder";
    @Opt
    protected String builderInterfaceName = "BuildSupport";
    @Opt
    protected boolean copyAlways = false;
    @Opt
    protected String buildMethodName = "build";
    @Opt
    protected String endMethodName = "end";
    @Opt
    protected boolean generateJavadocFromAnnotations = false;

    public String getOptionName() {
        return "Xfluent-builder";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        LinkedHashMap<String, BuilderOutline> builderClasses = new LinkedHashMap<String, BuilderOutline>(outline.getClasses().size());
        PluginContext pluginContext = PluginContext.get(outline, opt, errorHandler);
        if (this.generateTools) {
            pluginContext.writeSourceFile(Buildable.class);
        }
        if (this.copyPartial) {
            if (this.generateTools) {
                pluginContext.writeSourceFile(PropertyTreeUse.class);
                pluginContext.writeSourceFile(PropertyTree.class);
                pluginContext.writeSourceFile(Selector.class);
            }
            if (pluginContext.findPlugin(DeepCopyPlugin.class) == null) {
                SelectorGenerator selectorGenerator = new SelectorGenerator(pluginContext, Selector.class, this.selectorClassName, this.rootSelectorClassName, null, null, pluginContext.cloneGraphClass);
                selectorGenerator.generateMetaFields();
            }
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass definedClass = classOutline.implClass;
            try {
                BuilderOutline builderOutline = new BuilderOutline(new DefinedClassOutline(classOutline), (JClass)classOutline.implClass._class(17, this.builderClassName, ClassType.CLASS));
                builderClasses.put(definedClass.fullName(), builderOutline);
            }
            catch (JClassAlreadyExistsException caex) {
                errorHandler.warning(new SAXParseException(this.getMessage("error.builderClassExists", new Object[]{definedClass.name()}), classOutline.target.getLocator(), (Exception)((Object)caex)));
            }
        }
        for (BuilderOutline builderOutline : builderClasses.values()) {
            BuilderGenerator builderGenerator = new BuilderGenerator(pluginContext, builderClasses, builderOutline, this.getSettings());
            builderGenerator.buildProperties();
        }
        if (this.getSettings().isGeneratingJavadocFromAnnotations()) {
            for (EnumOutline enumOutline : outline.getEnums()) {
                if (!(enumOutline.getTarget() instanceof CEnumLeafInfo)) continue;
                String schemaAnnotation = SchemaAnnotationUtils.getEnumAnnotationDescription((CEnumLeafInfo)enumOutline.getTarget());
                JavadocUtils.appendJavadocParagraph((JDocCommentable)enumOutline.getImplClass(), schemaAnnotation);
            }
        }
        return true;
    }

    public BuilderGeneratorSettings getSettings() {
        return new BuilderGeneratorSettings(this.copyPartial, this.narrow, this.newBuilderMethodName, this.newCopyBuilderMethodName, this.builderFieldSuffix, new ClassName(this.builderInterfaceName, this.builderClassName), this.copyToMethodName, this.copyAlways, this.buildMethodName, this.endMethodName, this.generateJavadocFromAnnotations);
    }
}

