/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.GroupInterfaceModelProcessingStrategy;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.ClassSelector;
import com.sun.tools.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIClass;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.impl.AnnotationImpl;
import com.sun.xml.xsom.impl.ComplexTypeImpl;
import com.sun.xml.xsom.impl.EmptyImpl;
import com.sun.xml.xsom.impl.ForeignAttributesImpl;
import com.sun.xml.xsom.impl.ModelGroupImpl;
import com.sun.xml.xsom.impl.ParticleImpl;
import com.sun.xml.xsom.impl.Ref;
import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.impl.SchemaSetImpl;
import com.sun.xml.xsom.impl.parser.SchemaDocumentImpl;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class GroupInterfaceDirectStrategy
implements GroupInterfaceModelProcessingStrategy {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(GroupInterfaceDirectStrategy.class.getName());

    @Override
    public void onPluginActivation(Options opts) {
    }

    @Override
    public void onPostProcessModel(Model model, ErrorHandler errorHandler) {
        ClassSelector cs = (ClassSelector)Ring.get(ClassSelector.class);
        SimpleTypeBuilder stb = (SimpleTypeBuilder)Ring.get(SimpleTypeBuilder.class);
        XSSchemaSet schemaSet = (XSSchemaSet)Ring.get(XSSchemaSet.class);
        for (XSSchema s : schemaSet.getSchemas()) {
            for (XSAttGroupDecl t : s.getAttGroupDecls().values()) {
                model.typeUses().put(GroupInterfaceDirectStrategy.getName((XSDeclaration)t), cs.bindToType((XSComplexType)this.generateComplexTypeFromAttGroupDecl(model, t), (XSComponent)s, true));
            }
            for (XSAttGroupDecl t : s.getModelGroupDecls().values()) {
                model.typeUses().put(GroupInterfaceDirectStrategy.getName((XSDeclaration)t), cs.bindToType((XSComplexType)this.generateComplexTypeFromModelGroupDecl(model, (XSModelGroupDecl)t), (XSComponent)s, true));
            }
        }
    }

    public static QName getName(XSDeclaration decl) {
        String local = decl.getName();
        if (local == null) {
            return null;
        }
        return new QName(decl.getTargetNamespace(), local);
    }

    private AnnotationHolder replaceInterfaceAnnotation(Model model, XSDeclaration component) {
        return model.getCustomizations().stream().filter(GroupInterfaceDirectStrategy::isInterfaceDecl).filter(c -> GroupInterfaceDirectStrategy.isAssignedToComponent(c, component)).findFirst().map(inputAnnotation -> {
            inputAnnotation.markAsAcknowledged();
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BIClass.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                Element newElement = inputAnnotation.element.getOwnerDocument().createElementNS("https://jakarta.ee/xml/ns/jaxb", "class");
                if (!inputAnnotation.element.getAttribute("name").isEmpty()) {
                    newElement.setAttribute("name", inputAnnotation.element.getAttribute("name"));
                }
                if (!inputAnnotation.element.getAttribute("ref").isEmpty()) {
                    newElement.setAttribute("ref", inputAnnotation.element.getAttribute("ref"));
                }
                JAXBElement biClass = unmarshaller.unmarshal((Node)newElement, BIClass.class);
                BindInfo newBindInfo = new BindInfo();
                newBindInfo.setOwner((BGMBuilder)Ring.get(BGMBuilder.class), (XSComponent)component);
                newBindInfo.addDecl((BIDeclaration)biClass.getValue());
                return new AnnotationHolder(new AnnotationImpl((Object)newBindInfo, component.getLocator()), (AnnotationImpl)component.getAnnotation());
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }).orElse(new AnnotationHolder((AnnotationImpl)component.getAnnotation(), (AnnotationImpl)component.getAnnotation()));
    }

    private static boolean isInterfaceDecl(CPluginCustomization customization) {
        return customization.element.getNamespaceURI().equals("http://www.kscs.com/util/jaxb/bindings") && customization.element.getLocalName().equals("interface");
    }

    private static boolean isAssignedToComponent(CPluginCustomization customization, XSDeclaration component) {
        return customization.element.getAttribute("groupName").equals(component.getName()) && customization.element.getAttribute("groupNamespace").equals(component.getTargetNamespace());
    }

    private ComplexTypeImpl generateComplexTypeFromAttGroupDecl(Model model, XSAttGroupDecl attGroupDecl) {
        XSSchemaSet schemaSet = model.schemaComponent;
        AnnotationHolder replacedAnnotation = this.replaceInterfaceAnnotation(model, (XSDeclaration)attGroupDecl);
        ComplexTypeImpl complexType = new ComplexTypeImpl((SchemaDocumentImpl)attGroupDecl.getSourceDocument(), replacedAnnotation.annotation, attGroupDecl.getLocator(), (ForeignAttributesImpl)attGroupDecl.getForeignAttributes().get(0), attGroupDecl.getName(), false, true, 1, (Ref.Type)((SchemaSetImpl.AnyType)schemaSet.getAnyType()), 0, 0, false);
        complexType.addAttGroup((Ref.AttGroup)new AttGroup(attGroupDecl.getLocator(), (SchemaImpl)attGroupDecl.getOwnerSchema(), attGroupDecl));
        complexType.setContentType((Ref.ContentType)new EmptyImpl());
        complexType.setExplicitContent((XSContentType)new EmptyImpl());
        replacedAnnotation.setOwner((XSComponent)complexType);
        return complexType;
    }

    private ComplexTypeImpl generateComplexTypeFromModelGroupDecl(Model model, XSModelGroupDecl modelGroupDecl) {
        XSSchemaSet schemaSet = model.schemaComponent;
        AnnotationHolder replacedAnnotation = this.replaceInterfaceAnnotation(model, (XSDeclaration)modelGroupDecl);
        SchemaDocumentImpl sourceDocument = (SchemaDocumentImpl)modelGroupDecl.getSourceDocument();
        SchemaImpl ownerSchema = (SchemaImpl)modelGroupDecl.getOwnerSchema();
        Locator locator = modelGroupDecl.getLocator();
        ComplexTypeImpl complexType = new ComplexTypeImpl(sourceDocument, replacedAnnotation.annotation, locator, (ForeignAttributesImpl)modelGroupDecl.getForeignAttributes().get(0), modelGroupDecl.getName(), modelGroupDecl.isLocal(), true, 1, (Ref.Type)((SchemaSetImpl.AnyType)schemaSet.getAnyType()), 0, 0, false);
        AnnotationImpl annotation = replacedAnnotation.originalAnnotation;
        ParticleImpl modelGroupRefParticle = new ParticleImpl(sourceDocument, annotation, (Ref.Term)new ModelGroup(locator, ownerSchema, modelGroupDecl), locator);
        ModelGroupImpl contentModelGroup = new ModelGroupImpl(sourceDocument, annotation, locator, (ForeignAttributesImpl)modelGroupDecl.getForeignAttributes().get(0), XSModelGroup.Compositor.SEQUENCE, new ParticleImpl[]{modelGroupRefParticle});
        complexType.setContentType((Ref.ContentType)new ParticleImpl(sourceDocument, annotation, (Ref.Term)contentModelGroup, locator));
        complexType.setExplicitContent((XSContentType)new EmptyImpl());
        replacedAnnotation.setOwner((XSComponent)complexType);
        return complexType;
    }

    private static String formatMessage(String messageKey, String ... args) {
        return MessageFormat.format(RESOURCE_BUNDLE.getString(messageKey), args);
    }

    private static class AnnotationHolder {
        private final AnnotationImpl annotation;
        private final AnnotationImpl originalAnnotation;

        private AnnotationHolder(AnnotationImpl annotation, AnnotationImpl originalAnnotation) {
            this.annotation = annotation;
            this.originalAnnotation = originalAnnotation;
        }

        final void setOwner(XSComponent owner) {
            if (this.annotation != null) {
                BindInfo bindInfo = (BindInfo)this.annotation.getAnnotation();
                bindInfo.setOwner(bindInfo.getBuilder(), owner);
            }
        }
    }

    public static class AttGroup
    implements Ref.AttGroup {
        private final Locator locator;
        private final SchemaImpl schema;
        private final XSAttGroupDecl ref;

        public AttGroup(Locator locator, SchemaImpl schema, XSAttGroupDecl ref) {
            this.locator = locator;
            this.schema = schema;
            this.ref = ref;
        }

        public XSAttGroupDecl get() {
            return this.ref;
        }
    }

    public static class ModelGroup
    implements Ref.Term {
        private final Locator locator;
        private final SchemaImpl schema;
        private final XSModelGroupDecl ref;

        public ModelGroup(Locator locator, SchemaImpl schema, XSModelGroupDecl ref) {
            this.locator = locator;
            this.schema = schema;
            this.ref = ref;
        }

        public XSModelGroupDecl get() {
            return this.ref;
        }

        public XSTerm getTerm() {
            return this.ref;
        }
    }
}

