/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.bindings.Interface;
import com.kscs.util.plugins.xjc.GroupInterfaceModelProcessingStrategy;
import com.kscs.util.plugins.xjc.ResettableStringReader;
import com.kscs.util.plugins.xjc.base.MappingNamespaceContext;
import com.kscs.util.plugins.xjc.base.XPathContext;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GroupInterfaceDummyStrategy
implements GroupInterfaceModelProcessingStrategy {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(GroupInterfaceDummyStrategy.class.getName());
    private static final XPathFactory X_PATH_FACTORY = XPathFactory.newInstance();
    public static final TransformerFactory TRANSFORMER_FACTORY;
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private static final DocumentBuilder DOCUMENT_BUILDER;

    public void generateDummyGroupUsages(Options opts) throws BadCommandLineException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            XPath xPath = X_PATH_FACTORY.newXPath();
            MappingNamespaceContext namespaceContext = new MappingNamespaceContext().add("xs", "http://www.w3.org/2001/XMLSchema").add("kscs", "http://www.kscs.com/util/jaxb/bindings").add("jxb", "https://jakarta.ee/xml/ns/jaxb");
            xPath.setNamespaceContext((NamespaceContext)namespaceContext);
            XPathExpression attGroupExpression = xPath.compile("/xs:schema/xs:attributeGroup");
            XPathExpression modelGroupExpression = xPath.compile("/xs:schema/xs:group");
            XPathExpression targetNamespaceExpression = xPath.compile("/xs:schema/@targetNamespace");
            Map<String, List<String>> includeMappings = GroupInterfaceDummyStrategy.findIncludeMappings(xPath, opts.getGrammars());
            ArrayList<InputSource> newGrammars = new ArrayList<InputSource>();
            for (InputSource grammarSource : opts.getGrammars()) {
                Document grammar = GroupInterfaceDummyStrategy.copyInputSource(grammarSource);
                String declaredTargetNamespaceUri = targetNamespaceExpression.evaluate(grammar);
                for (String targetNamespaceUri : declaredTargetNamespaceUri == null ? includeMappings.get(grammarSource.getSystemId()) : Collections.singletonList(declaredTargetNamespaceUri)) {
                    Element node;
                    int i;
                    NodeList attGroupNodes = (NodeList)attGroupExpression.evaluate(grammar, XPathConstants.NODESET);
                    NodeList modelGroupNodes = (NodeList)modelGroupExpression.evaluate(grammar, XPathConstants.NODESET);
                    Groups currentGroups = new Groups(targetNamespaceUri);
                    for (i = 0; i < attGroupNodes.getLength(); ++i) {
                        node = (Element)attGroupNodes.item(i);
                        currentGroups.attGroupNames.add(node.getAttribute("name"));
                    }
                    for (i = 0; i < modelGroupNodes.getLength(); ++i) {
                        node = (Element)modelGroupNodes.item(i);
                        currentGroups.modelGroupNames.add(node.getAttribute("name"));
                    }
                    InputSource newSchema = GroupInterfaceDummyStrategy.generateImplementationSchema(opts, transformer, currentGroups, grammarSource.getSystemId());
                    if (newSchema == null) continue;
                    newGrammars.add(newSchema);
                }
            }
            for (InputSource newGrammar : newGrammars) {
                opts.addGrammar(newGrammar);
            }
        }
        catch (Exception e) {
            throw new BadCommandLineException(GroupInterfaceDummyStrategy.formatMessage("error.plugin-setup", e));
        }
    }

    private static Document copyInputSource(InputSource inputSource) throws IOException, SAXException {
        String validSystemIdOrNull;
        Reader characterStream = inputSource.getCharacterStream();
        InputStream byteStream = inputSource.getByteStream();
        String string = validSystemIdOrNull = inputSource.getSystemId().equals("null") ? null : inputSource.getSystemId();
        if (characterStream != null) {
            StringWriter stringWriter = new StringWriter();
            BufferedReader bufferedReader = new BufferedReader(characterStream);
            try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    printWriter.println(line);
                }
            }
            inputSource.setCharacterStream(new StringReader(stringWriter.toString()));
            InputSource copy = new InputSource(new StringReader(stringWriter.toString()));
            copy.setSystemId(validSystemIdOrNull);
            copy.setPublicId(inputSource.getPublicId());
            copy.setEncoding(inputSource.getEncoding());
            return DOCUMENT_BUILDER.parse(copy);
        }
        if (byteStream != null) {
            int bytesRead;
            int blockSize = 8192;
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((bytesRead = byteStream.read(buffer, 0, 8192)) > -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byteArrayOutputStream.close();
            byte[] allBytes = byteArrayOutputStream.toByteArray();
            inputSource.setByteStream(new ByteArrayInputStream(allBytes));
            InputSource copy = new InputSource(new ByteArrayInputStream(allBytes));
            copy.setSystemId(validSystemIdOrNull);
            copy.setPublicId(inputSource.getPublicId());
            copy.setEncoding(inputSource.getEncoding());
            return DOCUMENT_BUILDER.parse(copy);
        }
        InputSource copy = new InputSource(validSystemIdOrNull);
        copy.setPublicId(inputSource.getPublicId());
        copy.setEncoding(inputSource.getEncoding());
        return DOCUMENT_BUILDER.parse(copy);
    }

    private static InputSource generateImplementationSchema(Options opts, Transformer transformer, Groups namespaceGroups, String systemId) throws TransformerException {
        if (!namespaceGroups.attGroupNames.isEmpty() || !namespaceGroups.modelGroupNames.isEmpty()) {
            Element complexTypeEl;
            Document dummySchema = DOCUMENT_BUILDER.newDocument();
            dummySchema.setXmlVersion("1.0");
            String targetNamespacePrefix = "http://www.w3.org/XML/1998/namespace".equals(namespaceGroups.targetNamespace) ? "xml" : "tns";
            Element rootEl = dummySchema.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
            rootEl.setAttribute("version", "1.0");
            rootEl.setAttribute("targetNamespace", namespaceGroups.targetNamespace);
            rootEl.setAttribute("elementFormDefault", "qualified");
            rootEl.setAttribute("xmlns:" + targetNamespacePrefix, namespaceGroups.targetNamespace);
            dummySchema.appendChild(rootEl);
            Element importEl = dummySchema.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:include");
            importEl.setAttribute("schemaLocation", systemId);
            rootEl.appendChild(importEl);
            for (String attGroupName : namespaceGroups.attGroupNames) {
                complexTypeEl = dummySchema.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                complexTypeEl.setAttribute("name", attGroupName);
                rootEl.appendChild(complexTypeEl);
                Element attGroupRefEl = dummySchema.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:attributeGroup");
                attGroupRefEl.setAttribute("ref", targetNamespacePrefix + ":" + attGroupName);
                complexTypeEl.appendChild(attGroupRefEl);
            }
            for (String modelGroupName : namespaceGroups.modelGroupNames) {
                complexTypeEl = dummySchema.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:complexType");
                complexTypeEl.setAttribute("name", modelGroupName);
                rootEl.appendChild(complexTypeEl);
                Element sequenceEl = dummySchema.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:sequence");
                complexTypeEl.appendChild(sequenceEl);
                Element modelGroupRefEl = dummySchema.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:group");
                modelGroupRefEl.setAttribute("ref", targetNamespacePrefix + ":" + modelGroupName);
                sequenceEl.appendChild(modelGroupRefEl);
            }
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(new DOMSource(dummySchema), streamResult);
            ResettableStringReader stringReader = new ResettableStringReader(stringWriter.toString());
            InputSource inputSource = new InputSource(stringReader);
            int suffixPos = systemId.lastIndexOf(46);
            String baseName = suffixPos > 0 ? systemId.substring(0, suffixPos) : systemId;
            inputSource.setSystemId(baseName + "-impl.xsd");
            return inputSource;
        }
        return null;
    }

    private static Map<String, List<String>> findIncludeMappings(XPath xPath, InputSource[] grammars) throws XPathExpressionException {
        XPathExpression includeExpression = xPath.compile("/xs:schema/xs:include/@schemaLocation");
        XPathExpression targetNamespaceExpression = xPath.compile("/xs:schema/@targetNamespace");
        HashMap<String, List<String>> mappings = new HashMap<String, List<String>>();
        for (InputSource grammar : grammars) {
            Node targetNamespaceNode = (Node)targetNamespaceExpression.evaluate(grammar, XPathConstants.NODE);
            NodeList includeNodes = (NodeList)includeExpression.evaluate(grammar, XPathConstants.NODESET);
            if (targetNamespaceNode == null) continue;
            for (int i = 0; i < includeNodes.getLength(); ++i) {
                String includedSchema = includeNodes.item(i).getNodeValue();
                ArrayList<String> includers = (ArrayList<String>)mappings.get(includedSchema);
                if (includers == null) {
                    includers = new ArrayList<String>();
                    mappings.put(includedSchema, includers);
                }
                includers.add(targetNamespaceNode.getNodeValue());
            }
        }
        return mappings;
    }

    private void processCustomizations(Element elementAnnotation, NodeList childAnnotations) {
        Interface interfaceCustomization = (Interface)JAXB.unmarshal((Source)new DOMSource(elementAnnotation), Interface.class);
    }

    @Override
    public void onPostProcessModel(Model model, ErrorHandler errorHandler) {
    }

    @Override
    public void onPluginActivation(Options opts) throws BadCommandLineException {
        this.generateDummyGroupUsages(opts);
    }

    private static String formatMessage(String messageKey, Object ... args) {
        return MessageFormat.format(RESOURCE_BUNDLE.getString(messageKey), args);
    }

    static {
        try {
            TRANSFORMER_FACTORY = TransformerFactory.newInstance();
            DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
            DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
            DOCUMENT_BUILDER = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Groups {
        public final String targetNamespace;
        public final List<String> attGroupNames = new ArrayList<String>();
        public final List<String> modelGroupNames = new ArrayList<String>();

        public Groups(String targetNamespace) {
            this.targetNamespace = targetNamespace;
        }
    }

    public static class CustomizationContext {
        private final String type;
        private final String name;
        private final String targetNamespace;
        private final Interface item;
        private final CustomizationContext parent;
        private final Map<String, CustomizationContext> children = new HashMap<String, CustomizationContext>();

        public CustomizationContext(String type, String targetNamespace, String name, Interface item, CustomizationContext parent) {
            this.type = type;
            this.targetNamespace = targetNamespace;
            this.name = name;
            this.item = item;
            this.parent = parent;
            this.parent.children.put(this.getQualifiedName(), this);
        }

        public final String getQualifiedName() {
            return this.type + (String)(this.targetNamespace == null ? "::" : "::{" + this.targetNamespace + "}") + (this.name == null ? "" : this.name);
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Interface getItem() {
            return this.item;
        }

        public CustomizationContext getParent() {
            return this.parent;
        }

        public Map<String, CustomizationContext> getChildren() {
            return this.children;
        }

        public boolean isEmpty() {
            return this.item == null && this.children.isEmpty();
        }
    }

    private static class CustomizationParser {
        private CustomizationContext rootCustomizationContext = new CustomizationContext("global", null, null, null, null);
        private final XPath xPath;
        private final XPathContext elementDefsExpression;
        private final XPathContext attributeDefsExpression;
        private final XPathContext attGroupDefsExpression;
        private final XPathContext modelGroupDefsExpression;
        private final XPathContext descendantElementDefsExpression;
        private final XPathContext descendantInterfaceExpression;
        private final XPathContext targetPathExpression;
        private final XPathContext schemaLocationExpression;
        private final XPathContext customizationExpression;
        private final InputSource[] bindFiles;
        private final Map<String, InputSource> grammars;
        private final Unmarshaller unmarshaller;

        CustomizationParser(XPath xPath, InputSource[] grammars, InputSource[] bindFiles) throws XPathExpressionException, JAXBException {
            this.xPath = xPath;
            this.elementDefsExpression = new XPathContext(xPath.compile("xs:element[xs:annotation/xs:appInfo/kscs:interface]"));
            this.attributeDefsExpression = new XPathContext(xPath.compile("xs:attribute[xs:annotation/xs:appInfo/kscs:interface]"));
            this.attGroupDefsExpression = new XPathContext(xPath.compile("xs:attributeGroup[xs:annotation/xs:appInfo/kscs:interface or xs:attribute[xs:annotation/xs:appInfo/kscs:interface]]"));
            this.modelGroupDefsExpression = new XPathContext(xPath.compile("xs:group[xs:annotation/xs:appInfo/kscs:interface or descendant::xs:element[xs:annotation/xs:appInfo/kscs:interface]]"));
            this.descendantElementDefsExpression = new XPathContext(xPath.compile("descendant::xs:element[xs:annotation/xs:appInfo/kscs:interface]"));
            this.descendantInterfaceExpression = new XPathContext(xPath.compile("descendant::kscs:interface"));
            this.targetPathExpression = new XPathContext(xPath.compile("ancestor::jxb:bindings/@node"));
            this.schemaLocationExpression = new XPathContext(xPath.compile("ancestor::jxb:bindings/@schemaLocation"));
            this.customizationExpression = new XPathContext(xPath.compile("xs:annotation/xs:appInfo/kscs:interface"));
            this.grammars = new HashMap<String, InputSource>(grammars.length);
            for (InputSource grammar : grammars) {
                this.grammars.put(grammar.getSystemId(), grammar);
            }
            this.bindFiles = bindFiles;
            this.unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Interface.class}).createUnmarshaller();
        }

        private void inlineBindings() throws XPathExpressionException, JAXBException {
            for (InputSource bindFile : this.bindFiles) {
                for (Element customizationElement : this.descendantInterfaceExpression.selectElements(bindFile)) {
                    StringBuilder targetPathBuilder = null;
                    List targetPathNodes = this.targetPathExpression.selectElements((Node)customizationElement);
                    for (int t = targetPathNodes.size() - 1; t <= 0; --t) {
                        Node node = (Node)targetPathNodes.get(t);
                        if (targetPathBuilder == null) {
                            targetPathBuilder = new StringBuilder();
                        } else {
                            targetPathBuilder.append("/");
                        }
                        targetPathBuilder.append(node.getNodeValue());
                    }
                    if (targetPathBuilder != null) {
                        XPathContext targetPath = new XPathContext(this.xPath.compile(targetPathBuilder.toString()));
                        String schemaLocation = this.schemaLocationExpression.selectText((Node)customizationElement);
                        URI bindFileUri = URI.create(bindFile.getSystemId());
                        InputSource grammar = this.grammars.get(bindFileUri.resolve(schemaLocation).toString());
                        Element targetElement = targetPath.selectElement(grammar);
                        if (targetElement == null) continue;
                        this.createAnnotation(targetElement, customizationElement);
                        continue;
                    }
                    this.rootCustomizationContext = new CustomizationContext("global", null, null, (Interface)this.unmarshaller.unmarshal((Source)new DOMSource(customizationElement), Interface.class).getValue(), null);
                }
            }
        }

        private void createAnnotation(Element targetElement, Element customizationElement) {
            Document document = targetElement.getOwnerDocument();
            Node imported = document.importNode(customizationElement, true);
            Element annotationEl = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:annotation");
            Element appInfoEl = document.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:appInfo");
            appInfoEl.appendChild(imported);
            annotationEl.appendChild(appInfoEl);
            targetElement.appendChild(annotationEl);
        }

        void parse() throws XPathExpressionException, JAXBException, IOException, SAXException {
            this.inlineBindings();
            for (InputSource grammar : this.grammars.values()) {
                CustomizationContext groupContext;
                Document doc = DOCUMENT_BUILDER.parse(grammar);
                Element schemaEl = doc.getDocumentElement();
                String targetNamespace = schemaEl.getAttribute("targetNamespace");
                CustomizationContext schemaContext = this.parse(this.rootCustomizationContext, schemaEl, targetNamespace);
                for (Element elementEl : this.elementDefsExpression.selectElements((Node)schemaEl)) {
                    this.parse(schemaContext, elementEl, targetNamespace);
                }
                for (Element attributeEl : this.attributeDefsExpression.selectElements((Node)schemaEl)) {
                    this.parse(schemaContext, attributeEl, targetNamespace);
                }
                for (Element groupEl : this.modelGroupDefsExpression.selectElements((Node)schemaEl)) {
                    groupContext = this.parse(schemaContext, groupEl, targetNamespace);
                    for (Element elementEl : this.descendantElementDefsExpression.selectElements((Node)groupEl)) {
                        this.parse(groupContext, elementEl, targetNamespace);
                    }
                }
                for (Element attGroupEl : this.attGroupDefsExpression.selectElements((Node)schemaEl)) {
                    groupContext = this.parse(schemaContext, attGroupEl, targetNamespace);
                    for (Element attributeEl : this.descendantElementDefsExpression.selectElements((Node)attGroupEl)) {
                        this.parse(groupContext, attributeEl, targetNamespace);
                    }
                }
            }
        }

        private CustomizationContext parse(CustomizationContext parent, Element groupElement, String targetNamespace) throws XPathExpressionException, JAXBException {
            Element interfaceCustomizationEl = this.customizationExpression.selectElement((Node)groupElement);
            Interface interfaceCustomization = interfaceCustomizationEl != null ? (Interface)this.unmarshaller.unmarshal((Node)interfaceCustomizationEl, Interface.class).getValue() : null;
            return new CustomizationContext(groupElement.getLocalName(), targetNamespace, groupElement.getAttribute("name"), interfaceCustomization, parent);
        }
    }
}

