/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb._interface.Interface;
import com.kscs.util.jaxb._interface.Interfaces;
import com.kscs.util.plugins.xjc.BoundPropertiesPlugin;
import com.kscs.util.plugins.xjc.BuilderGenerator;
import com.kscs.util.plugins.xjc.BuilderOutline;
import com.kscs.util.plugins.xjc.DeepClonePlugin;
import com.kscs.util.plugins.xjc.DeepCopyPlugin;
import com.kscs.util.plugins.xjc.EpisodeBuilder;
import com.kscs.util.plugins.xjc.GroupInterfaceGeneratorSettings;
import com.kscs.util.plugins.xjc.ImmutablePlugin;
import com.kscs.util.plugins.xjc.MetaPlugin;
import com.kscs.util.plugins.xjc.ModifierGenerator;
import com.kscs.util.plugins.xjc.ModifierPlugin;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.base.AbstractXSFunction;
import com.kscs.util.plugins.xjc.outline.DefinedInterfaceOutline;
import com.kscs.util.plugins.xjc.outline.InterfaceOutline;
import com.kscs.util.plugins.xjc.outline.ReferencedInterfaceOutline;
import com.kscs.util.plugins.xjc.outline.TypeOutline;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.util.JavadocEscapeWriter;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.impl.util.SchemaWriter;
import com.sun.xml.xsom.visitor.XSFunction;
import com.sun.xml.xsom.visitor.XSVisitor;
import jakarta.xml.bind.JAXB;
import java.beans.PropertyVetoException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class GroupInterfaceGenerator {
    public static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final XSFunction<Boolean> IS_FIXED_FUNC = new AbstractXSFunction<Boolean>(){

        public Boolean attributeDecl(XSAttributeDecl decl) {
            return decl.getFixedValue() != null;
        }

        public Boolean attributeUse(XSAttributeUse use) {
            return use.getFixedValue() != null || use.getDecl().getFixedValue() != null;
        }

        public Boolean elementDecl(XSElementDecl decl) {
            return decl.getFixedValue() != null;
        }
    };
    private static final Logger LOGGER = Logger.getLogger(GroupInterfaceGenerator.class.getName());
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(GroupInterfaceGenerator.class.getName());
    private final boolean declareBuilderInterface;
    private final boolean declareModifierInterface;
    private final JClass overrideCollectionClass;
    private final boolean declareVisitMethod;
    private final PluginContext pluginContext;
    private final XSFunction<String> nameFunc = new AbstractXSFunction<String>(){

        public String attributeDecl(XSAttributeDecl decl) {
            String customName = this.getCustomPropertyName((XSComponent)decl);
            return customName == null ? GroupInterfaceGenerator.this.pluginContext.outline.getModel().getNameConverter().toPropertyName(decl.getName()) : customName;
        }

        public String attributeUse(XSAttributeUse use) {
            String customName = this.getCustomPropertyName((XSComponent)use);
            customName = customName == null ? this.getCustomPropertyName((XSComponent)use.getDecl()) : customName;
            return customName == null ? GroupInterfaceGenerator.this.pluginContext.outline.getModel().getNameConverter().toPropertyName(use.getDecl().getName()) : customName;
        }

        public String elementDecl(XSElementDecl decl) {
            String customName = this.getCustomPropertyName((XSComponent)decl);
            return customName == null ? GroupInterfaceGenerator.this.pluginContext.outline.getModel().getNameConverter().toPropertyName(decl.getName()) : customName;
        }

        private String getCustomPropertyName(XSComponent component) {
            BindInfo bindInfo;
            BIProperty biProperty;
            if (component.getAnnotation() != null && component.getAnnotation().getAnnotation() instanceof BindInfo && (biProperty = (BIProperty)(bindInfo = (BindInfo)component.getAnnotation().getAnnotation()).get(BIProperty.class)) != null) {
                String customPropertyName = biProperty.getPropertyName(false);
                return customPropertyName != null ? customPropertyName : null;
            }
            return null;
        }
    };
    private final boolean throwsPropertyVetoException;
    private final boolean immutable;
    private final boolean cloneMethodThrows;
    private final boolean needsCloneMethod;
    private final boolean needsCopyMethod;
    private final Map<String, List<TypeOutline>> interfacesByClass = new HashMap<String, List<TypeOutline>>();
    private final EpisodeBuilder episodeBuilder;
    private final Enumeration<URL> upstreamEpisodes;
    private final GroupInterfaceGeneratorSettings settings;
    private Map<QName, ReferencedInterfaceOutline> referencedInterfaces = null;

    public GroupInterfaceGenerator(PluginContext pluginContext, Enumeration<URL> upstreamEpisodes, EpisodeBuilder episodeBuilder, GroupInterfaceGeneratorSettings settings) {
        this.pluginContext = pluginContext;
        this.settings = settings;
        ImmutablePlugin immutablePlugin = this.pluginContext.findPlugin(ImmutablePlugin.class);
        this.immutable = settings.isDeclareSetters() == false || immutablePlugin != null;
        this.overrideCollectionClass = immutablePlugin != null && immutablePlugin.overrideCollectionClass != null ? this.pluginContext.codeModel.ref(immutablePlugin.overrideCollectionClass) : null;
        BoundPropertiesPlugin boundPropertiesPlugin = this.pluginContext.findPlugin(BoundPropertiesPlugin.class);
        this.throwsPropertyVetoException = boundPropertiesPlugin != null && boundPropertiesPlugin.isConstrained() && boundPropertiesPlugin.isSetterThrows();
        DeepClonePlugin deepClonePlugin = this.pluginContext.findPlugin(DeepClonePlugin.class);
        DeepCopyPlugin deepCopyPlugin = this.pluginContext.findPlugin(DeepCopyPlugin.class);
        this.declareBuilderInterface = settings.isDeclareBuilderInterface() != false && settings.getBuilderGeneratorSettings() != null;
        this.declareModifierInterface = pluginContext.hasPlugin(ModifierPlugin.class);
        MetaPlugin metaPlugin = pluginContext.findPlugin(MetaPlugin.class);
        this.declareVisitMethod = metaPlugin != null && metaPlugin.isExtended();
        this.needsCloneMethod = deepClonePlugin != null;
        this.cloneMethodThrows = this.needsCloneMethod && deepClonePlugin.isCloneThrows();
        this.needsCopyMethod = deepCopyPlugin != null;
        this.upstreamEpisodes = upstreamEpisodes;
        this.episodeBuilder = episodeBuilder;
    }

    private static List<XSModelGroupDecl> findModelGroups(Iterable<XSParticle> modelGroup) {
        ArrayList<XSModelGroupDecl> elementDecls = new ArrayList<XSModelGroupDecl>();
        for (XSParticle child : modelGroup) {
            if (child.isRepeated() || !(child.getTerm() instanceof XSModelGroupDecl)) continue;
            elementDecls.add((XSModelGroupDecl)child.getTerm());
        }
        return elementDecls;
    }

    private static Collection<? extends XSDeclaration> findModelGroups(XSComplexType complexType) {
        XSParticle particle;
        XSContentType contentType = complexType.getExplicitContent();
        if (contentType == null) {
            contentType = complexType.getContentType();
        }
        if ((particle = contentType.asParticle()) != null && !particle.isRepeated()) {
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroupDecl) {
                return Collections.singletonList((XSModelGroupDecl)term);
            }
            XSModelGroup modelGroup = term.asModelGroup();
            return modelGroup != null ? GroupInterfaceGenerator.findModelGroups((Iterable<XSParticle>)modelGroup) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private static Collection<? extends XSDeclaration> findAttributeGroups(XSComplexType complexType) {
        return complexType.getAttGroups();
    }

    private static XSComplexType getTypeDefinition(XSComponent xsTypeComponent) {
        if (xsTypeComponent instanceof XSAttContainer) {
            return (XSComplexType)xsTypeComponent;
        }
        if (xsTypeComponent instanceof XSElementDecl) {
            return ((XSElementDecl)xsTypeComponent).getType().asComplexType();
        }
        return null;
    }

    private Map<QName, ReferencedInterfaceOutline> loadInterfaceEpisodes() {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(GroupInterfaceGenerator.class.getResource("interface-bindings.xsl").toString()));
            HashMap<QName, ReferencedInterfaceOutline> interfaceMappings = new HashMap<QName, ReferencedInterfaceOutline>();
            while (this.upstreamEpisodes.hasMoreElements()) {
                HashMap<QName, ReferencedInterfaceOutline> result;
                try {
                    StreamSource episodeInput = new StreamSource(this.upstreamEpisodes.nextElement().toString());
                    DOMResult domResult = new DOMResult();
                    transformer.transform(episodeInput, domResult);
                    Interfaces interfaces = (Interfaces)JAXB.unmarshal((Source)new DOMSource(domResult.getNode()), Interfaces.class);
                    HashMap<QName, ReferencedInterfaceOutline> interfaceMappings1 = new HashMap<QName, ReferencedInterfaceOutline>();
                    for (Interface iface : interfaces.getInterface()) {
                        interfaceMappings1.put(new QName(iface.getSchemaComponent().getNamespace(), iface.getSchemaComponent().getName()), new ReferencedInterfaceOutline(this.pluginContext.codeModel.ref(iface.getName()), this.settings.getSupportInterfaceNameSuffix()));
                    }
                    result = interfaceMappings1;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                interfaceMappings.putAll(result);
            }
            return interfaceMappings;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<PropertyUse> findElementDecls(XSModelGroupDecl modelGroup) {
        ArrayList<PropertyUse> elementDecls = new ArrayList<PropertyUse>();
        for (XSParticle child : modelGroup.getModelGroup()) {
            XSTerm term = child.getTerm();
            if (term instanceof XSElementDecl) {
                elementDecls.add(new PropertyUse((XSComponent)term));
                continue;
            }
            if (!(term instanceof XSModelGroupDecl) || !((XSModelGroupDecl)term).getName().equals(modelGroup.getName())) continue;
            elementDecls.addAll(this.findElementDecls((XSModelGroupDecl)term));
        }
        return elementDecls;
    }

    private List<PropertyUse> findAttributeDecls(XSAttGroupDecl attGroupDecl) {
        ArrayList<PropertyUse> attributeDecls = new ArrayList<PropertyUse>();
        for (XSAttributeUse child : attGroupDecl.getDeclaredAttributeUses()) {
            attributeDecls.add(new PropertyUse((XSComponent)child));
        }
        return attributeDecls;
    }

    private List<PropertyUse> findChildDecls(XSDeclaration groupDecl) {
        return groupDecl instanceof XSAttGroupDecl ? this.findAttributeDecls((XSAttGroupDecl)groupDecl) : this.findElementDecls((XSModelGroupDecl)groupDecl);
    }

    private PackageOutline findPackageForNamespace(String namespaceUri) {
        for (PackageOutline packageOutline : this.pluginContext.outline.getAllPackageContexts()) {
            if (!namespaceUri.equals(packageOutline.getMostUsedNamespaceURI())) continue;
            return packageOutline;
        }
        return null;
    }

    public List<TypeOutline> getGroupInterfacesForClass(String className) {
        List<TypeOutline> interfacesForClass = this.interfacesByClass.get(className);
        ArrayList<TypeOutline> filteredInterfaces = new ArrayList<TypeOutline>();
        if (interfacesForClass != null) {
            for (TypeOutline typeOutline : interfacesForClass) {
                if (typeOutline.getImplClass().fullName().equals(className)) continue;
                filteredInterfaces.add(typeOutline);
            }
        }
        return filteredInterfaces;
    }

    void putGroupInterfaceForClass(String className, TypeOutline groupInterface) {
        List<TypeOutline> interfacesForClass = this.interfacesByClass.get(className);
        if (interfacesForClass == null) {
            interfacesForClass = new ArrayList<TypeOutline>();
            this.interfacesByClass.put(className, interfacesForClass);
        }
        interfacesForClass.add(groupInterface);
    }

    private Map<QName, DefinedInterfaceOutline> generateGroupInterfaces(Iterator<? extends XSDeclaration> groupIterator) throws SAXException {
        HashMap<QName, DefinedInterfaceOutline> groupInterfaces = new HashMap<QName, DefinedInterfaceOutline>();
        while (groupIterator.hasNext()) {
            DefinedInterfaceOutline interfaceOutline;
            XSDeclaration modelGroup = groupIterator.next();
            if (this.getReferencedInterfaces().containsKey(PluginContext.getQName(modelGroup)) || (interfaceOutline = this.createInterfaceDeclaration(modelGroup)) == null) continue;
            groupInterfaces.put(interfaceOutline.getName(), interfaceOutline);
            if (this.episodeBuilder == null) continue;
            this.episodeBuilder.addInterface(interfaceOutline.getSchemaComponent(), interfaceOutline.getImplClass());
        }
        for (DefinedInterfaceOutline typeDef : groupInterfaces.values()) {
            XSDeclaration classComponent = typeDef.getSchemaComponent();
            List<XSModelGroupDecl> groupRefs = classComponent instanceof XSAttGroupDecl ? ((XSAttGroupDecl)classComponent).getAttGroups() : GroupInterfaceGenerator.findModelGroups((Iterable<XSParticle>)((XSModelGroupDecl)classComponent).getModelGroup());
            for (XSDeclaration xSDeclaration : groupRefs) {
                if (PluginContext.getQName(xSDeclaration).equals(typeDef.getName())) continue;
                InterfaceOutline superInterfaceOutline = (InterfaceOutline)groupInterfaces.get(PluginContext.getQName(xSDeclaration));
                if (superInterfaceOutline == null) {
                    superInterfaceOutline = this.getReferencedInterfaceOutline(PluginContext.getQName(xSDeclaration));
                }
                if (superInterfaceOutline == null) continue;
                typeDef.addSuperInterface(superInterfaceOutline);
                typeDef.getImplClass()._implements(superInterfaceOutline.getImplClass());
                if (typeDef.getSupportInterface() != null) {
                    typeDef.getSupportInterface()._implements(superInterfaceOutline.getSupportInterface());
                }
                this.putGroupInterfaceForClass(typeDef.getImplClass().fullName(), superInterfaceOutline);
            }
        }
        return groupInterfaces;
    }

    public void generateGroupInterfaceModel() throws SAXException {
        Map<QName, DefinedInterfaceOutline> modelGroupInterfaces = this.generateGroupInterfaces(this.pluginContext.outline.getModel().schemaComponent.iterateModelGroupDecls());
        Map<QName, DefinedInterfaceOutline> attGroupInterfaces = this.generateGroupInterfaces(this.pluginContext.outline.getModel().schemaComponent.iterateAttGroupDecls());
        for (ClassOutline classOutline : this.pluginContext.outline.getClasses()) {
            XSComponent xsTypeComponent = classOutline.target.getSchemaComponent();
            XSComplexType classComponent = GroupInterfaceGenerator.getTypeDefinition(xsTypeComponent);
            if (classComponent == null) continue;
            this.generateImplementsEntries(attGroupInterfaces, classOutline, GroupInterfaceGenerator.findAttributeGroups(classComponent));
            this.generateImplementsEntries(modelGroupInterfaces, classOutline, GroupInterfaceGenerator.findModelGroups(classComponent));
        }
        for (DefinedInterfaceOutline interfaceOutline : modelGroupInterfaces.values()) {
            this.removeDummyImplementation(interfaceOutline);
        }
        for (DefinedInterfaceOutline interfaceOutline : attGroupInterfaces.values()) {
            this.removeDummyImplementation(interfaceOutline);
        }
        if (this.declareBuilderInterface) {
            HashMap<String, BuilderOutline> builderOutlines = new HashMap<String, BuilderOutline>();
            for (DefinedInterfaceOutline interfaceOutline : modelGroupInterfaces.values()) {
                this.generateBuilderInterface(builderOutlines, interfaceOutline);
            }
            for (DefinedInterfaceOutline interfaceOutline : attGroupInterfaces.values()) {
                this.generateBuilderInterface(builderOutlines, interfaceOutline);
            }
            for (BuilderOutline builderOutline : builderOutlines.values()) {
                BuilderGenerator builderGenerator = new BuilderGenerator(this.pluginContext, builderOutlines, builderOutline, this.settings.getBuilderGeneratorSettings());
                builderGenerator.buildProperties();
            }
        }
        if (this.declareModifierInterface) {
            ModifierPlugin modifierPlugin = this.pluginContext.findPlugin(ModifierPlugin.class);
            for (DefinedInterfaceOutline interfaceOutline : modelGroupInterfaces.values()) {
                try {
                    ModifierGenerator.generateInterface(this.pluginContext, interfaceOutline, modifierPlugin.modifierClassName, interfaceOutline.getSuperInterfaces(), modifierPlugin.modifierMethodName);
                }
                catch (JClassAlreadyExistsException e) {
                    this.pluginContext.errorHandler.error(new SAXParseException(e.getMessage(), interfaceOutline.getSchemaComponent().getLocator()));
                }
            }
            for (DefinedInterfaceOutline interfaceOutline : attGroupInterfaces.values()) {
                try {
                    ModifierGenerator.generateInterface(this.pluginContext, interfaceOutline, modifierPlugin.modifierClassName, interfaceOutline.getSuperInterfaces(), modifierPlugin.modifierMethodName);
                }
                catch (JClassAlreadyExistsException e) {
                    this.pluginContext.errorHandler.error(new SAXParseException(e.getMessage(), interfaceOutline.getSchemaComponent().getLocator()));
                }
            }
        }
    }

    private void generateBuilderInterface(Map<String, BuilderOutline> builderOutlines, DefinedInterfaceOutline interfaceOutline) throws SAXException {
        try {
            builderOutlines.put(interfaceOutline.getImplClass().fullName(), new BuilderOutline(interfaceOutline, (JClass)interfaceOutline.getImplClass()._class(0, this.settings.getBuilderGeneratorSettings().getBuilderClassName().getInterfaceName(), ClassType.INTERFACE)));
        }
        catch (JClassAlreadyExistsException e) {
            this.pluginContext.errorHandler.error(new SAXParseException(MessageFormat.format(RESOURCE_BUNDLE.getString("error.interface-exists"), interfaceOutline.getImplClass().fullName(), "BuildSupport"), interfaceOutline.getSchemaComponent().getLocator()));
        }
    }

    private void removeDummyImplementation(DefinedInterfaceOutline interfaceOutline) {
        Collection allClasses = this.pluginContext.outline.getClasses();
        ClassOutline classToRemove = interfaceOutline.getClassOutline();
        if (classToRemove != null) {
            ArrayList<JMethod> methodsToRemove = new ArrayList<JMethod>();
            for (JMethod method : classToRemove._package().objectFactory().methods()) {
                if (!method.name().equals("create" + classToRemove.implClass.name())) continue;
                methodsToRemove.add(method);
            }
            for (JMethod method : methodsToRemove) {
                classToRemove._package().objectFactory().methods().remove(method);
            }
            this.pluginContext.outline.getModel().beans().remove(classToRemove.target.getClazz());
            allClasses.remove(classToRemove);
        }
    }

    private void generateImplementsEntries(Map<QName, DefinedInterfaceOutline> groupInterfaces, ClassOutline classOutline, Iterable<? extends XSDeclaration> groupUses) throws SAXException {
        for (XSDeclaration xSDeclaration : groupUses) {
            DefinedInterfaceOutline definedGroupType = groupInterfaces.get(PluginContext.getQName(xSDeclaration));
            if (definedGroupType == null) {
                ReferencedInterfaceOutline referencedInterfaceOutline = this.getReferencedInterfaceOutline(PluginContext.getQName(xSDeclaration));
                if (referencedInterfaceOutline == null) {
                    String interfaceName = this.pluginContext.outline.getModel().getNameConverter().toClassName(xSDeclaration.getName());
                    this.pluginContext.errorHandler.error(new SAXParseException(MessageFormat.format(RESOURCE_BUNDLE.getString("error.interface-not-found"), xSDeclaration.getName(), interfaceName), xSDeclaration.getLocator()));
                    continue;
                }
                classOutline.implClass._implements(PluginContext.coalesce(referencedInterfaceOutline.getSupportInterface(), referencedInterfaceOutline.getImplClass()));
                this.putGroupInterfaceForClass(classOutline.implClass.fullName(), referencedInterfaceOutline);
                continue;
            }
            classOutline.implClass._implements((JClass)PluginContext.coalesce(definedGroupType.getSupportInterface(), definedGroupType.getImplClass()));
            this.putGroupInterfaceForClass(classOutline.implClass.fullName(), definedGroupType);
        }
    }

    private DefinedInterfaceOutline createInterfaceDeclaration(XSDeclaration groupDecl) throws SAXException {
        JDefinedClass supportInterface;
        JDefinedClass groupInterface;
        PackageOutline packageOutline = this.findPackageForNamespace(groupDecl.getTargetNamespace());
        if (packageOutline == null) {
            this.pluginContext.errorHandler.error(new SAXParseException(MessageFormat.format(RESOURCE_BUNDLE.getString("error.package-not-found"), groupDecl.getTargetNamespace()), groupDecl.getLocator()));
            return null;
        }
        JPackage container = packageOutline._package();
        ClassOutline dummyImplementation = this.pluginContext.classesBySchemaComponent.get(PluginContext.getQName(groupDecl));
        if (dummyImplementation == null) {
            this.pluginContext.errorHandler.error(new SAXParseException(MessageFormat.format(RESOURCE_BUNDLE.getString("error.no-implementation"), this.pluginContext.outline.getModel().getNameConverter().toClassName(groupDecl.getName()), groupDecl.getTargetNamespace(), groupDecl.getName()), groupDecl.getLocator()));
            return null;
        }
        String interfaceName = dummyImplementation.implClass.name();
        container.remove((JClass)dummyImplementation.implClass);
        try {
            groupInterface = container._interface(1, interfaceName);
            supportInterface = this.settings.isGeneratingSupportInterface() ? container._interface(1, interfaceName + this.settings.getSupportInterfaceNameSuffix())._implements((JClass)groupInterface) : null;
        }
        catch (JClassAlreadyExistsException e) {
            this.pluginContext.errorHandler.error(new SAXParseException(MessageFormat.format(RESOURCE_BUNDLE.getString("error.interface-exists"), interfaceName, ""), groupDecl.getLocator()));
            return null;
        }
        DefinedInterfaceOutline interfaceDecl = new DefinedInterfaceOutline(groupDecl, groupInterface, dummyImplementation, supportInterface);
        StringWriter out = new StringWriter();
        out.write("<pre>\n");
        SchemaWriter sw = new SchemaWriter((Writer)new JavadocEscapeWriter((Writer)out));
        groupDecl.visit((XSVisitor)sw);
        out.write("</pre>");
        JDocComment comment = groupInterface.javadoc();
        comment.append((Object)RESOURCE_BUNDLE.getString("comment.generated-from-xs-decl.header")).append((Object)"\n").append((Object)MessageFormat.format(RESOURCE_BUNDLE.getString("comment.generated-from-xs-decl.qname"), groupDecl.getTargetNamespace(), groupDecl.getName())).append((Object)"\n").append((Object)MessageFormat.format(RESOURCE_BUNDLE.getString("comment.generated-from-xs-decl.locator"), groupDecl.getLocator().getSystemId(), groupDecl.getLocator().getLineNumber(), groupDecl.getLocator().getColumnNumber())).append((Object)"\n").append((Object)RESOURCE_BUNDLE.getString("comment.generated-from-xs-decl.source")).append((Object)"\n").append((Object)out.toString());
        for (PropertyUse propertyUse : this.findChildDecls(groupDecl)) {
            FieldOutline field = this.findField(dummyImplementation, propertyUse);
            if (field == null) continue;
            this.generateProperty(interfaceDecl, field);
        }
        if (this.declareVisitMethod) {
            JDefinedClass target = supportInterface != null ? supportInterface : groupInterface;
            target.method(0, (JType)target, this.pluginContext.findPlugin(MetaPlugin.class).getVisitMethodName()).param(8, PropertyVisitor.class, "visitor_");
        }
        return interfaceDecl;
    }

    private FieldOutline findField(ClassOutline implClass, PropertyUse propertyUse) throws SAXException {
        if (!propertyUse.isFixed()) {
            for (FieldOutline field : implClass.getDeclaredFields()) {
                if (!field.getPropertyInfo().getName(true).equals(propertyUse.getName())) continue;
                return field;
            }
            this.pluginContext.errorHandler.error(new SAXParseException(MessageFormat.format(RESOURCE_BUNDLE.getString("error.property-not-found"), propertyUse.declaration.toString(), propertyUse.getName(), implClass.implClass.fullName()), propertyUse.declaration.getLocator()));
        }
        return null;
    }

    private FieldOutline generateProperty(DefinedInterfaceOutline groupInterface, FieldOutline implementedField) {
        JMethod implementedGetter;
        if (implementedField != null && (implementedGetter = PluginContext.findGetter(implementedField)) != null) {
            JMethod implementedSetter;
            if (this.overrideCollectionClass != null && implementedField.getPropertyInfo().isCollection()) {
                groupInterface.getImplClass().method(0, (JType)this.overrideCollectionClass.narrow((JClass)((JClass)implementedGetter.type()).getTypeParameters().get(0)), implementedGetter.name());
            } else {
                groupInterface.getImplClass().method(0, implementedGetter.type(), implementedGetter.name());
            }
            if (!this.immutable && (implementedSetter = PluginContext.findSetter(implementedField)) != null) {
                JMethod newSetter = groupInterface.getImplClass().method(0, implementedSetter.type(), implementedSetter.name());
                newSetter.param(implementedSetter.listParamTypes()[0], implementedSetter.listParams()[0].name());
                if (this.throwsPropertyVetoException) {
                    newSetter._throws(PropertyVetoException.class);
                }
            }
            groupInterface.addField(implementedField);
        }
        return implementedField;
    }

    private ReferencedInterfaceOutline getReferencedInterfaceOutline(QName schemaComponent) {
        return this.getReferencedInterfaces().get(schemaComponent);
    }

    Map<QName, ReferencedInterfaceOutline> getReferencedInterfaces() {
        if (this.referencedInterfaces == null) {
            this.referencedInterfaces = this.upstreamEpisodes != null ? this.loadInterfaceEpisodes() : Collections.emptyMap();
        }
        return this.referencedInterfaces;
    }

    private class PropertyUse {
        final XSComponent declaration;

        PropertyUse(XSComponent declaration) {
            this.declaration = declaration;
        }

        String getName() {
            return (String)this.declaration.apply(GroupInterfaceGenerator.this.nameFunc);
        }

        boolean isFixed() {
            return (Boolean)this.declaration.apply(IS_FIXED_FUNC);
        }
    }
}

