/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.BuilderGeneratorSettings;
import com.kscs.util.plugins.xjc.EpisodeBuilder;
import com.kscs.util.plugins.xjc.FluentBuilderPlugin;
import com.kscs.util.plugins.xjc.GroupInterfaceDirectStrategy;
import com.kscs.util.plugins.xjc.GroupInterfaceGenerator;
import com.kscs.util.plugins.xjc.GroupInterfaceGeneratorSettings;
import com.kscs.util.plugins.xjc.GroupInterfaceModelProcessingStrategy;
import com.kscs.util.plugins.xjc.ModifierPlugin;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.Opt;
import com.kscs.util.plugins.xjc.base.PluginUtil;
import com.kscs.util.plugins.xjc.outline.TypeOutline;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class GroupInterfacePlugin
extends AbstractPlugin {
    @Opt
    private boolean declareSetters = true;
    @Opt
    private boolean declareBuilderInterface = true;
    @Opt
    private String supportInterfaceNameSuffix = "Lifecycle";
    @Opt
    private String upstreamEpisodeFile = "META-INF/jaxb-interfaces.episode";
    @Opt
    private String downstreamEpisodeFile = "META-INF/jaxb-interfaces.episode";
    private final GroupInterfaceModelProcessingStrategy complexTypeGeneratorStrategy = PluginUtil.getConfiguredObject(GroupInterfaceModelProcessingStrategy.class, GroupInterfaceDirectStrategy.class);
    private GroupInterfaceGenerator generator = null;

    public List<String> getCustomizationURIs() {
        return Collections.singletonList("http://www.kscs.com/util/jaxb/bindings");
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return "http://www.kscs.com/util/jaxb/bindings".equals(nsUri) && "interface".equals(localName);
    }

    public String getOptionName() {
        return "Xgroup-contract";
    }

    public void onActivated(Options opts) throws BadCommandLineException {
        this.complexTypeGeneratorStrategy.onPluginActivation(opts);
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        this.complexTypeGeneratorStrategy.onPostProcessModel(model, errorHandler);
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        this.generate(PluginContext.get(outline, opt, errorHandler));
        return true;
    }

    public List<TypeOutline> getGroupInterfacesForClass(PluginContext pluginContext, String className) throws SAXException {
        this.generate(pluginContext);
        return this.generator.getGroupInterfacesForClass(className);
    }

    private void generate(PluginContext pluginContext) throws SAXException {
        if (this.generator == null) {
            try {
                Enumeration<URL> interfaceEpisodeURLs = ((Object)((Object)this)).getClass().getClassLoader().getResources(this.upstreamEpisodeFile);
                EpisodeBuilder episodeBuilder = new EpisodeBuilder(pluginContext, this.downstreamEpisodeFile);
                this.generator = new GroupInterfaceGenerator(pluginContext, interfaceEpisodeURLs, episodeBuilder, this.getSettings(pluginContext));
                this.generator.generateGroupInterfaceModel();
                episodeBuilder.build();
            }
            catch (IOException iox) {
                throw new SAXException(iox);
            }
        }
    }

    public GroupInterfaceGeneratorSettings getSettings(PluginContext pluginContext) {
        FluentBuilderPlugin fluentBuilderPlugin = pluginContext.findPlugin(FluentBuilderPlugin.class);
        if (fluentBuilderPlugin != null) {
            BuilderGeneratorSettings builderGeneratorSettings = fluentBuilderPlugin.getSettings();
            return new GroupInterfaceGeneratorSettings(this.declareSetters, this.declareBuilderInterface, this.supportInterfaceNameSuffix, builderGeneratorSettings);
        }
        return new GroupInterfaceGeneratorSettings(this.declareSetters, this.declareBuilderInterface, pluginContext.hasPlugin(ModifierPlugin.class) ? this.supportInterfaceNameSuffix : null, null);
    }
}

