/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.Opt;
import com.kscs.util.plugins.xjc.base.PluginUtil;
import com.kscs.util.plugins.xjc.outline.PropertyOutline;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ImmutablePlugin
extends AbstractPlugin {
    @Opt
    private boolean fake = false;
    @Opt
    protected String overrideCollectionClass = null;
    @Opt
    private String constructorAccess = "public";

    public String getOptionName() {
        return "Ximmutable";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        PluginContext pluginContext = PluginContext.get(outline, opt, errorHandler);
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass definedClass = classOutline.implClass;
            for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
                String setterName;
                JMethod setterMethod;
                JFieldVar declaredField;
                if (fieldOutline.getPropertyInfo().isCollection() && !(declaredField = PluginUtil.getDeclaredField(fieldOutline)).type().isArray()) {
                    JType getterType;
                    JClass elementType = (JClass)((JClass)declaredField.type()).getTypeParameters().get(0);
                    JMethod oldGetter = definedClass.getMethod("get" + fieldOutline.getPropertyInfo().getName(true), new JType[0]);
                    Object object = getterType = this.overrideCollectionClass != null ? pluginContext.codeModel.ref(this.overrideCollectionClass).narrow(elementType) : oldGetter.type();
                    if (this.fake) {
                        oldGetter.type(getterType);
                    } else {
                        JFieldVar immutableField = definedClass.field(258, getterType, this.getImmutableFieldName(declaredField), JExpr._null());
                        definedClass.methods().remove(oldGetter);
                        JMethod newGetter = definedClass.method(1, getterType, oldGetter.name());
                        JConditional ifFieldNull = newGetter.body()._if(JExpr._this().ref((JVar)declaredField).eq(JExpr._null()));
                        ifFieldNull._then().assign((JAssignmentTarget)JExpr._this().ref((JVar)declaredField), (JExpression)JExpr._new((JClass)PluginContext.extractMutableListClass(fieldOutline).narrow(elementType)));
                        JConditional ifImmutableFieldNull = newGetter.body()._if(JExpr._this().ref((JVar)immutableField).eq(JExpr._null()));
                        this.immutableInit(pluginContext, ifImmutableFieldNull._then(), JExpr._this(), declaredField);
                        newGetter.body()._return((JExpression)JExpr._this().ref((JVar)immutableField));
                    }
                } else if (!this.fake && (setterMethod = definedClass.getMethod(setterName = "set" + fieldOutline.getPropertyInfo().getName(true), new JType[]{fieldOutline.getRawType()})) != null) {
                    setterMethod.mods().setProtected();
                }
                if (this.fake || "public".equalsIgnoreCase(this.constructorAccess)) continue;
                Iterator constructors = definedClass.constructors();
                if (!constructors.hasNext()) {
                    JMethod constructor = definedClass.constructor("private".equalsIgnoreCase(this.constructorAccess) ? 4 : 2);
                    constructor.javadoc().append((Object)this.getMessage("comment.constructor"));
                    constructor.body().directStatement("// " + this.getMessage("comment.constructor"));
                }
                ArrayList<JMethod> constructorsToChange = new ArrayList<JMethod>();
                while (constructors.hasNext()) {
                    JMethod constructor = (JMethod)constructors.next();
                    if (!constructor.params().isEmpty() || (constructor.mods().getValue() & 1) != 1) continue;
                    constructorsToChange.add(constructor);
                }
                for (JMethod constructor : constructorsToChange) {
                    if ("private".equalsIgnoreCase(this.constructorAccess)) {
                        constructor.mods().setPrivate();
                        continue;
                    }
                    constructor.mods().setProtected();
                }
            }
        }
        return true;
    }

    String getImmutableFieldName(PropertyOutline fieldVar) {
        return fieldVar.getFieldName() + "_RO";
    }

    String getImmutableFieldName(JFieldVar fieldVar) {
        return fieldVar.name() + "_RO";
    }

    public void immutableInit(PluginContext pluginContext, JBlock body, JExpression instanceRef, PropertyOutline collectionField) {
        if (!this.fake) {
            body.assign((JAssignmentTarget)instanceRef.ref(this.getImmutableFieldName(collectionField)), PluginUtil.nullSafe(collectionField, (JExpression)this.generateImmutableListInstantiation(pluginContext, instanceRef.ref(collectionField.getFieldName()), collectionField.getElementType())));
        }
    }

    public void immutableInit(PluginContext pluginContext, JBlock body, JExpression instanceRef, JFieldVar declaredField) {
        if (!this.fake) {
            body.assign((JAssignmentTarget)instanceRef.ref(this.getImmutableFieldName(declaredField)), PluginUtil.nullSafe((JExpression)declaredField, (JExpression)this.generateImmutableListInstantiation(pluginContext, instanceRef.ref((JVar)declaredField), (JType)((JClass)declaredField.type()).getTypeParameters().get(0))));
        }
    }

    private JInvocation generateImmutableListInstantiation(PluginContext pluginContext, JFieldRef fieldRef, JType elementType) {
        if (this.overrideCollectionClass == null) {
            return pluginContext.unmodifiableList((JExpression)fieldRef);
        }
        JClass overrideCollection = pluginContext.codeModel.ref(this.overrideCollectionClass);
        if (overrideCollection.isAssignableFrom(pluginContext.codeModel.ref(Collection.class))) {
            return pluginContext.unmodifiableList((JExpression)fieldRef);
        }
        return JExpr._new((JClass)overrideCollection.narrow(elementType)).arg((JExpression)fieldRef);
    }
}

