/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectCollectionProperty;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectPrimitiveCollectionProperty;
import com.kscs.util.jaxb.IndirectPrimitiveCollectionPropertyInfo;
import com.kscs.util.jaxb.ItemProperty;
import com.kscs.util.jaxb.Property;
import com.kscs.util.jaxb.PropertyInfo;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.AbstractXSFunction;
import com.kscs.util.plugins.xjc.base.Opt;
import com.kscs.util.plugins.xjc.outline.DefinedPropertyOutline;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.visitor.XSFunction;
import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MetaPlugin
extends AbstractPlugin {
    private static final XSFunction<QName> SCHEMA_NAME_FUNC = new AbstractXSFunction<QName>(){

        public QName attributeDecl(XSAttributeDecl decl) {
            return new QName(decl.getTargetNamespace(), decl.getName());
        }

        public QName attributeUse(XSAttributeUse use) {
            return new QName(use.getDecl().getTargetNamespace(), use.getDecl().getName());
        }

        public QName elementDecl(XSElementDecl decl) {
            return new QName(decl.getTargetNamespace(), decl.getName());
        }

        public QName particle(XSParticle particle) {
            return (QName)particle.getTerm().apply(SCHEMA_NAME_FUNC);
        }

        public QName modelGroupDecl(XSModelGroupDecl decl) {
            return new QName(decl.getTargetNamespace(), decl.getName());
        }

        public QName modelGroup(XSModelGroup group) {
            return new QName("", "");
        }

        public QName wildcard(XSWildcard wc) {
            return new QName("", "*");
        }

        public QName simpleType(XSSimpleType type) {
            if (type.getName() == null) {
                return new QName(type.getTargetNamespace(), "anonymousSimpleType");
            }
            return new QName(type.getTargetNamespace(), type.getName());
        }

        public QName complexType(XSComplexType type) {
            if (type.getName() == null) {
                return new QName(type.getTargetNamespace(), "anonymousComplexType");
            }
            return new QName(type.getTargetNamespace(), type.getName());
        }
    };
    private static final XSFunction<QName> SCHEMA_TYPE_FUNC = new AbstractXSFunction<QName>(){

        public QName attributeDecl(XSAttributeDecl decl) {
            if (decl.getType().getName() == null) {
                return new QName(decl.getType().getTargetNamespace(), "anonymousAttributeType");
            }
            return new QName(decl.getType().getTargetNamespace(), decl.getType().getName());
        }

        public QName attributeUse(XSAttributeUse use) {
            return this.attributeDecl(use.getDecl());
        }

        public QName elementDecl(XSElementDecl decl) {
            if (decl.getType().getName() == null) {
                return new QName(decl.getType().getTargetNamespace(), "anononymousElementType");
            }
            return new QName(decl.getType().getTargetNamespace(), decl.getType().getName());
        }

        public QName particle(XSParticle particle) {
            return (QName)particle.getTerm().apply(SCHEMA_TYPE_FUNC);
        }

        public QName simpleType(XSSimpleType simpleType) {
            return new QName(simpleType.getTargetNamespace(), simpleType.getName());
        }

        public QName wildcard(XSWildcard wc) {
            return new QName("", "*");
        }

        public QName modelGroupDecl(XSModelGroupDecl decl) {
            return new QName(decl.getTargetNamespace(), decl.getName());
        }

        public QName modelGroup(XSModelGroup group) {
            return new QName("", "");
        }

        public QName complexType(XSComplexType type) {
            if (type.getName() == null) {
                return new QName(type.getTargetNamespace(), "anonymousComplexType");
            }
            return new QName(type.getTargetNamespace(), type.getName());
        }
    };
    private static final XSFunction<Boolean> ATTRIBUTE_FUNC = new AbstractXSFunction<Boolean>(){

        public Boolean attributeDecl(XSAttributeDecl decl) {
            return true;
        }

        public Boolean attributeUse(XSAttributeUse use) {
            return true;
        }

        public Boolean elementDecl(XSElementDecl decl) {
            return false;
        }

        public Boolean particle(XSParticle particle) {
            return false;
        }

        public Boolean simpleType(XSSimpleType simpleType) {
            return false;
        }

        public Boolean complexType(XSComplexType type) {
            return false;
        }

        public Boolean modelGroupDecl(XSModelGroupDecl decl) {
            return false;
        }

        public Boolean modelGroup(XSModelGroup group) {
            return false;
        }

        public Boolean wildcard(XSWildcard wc) {
            return false;
        }
    };
    @Opt
    private boolean generateTools = true;
    @Opt
    private boolean extended = false;
    @Opt
    private boolean camelCase = false;
    @Opt
    private String metaClassName = "PropInfo";
    @Opt
    private boolean allowSet = true;
    @Opt
    private String visitMethodName = "visit";
    private boolean fixedAttributeAsConstantProperty;

    public String getOptionName() {
        return "Xmeta";
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        this.fixedAttributeAsConstantProperty = ((BGMBuilder)Ring.get(BGMBuilder.class)).getGlobalBinding().getDefaultProperty().isConstantProperty();
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        PluginContext pluginContext = PluginContext.get(outline, opt, errorHandler);
        if (this.extended && this.generateTools) {
            pluginContext.writeSourceFile(PropertyInfo.class);
            pluginContext.writeSourceFile(SinglePropertyInfo.class);
            pluginContext.writeSourceFile(CollectionPropertyInfo.class);
            pluginContext.writeSourceFile(IndirectCollectionPropertyInfo.class);
            pluginContext.writeSourceFile(IndirectPrimitiveCollectionPropertyInfo.class);
            pluginContext.writeSourceFile(PropertyVisitor.class);
            pluginContext.writeSourceFile(Property.class);
            pluginContext.writeSourceFile(SingleProperty.class);
            pluginContext.writeSourceFile(CollectionProperty.class);
            pluginContext.writeSourceFile(IndirectCollectionProperty.class);
            pluginContext.writeSourceFile(IndirectPrimitiveCollectionProperty.class);
            pluginContext.writeSourceFile(ItemProperty.class);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.generateMetaClass(pluginContext, classOutline, errorHandler);
        }
        return true;
    }

    private void generateMetaClass(PluginContext pluginContext, ClassOutline classOutline, ErrorHandler errorHandler) throws SAXException {
        try {
            JDefinedClass metaClass = classOutline.implClass._class(17, this.metaClassName);
            JMethod visitMethod = this.generateVisitMethod(classOutline);
            for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
                if (this.extended) {
                    this.generateExtendedMetaField(pluginContext, metaClass, visitMethod, fieldOutline);
                    continue;
                }
                this.generateNameOnlyMetaField(pluginContext, metaClass, fieldOutline);
            }
            visitMethod.body()._return(JExpr._this());
        }
        catch (JClassAlreadyExistsException e) {
            errorHandler.error(new SAXParseException(this.getMessage("error.metaClassExists", new Object[]{classOutline.implClass.name(), this.metaClassName}), classOutline.target.getLocator()));
        }
    }

    private void generateNameOnlyMetaField(PluginContext pluginContext, JDefinedClass metaClass, FieldOutline fieldOutline) {
        DefinedPropertyOutline propertyOutline = new DefinedPropertyOutline(fieldOutline);
        String constantName = this.getConstantName(fieldOutline);
        Outline outline = pluginContext.outline;
        String propertyName = constantName != null ? constantName : propertyOutline.getFieldName();
        String metaFieldName = this.camelCase ? propertyName : fieldOutline.parent().parent().getModel().getNameConverter().toConstantName(propertyName);
        metaClass.field(281, String.class, metaFieldName, JExpr.lit((String)propertyName));
    }

    private void generateExtendedMetaField(PluginContext pluginContext, JDefinedClass metaClass, JMethod visitMethod, FieldOutline fieldOutline) {
        JClass fieldType;
        Class<SingleProperty> propertyWrapperClass;
        JClass typeArg;
        Class<SinglePropertyInfo> infoClass;
        F3<JExpression, JBlock, JVar, JVar> setMaker;
        F1<JExpression, JVar> getMaker;
        DefinedPropertyOutline propertyOutline = new DefinedPropertyOutline(fieldOutline);
        String constantName = this.getConstantName(fieldOutline);
        Outline outline = pluginContext.outline;
        final String propertyName = constantName != null ? constantName : propertyOutline.getFieldName();
        String metaFieldName = this.camelCase ? propertyName : outline.getModel().getNameConverter().toConstantName(propertyName);
        JType rawType = propertyOutline.getElementType();
        final JClass jaxbElementClass = outline.getCodeModel().ref(JAXBElement.class);
        if (propertyOutline.isIndirect()) {
            final JClass propertyType = (JClass)((JClass)rawType).getTypeParameters().get(0);
            if (propertyOutline.isCollection() && !rawType.isArray()) {
                getMaker = new F1<JExpression, JVar>(){

                    @Override
                    public JExpression f(JVar param) {
                        return param.ref(propertyName);
                    }
                };
                setMaker = new F3<JExpression, JBlock, JVar, JVar>(){

                    @Override
                    public JExpression f(JBlock block, JVar instanceParam, JVar valueParam) {
                        block.assign((JAssignmentTarget)instanceParam.ref(propertyName), (JExpression)valueParam);
                        return null;
                    }
                };
                infoClass = propertyType.name().startsWith("?") ? IndirectCollectionPropertyInfo.class : IndirectPrimitiveCollectionPropertyInfo.class;
                typeArg = propertyType.name().startsWith("?") ? propertyType._extends() : propertyType;
                propertyWrapperClass = propertyType.name().startsWith("?") ? IndirectCollectionProperty.class : IndirectPrimitiveCollectionProperty.class;
                fieldType = outline.getCodeModel().ref(List.class).narrow(jaxbElementClass.narrow(propertyType));
            } else {
                getMaker = new F1<JExpression, JVar>(){

                    @Override
                    public JExpression f(JVar param) {
                        return JOp.cond((JExpression)param.ref(propertyName).eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)param.ref(propertyName).invoke("getValue"));
                    }
                };
                setMaker = new F3<JExpression, JBlock, JVar, JVar>(){

                    @Override
                    public JExpression f(JBlock block, JVar instanceParam, JVar valueParam) {
                        return JExpr.assign((JAssignmentTarget)instanceParam.ref(propertyName), (JExpression)JExpr._new((JClass)jaxbElementClass).arg((JExpression)JExpr._this().ref("schemaName")).arg(propertyType._extends().dotclass()).arg((JExpression)valueParam));
                    }
                };
                infoClass = SinglePropertyInfo.class;
                propertyWrapperClass = SingleProperty.class;
                fieldType = propertyType._extends();
                typeArg = propertyType._extends();
            }
        } else {
            getMaker = constantName == null ? new F1<JExpression, JVar>(){

                @Override
                public JExpression f(JVar param) {
                    return param.ref(propertyName);
                }
            } : new F1<JExpression, JVar>(){

                @Override
                public JExpression f(JVar param) {
                    return ((JClass)param.type()).staticRef(propertyName);
                }
            };
            setMaker = new F3<JExpression, JBlock, JVar, JVar>(){

                @Override
                public JExpression f(JBlock block, JVar instanceParam, JVar valueParam) {
                    block.assign((JAssignmentTarget)instanceParam.ref(propertyName), (JExpression)valueParam);
                    return null;
                }
            };
            if (propertyOutline.isCollection() && !rawType.isArray()) {
                infoClass = CollectionPropertyInfo.class;
                typeArg = (JClass)rawType;
                fieldType = outline.getCodeModel().ref(List.class).narrow(rawType);
                propertyWrapperClass = CollectionProperty.class;
            } else {
                infoClass = SinglePropertyInfo.class;
                fieldType = rawType.boxify();
                typeArg = rawType.boxify();
                propertyWrapperClass = SingleProperty.class;
            }
        }
        JClass metaFieldType = typeArg == null ? outline.getCodeModel().ref(infoClass).narrow((JClass)fieldOutline.parent().implClass) : outline.getCodeModel().ref(infoClass).narrow(new JClass[]{fieldOutline.parent().implClass, typeArg});
        JDefinedClass anonymousMetaFieldType = outline.getCodeModel().anonymousClass(metaFieldType);
        this.generateAccessors(fieldOutline, propertyName, (JType)fieldType, anonymousMetaFieldType, getMaker, setMaker);
        XSComponent schemaComponent = fieldOutline.getPropertyInfo().getSchemaComponent();
        QName schemaName = (QName)schemaComponent.apply(SCHEMA_NAME_FUNC);
        QName schemaType = (QName)schemaComponent.apply(SCHEMA_TYPE_FUNC);
        Boolean attribute = (Boolean)schemaComponent.apply(ATTRIBUTE_FUNC);
        JInvocation schemaNameExpr = JExpr._new((JClass)outline.getCodeModel().ref(QName.class)).arg(schemaName.getNamespaceURI()).arg(schemaName.getLocalPart());
        JInvocation schemaTypeExpr = JExpr._new((JClass)outline.getCodeModel().ref(QName.class)).arg(schemaType.getNamespaceURI()).arg(schemaType.getLocalPart());
        CDefaultValue defaultValue = fieldOutline.getPropertyInfo().defaultValue;
        JFieldVar staticField = metaClass.field(281, (JType)metaFieldType, metaFieldName, (JExpression)JExpr._new((JClass)anonymousMetaFieldType).arg(propertyName).arg(fieldOutline.parent().implClass.dotclass()).arg(this.dotClass((JType)(typeArg == null ? pluginContext.codeModel.ref(Object.class) : typeArg))).arg(JExpr.lit((boolean)propertyOutline.isCollection())).arg(defaultValue == null ? JExpr._null() : defaultValue.compute(outline)).arg((JExpression)schemaNameExpr).arg((JExpression)schemaTypeExpr).arg(JExpr.lit((boolean)attribute)));
        JVar visitorParam = (JVar)visitMethod.params().get(0);
        JBlock block = visitMethod.body();
        JClass propertyCategory = typeArg == null ? pluginContext.codeModel.ref(propertyWrapperClass).narrow((JClass)fieldOutline.parent().implClass) : pluginContext.codeModel.ref(propertyWrapperClass).narrow(new JClass[]{fieldOutline.parent().implClass, typeArg});
        boolean generatedClass = typeArg != null && this.isVisitable(pluginContext, typeArg);
        JInvocation call = visitorParam.invoke("visit").arg((JExpression)JExpr._new((JClass)propertyCategory).arg((JExpression)metaClass.staticRef((JVar)staticField)).arg(JExpr._this()));
        if (generatedClass) {
            JFieldRef field = JExpr._this().ref(fieldOutline.getPropertyInfo().getName(false));
            JConditional ifContinue = block._if(call.cand(field.ne(JExpr._null())));
            if (propertyOutline.isCollection() && !rawType.isArray()) {
                JForEach forEach = ifContinue._then().forEach(rawType, "_item_", (JExpression)field);
                JConditional ifNotNull = forEach.body()._if(forEach.var().ne(JExpr._null()));
                ifNotNull._then().add((JStatement)(propertyOutline.isIndirect() ? forEach.var().invoke("getValue") : forEach.var()).invoke(this.visitMethodName).arg((JExpression)visitorParam));
            } else {
                ifContinue._then().add((JStatement)(propertyOutline.isIndirect() ? field.invoke("getValue") : field).invoke(this.visitMethodName).arg((JExpression)visitorParam));
            }
        } else {
            block.add((JStatement)call);
        }
    }

    private boolean isVisitable(PluginContext pluginContext, JClass typeArg) {
        return pluginContext.getClassOutline((JType)typeArg) != null || this.hasReferencedClass(typeArg);
    }

    private boolean hasReferencedClass(JClass typeArg) {
        try {
            Class<?> foundClass = Class.forName(typeArg.binaryName());
            Method visitMethod = foundClass.getMethod("visit", PropertyVisitor.class);
            return visitMethod != null;
        }
        catch (Exception cfne) {
            return false;
        }
    }

    private void generateAccessors(FieldOutline fieldOutline, String propertyName, JType returnType, JDefinedClass declaringClass, F1<JExpression, JVar> getMaker, F3<JExpression, JBlock, JVar, JVar> setMaker) {
        String constantName = this.getConstantName(fieldOutline);
        JMethod getMethod = declaringClass.method(1, returnType, "get");
        getMethod.annotate(Override.class);
        JVar instanceParam = getMethod.param(8, (JType)fieldOutline.parent().implClass, "_instance_");
        getMethod.body()._return(JOp.cond((JExpression)instanceParam.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)getMaker.f(instanceParam)));
        JMethod setMethod = declaringClass.method(1, Void.TYPE, "set");
        setMethod.annotate(Override.class);
        JVar setInstanceParam = setMethod.param(8, (JType)fieldOutline.parent().implClass, "_instance_");
        JVar valueParam = setMethod.param(8, returnType, "_value_");
        if (constantName == null) {
            JConditional ifNotNull = setMethod.body()._if(setInstanceParam.ne(JExpr._null()));
            setMaker.f(ifNotNull._then(), setInstanceParam, valueParam);
        }
    }

    private JExpression dotClass(final JType cl) {
        if (cl instanceof JClass) {
            return ((JClass)cl).dotclass();
        }
        return new JExpressionImpl(){

            public void generate(JFormatter f) {
                f.g((JGenerable)cl).p(".class");
            }
        };
    }

    private String getConstantName(FieldOutline fieldOutline) {
        XSComponent schemaComponent = fieldOutline.getPropertyInfo().getSchemaComponent();
        if (!this.fixedAttributeAsConstantProperty) {
            return null;
        }
        if (schemaComponent instanceof XSAttributeDecl) {
            return ((XSAttributeDecl)schemaComponent).getFixedValue() != null ? fieldOutline.parent().parent().getModel().getNameConverter().toConstantName(((XSAttributeDecl)schemaComponent).getName()) : null;
        }
        return schemaComponent instanceof XSAttributeUse && ((XSAttributeUse)schemaComponent).getFixedValue() != null ? fieldOutline.parent().parent().getModel().getNameConverter().toConstantName(((XSAttributeUse)schemaComponent).getDecl().getName()) : null;
    }

    private JMethod generateVisitMethod(ClassOutline classOutline) {
        JDefinedClass definedClass = classOutline.implClass;
        JMethod visitMethod = definedClass.method(1, (JType)definedClass, this.visitMethodName);
        JCodeModel codeModel = definedClass.owner();
        JClass visitorType = codeModel.ref(PropertyVisitor.class);
        JVar visitorParam = visitMethod.param(8, (JType)visitorType, "_visitor_");
        if (classOutline.getSuperClass() != null) {
            visitMethod.body().add((JStatement)JExpr._super().invoke(this.visitMethodName).arg((JExpression)visitorParam));
        } else {
            visitMethod.body().add((JStatement)visitorParam.invoke("visit").arg(JExpr._this()));
        }
        return visitMethod;
    }

    public String getVisitMethodName() {
        return this.visitMethodName;
    }

    private static interface F1<R, A> {
        public R f(A var1);
    }

    private static interface F3<R, A, B, C> {
        public R f(A var1, B var2, C var3);
    }
}

