/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.codemodel.NestedThisRef;
import com.kscs.util.plugins.xjc.outline.DefinedInterfaceOutline;
import com.kscs.util.plugins.xjc.outline.DefinedPropertyOutline;
import com.kscs.util.plugins.xjc.outline.DefinedTypeOutline;
import com.kscs.util.plugins.xjc.outline.TypeOutline;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Collection;

public class ModifierGenerator {
    public static final String MODIFIER_CACHE_FIELD_NAME = "__cachedModifier__";
    public static final String SETTER_PREFIX = "set";
    public static final String GETTER_PREFIX = "get";
    private final DefinedTypeOutline classOutline;
    private final JDefinedClass modifierClass;
    private final boolean implement;

    public static void generateClass(PluginContext pluginContext, DefinedTypeOutline classOutline, String modifierClassName, String modifierInterfaceName, Collection<TypeOutline> suerInterfaces, String modifierMethodName) throws JClassAlreadyExistsException {
        new ModifierGenerator(pluginContext, classOutline, modifierClassName, modifierInterfaceName, suerInterfaces, modifierMethodName, true).generatePropertyAccessors();
    }

    public static void generateClass(PluginContext pluginContext, DefinedTypeOutline classOutline, String modifierClassName, String modifierMethodName) throws JClassAlreadyExistsException {
        new ModifierGenerator(pluginContext, classOutline, modifierClassName, null, null, modifierMethodName, true).generatePropertyAccessors();
    }

    public static void generateInterface(PluginContext pluginContext, DefinedTypeOutline classOutline, String modifierInterfaceName, Collection<TypeOutline> interfaces, String modifierMethodName) throws JClassAlreadyExistsException {
        new ModifierGenerator(pluginContext, classOutline, modifierInterfaceName, modifierInterfaceName, interfaces, modifierMethodName, false).generatePropertyAccessors();
    }

    private ModifierGenerator(PluginContext pluginContext, DefinedTypeOutline classOutline, String modifierClassName, String modifierInterfaceName, Collection<TypeOutline> interfaces, String modifierMethodName, boolean implement) throws JClassAlreadyExistsException {
        JFieldRef cachedModifierField;
        this.classOutline = classOutline;
        JDefinedClass definedClass = classOutline.getImplClass();
        this.implement = implement;
        this.modifierClass = definedClass._class(1, modifierClassName, classOutline.getImplClass().getClassType());
        if (interfaces != null) {
            for (TypeOutline interfaceOutline : interfaces) {
                this.modifierClass._implements((JClass)pluginContext.ref(interfaceOutline.getImplClass(), modifierInterfaceName, true));
            }
        }
        if (!"java.lang.Object".equals(definedClass._extends().fullName())) {
            this.modifierClass._extends((JClass)pluginContext.ref(definedClass._extends(), modifierClassName, false));
            cachedModifierField = JExpr.refthis((String)MODIFIER_CACHE_FIELD_NAME);
        } else {
            cachedModifierField = implement ? JExpr._this().ref((JVar)definedClass.field(258, (JType)this.modifierClass, MODIFIER_CACHE_FIELD_NAME)) : null;
        }
        JDefinedClass typeDefinition = classOutline.isInterface() && ((DefinedInterfaceOutline)classOutline).getSupportInterface() != null ? ((DefinedInterfaceOutline)classOutline).getSupportInterface() : definedClass;
        JMethod modifierMethod = typeDefinition.method(1, (JType)this.modifierClass, modifierMethodName);
        if (this.implement) {
            JConditional ifCacheNull = modifierMethod.body()._if(JExpr._null().eq((JExpression)cachedModifierField));
            ifCacheNull._then().assign((JAssignmentTarget)cachedModifierField, (JExpression)JExpr._new((JClass)this.modifierClass));
            modifierMethod.body()._return((JExpression)JExpr.cast((JType)this.modifierClass, (JExpression)cachedModifierField));
        }
    }

    private void generatePropertyAccessors() {
        for (DefinedPropertyOutline fieldOutline : this.classOutline.getDeclaredFields()) {
            this.generatePropertyAccessor(fieldOutline);
        }
    }

    private void generatePropertyAccessor(DefinedPropertyOutline fieldOutline) {
        if (fieldOutline.isCollection() && !fieldOutline.isArray()) {
            this.generateCollectionAccessor(fieldOutline);
        } else {
            this.generateSingularPropertyAccessor(fieldOutline);
        }
    }

    private void generateSingularPropertyAccessor(DefinedPropertyOutline fieldOutline) {
        JFieldVar fieldVar = fieldOutline.getFieldVar();
        if (fieldVar != null) {
            JMethod modifier = this.modifierClass.method(1, (JType)this.modifierClass.owner().VOID, SETTER_PREFIX + fieldOutline.getBaseName());
            JVar parameter = modifier.param(8, fieldVar.type(), fieldOutline.getFieldName());
            if (this.implement) {
                modifier.body().add((JStatement)new NestedThisRef((JClass)this.classOutline.getImplClass()).invoke(modifier.name()).arg((JExpression)parameter));
            }
        }
    }

    private void generateCollectionAccessor(DefinedPropertyOutline fieldOutline) {
        JFieldVar fieldVar = fieldOutline.getFieldVar();
        if (fieldVar != null) {
            JMethod modifier = this.modifierClass.method(1, fieldVar.type(), GETTER_PREFIX + fieldOutline.getBaseName());
            if (this.implement) {
                JFieldRef fieldRef = new NestedThisRef((JClass)this.classOutline.getImplClass()).ref((JVar)fieldVar);
                JConditional ifNull = modifier.body()._if(fieldRef.eq(JExpr._null()));
                ifNull._then().assign((JAssignmentTarget)fieldRef, (JExpression)JExpr._new((JClass)this.classOutline.getImplClass().owner().ref(ArrayList.class).narrow(fieldOutline.getElementType())));
                modifier.body()._return((JExpression)fieldRef);
            }
        }
    }
}

