/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.GroupInterfacePlugin;
import com.kscs.util.plugins.xjc.ModifierGenerator;
import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.Opt;
import com.kscs.util.plugins.xjc.outline.DefinedClassOutline;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModifierPlugin
extends AbstractPlugin {
    @Opt
    protected String modifierClassName = "Modifier";
    @Opt
    protected String modifierMethodName = "modifier";

    public String getOptionName() {
        return "Xmodifier";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        PluginContext pluginContext = PluginContext.get(outline, opt, errorHandler);
        for (ClassOutline classOutline : outline.getClasses()) {
            try {
                GroupInterfacePlugin groupInterfacePlugin = pluginContext.findPlugin(GroupInterfacePlugin.class);
                if (groupInterfacePlugin != null) {
                    ModifierGenerator.generateClass(pluginContext, new DefinedClassOutline(classOutline), this.modifierClassName, this.modifierClassName, groupInterfacePlugin.getGroupInterfacesForClass(pluginContext, classOutline.implClass.fullName()), this.modifierMethodName);
                    continue;
                }
                ModifierGenerator.generateClass(pluginContext, new DefinedClassOutline(classOutline), this.modifierClassName, this.modifierMethodName);
            }
            catch (JClassAlreadyExistsException e) {
                errorHandler.error(new SAXParseException(e.getMessage(), classOutline.target.getLocator()));
            }
        }
        return true;
    }
}

