/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.plugins.xjc.CopyGenerator;
import com.kscs.util.plugins.xjc.FullCopyGenerator;
import com.kscs.util.plugins.xjc.ImmutablePlugin;
import com.kscs.util.plugins.xjc.PartialCopyGenerator;
import com.kscs.util.plugins.xjc.codemodel.JDirectInnerClassRef;
import com.kscs.util.plugins.xjc.codemodel.JTypedInvocation;
import com.kscs.util.plugins.xjc.outline.PropertyOutline;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.fmt.JStaticJavaFile;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CCustomizable;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSDeclaration;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.glassfish.jaxb.core.api.impl.NameConverter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PluginContext
extends Plugin {
    public static final String FLUENT_CLASS_NAME = "Fluent";
    public static final String FLUENT_INTERFACE_NAME = "FluentSupport";
    public static final String BUILDER_CLASS_NAME = "Builder";
    public static final String BUILDER_INTERFACE_NAME = "BuildSupport";
    public static final String WRAPPER_CLASS_NAME = "Wrapper";
    public static final String MODIFIER_CLASS_NAME = "Modifier";
    public static final String WRAPPER_INTERFACE_NAME = "WrapSupport";
    public static final String MODIFIER_INTERFACE_NAME = "ModifySupport";
    public static final String BUILD_METHOD_NAME = "build";
    public static final String MODIFY_METHOD_NAME = "apply";
    public static final String INIT_METHOD_NAME = "init";
    public static final String ADD_METHOD_PREFIX = "add";
    public static final String WITH_METHOD_PREFIX = "with";
    public static final String NEW_OBJECT_VAR_NAME = "_newObject";
    public static final String ADD_ALL = "addAll";
    public static final String CLONE_METHOD_NAME = "clone";
    public static final String COPY_METHOD_NAME = "createCopy";
    public static final String COPY_EXCEPT_METHOD_NAME = "copyExcept";
    public static final String COPY_ONLY_METHOD_NAME = "copyOnly";
    public static final String BUILD_COPY_METHOD_NAME = "copyOf";
    public static final String NEW_BUILDER_METHOD_NAME = "builder";
    public static final String NEW_MODIFIER_METHOD_NAME = "modifier";
    public static final String NEW_COPY_BUILDER_METHOD_NAME = "newCopyBuilder";
    public static final String COPY_TO_METHOD_NAME = "copyTo";
    private static final String AS_LIST = "asList";
    private static final String UNMODIFIABLE_LIST = "unmodifiableList";
    public final JCodeModel codeModel;
    public final JClass arrayListClass;
    public final JClass listClass;
    public final JClass iterableClass;
    public final JClass collectionClass;
    public final Options opt;
    public final JClass cloneableInterface;
    public final Outline outline;
    public final ErrorHandler errorHandler;
    public final Map<QName, ClassOutline> classesBySchemaComponent;
    public final JClass partialCopyableInterface;
    public final JClass copyableInterface;
    public final JClass stringClass;
    public final JClass voidClass;
    public final JType voidType;
    public final JClass buildableClass;
    public final JClass buildableInterface;
    public final JClass cloneGraphClass;
    public final JExpression excludeConst;
    public final JExpression includeConst;
    public final String cloneMethodName;
    public final String copyMethodName;
    public final String copyExceptMethodName;
    public final String copyOnlyMethodName;
    public final String buildCopyMethodName;
    public final String newBuilderMethodName;
    public final String newModifierMethodName;
    public final String newCopyBuilderMethodName;
    public final String newObjectVarName;
    private final JClass collectionsClass;
    private final JClass arraysClass;
    private final Map<String, ClassOutline> classes;
    private final Map<String, EnumOutline> enums;

    private PluginContext(Outline outline, Options opt, ErrorHandler errorHandler) {
        this.outline = outline;
        this.errorHandler = errorHandler;
        this.codeModel = outline.getCodeModel();
        this.opt = opt;
        this.arrayListClass = this.codeModel.ref(ArrayList.class);
        this.listClass = this.codeModel.ref(List.class);
        this.iterableClass = this.codeModel.ref(Iterable.class);
        this.collectionClass = this.codeModel.ref(Collection.class);
        this.collectionsClass = this.codeModel.ref(Collections.class);
        this.arraysClass = this.codeModel.ref(Arrays.class);
        this.cloneableInterface = this.codeModel.ref(Cloneable.class);
        this.partialCopyableInterface = this.codeModel.ref(PartialCopyable.class);
        this.copyableInterface = this.codeModel.ref(Copyable.class);
        this.classes = new HashMap<String, ClassOutline>(outline.getClasses().size());
        this.classesBySchemaComponent = new HashMap<QName, ClassOutline>(outline.getClasses().size());
        this.enums = new HashMap<String, EnumOutline>(outline.getEnums().size());
        this.cloneGraphClass = this.codeModel.ref(PropertyTree.class);
        this.stringClass = this.codeModel.ref(String.class);
        this.voidClass = this.codeModel.ref(Void.class);
        this.voidType = this.codeModel.VOID;
        for (ClassOutline classOutline : this.outline.getClasses()) {
            this.classes.put(classOutline.implClass.fullName(), classOutline);
            this.classesBySchemaComponent.put(classOutline.target.getTypeName(), classOutline);
        }
        for (ClassOutline classOutline : this.outline.getEnums()) {
            this.enums.put(classOutline.clazz.fullName(), (EnumOutline)classOutline);
        }
        this.excludeConst = this.codeModel.ref(PropertyTreeUse.class).staticRef("EXCLUDE");
        this.includeConst = this.codeModel.ref(PropertyTreeUse.class).staticRef("INCLUDE");
        this.cloneMethodName = CLONE_METHOD_NAME;
        this.copyMethodName = COPY_METHOD_NAME;
        this.copyExceptMethodName = COPY_EXCEPT_METHOD_NAME;
        this.copyOnlyMethodName = COPY_ONLY_METHOD_NAME;
        this.buildCopyMethodName = BUILD_COPY_METHOD_NAME;
        this.newBuilderMethodName = NEW_BUILDER_METHOD_NAME;
        this.newModifierMethodName = NEW_MODIFIER_METHOD_NAME;
        this.newCopyBuilderMethodName = NEW_COPY_BUILDER_METHOD_NAME;
        this.newObjectVarName = NEW_OBJECT_VAR_NAME;
        this.buildableInterface = this.codeModel.ref(Buildable.class);
        this.buildableClass = this.codeModel.ref(Buildable.PrimitiveBuildable.class);
    }

    public static PluginContext get(Outline outline, Options opt, ErrorHandler errorHandler) {
        PluginContext context = PluginContext.findPlugin(opt.getAllPlugins(), PluginContext.class);
        if (context == null) {
            context = new PluginContext(outline, opt, errorHandler);
            opt.getAllPlugins().add(context);
        }
        return context;
    }

    public static <T> T coalesce(T ... args) {
        for (T t : args) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static Class<?> findInnerClass(Class<?> outer, String name) {
        for (Class<?> innerClass : outer.getDeclaredClasses()) {
            if (!name.equals(innerClass.getSimpleName())) continue;
            return innerClass;
        }
        return null;
    }

    public static QName getQName(XSDeclaration declaration) {
        return new QName(declaration.getTargetNamespace(), declaration.getName());
    }

    public static QName getQName(Class<?> boundClass) {
        return new QName(PluginContext.getNamespaceUri(boundClass), PluginContext.getLocalName(boundClass));
    }

    private static String getNamespaceUri(Class<?> boundClass) {
        XmlRootElement elementAnnotation = boundClass.getAnnotation(XmlRootElement.class);
        if (elementAnnotation != null && !"##default".equals(elementAnnotation.namespace())) {
            return elementAnnotation.namespace();
        }
        XmlType xmlTypeAnnotation = boundClass.getAnnotation(XmlType.class);
        if (xmlTypeAnnotation != null && !"##default".equals(xmlTypeAnnotation.namespace())) {
            return xmlTypeAnnotation.namespace();
        }
        return PluginContext.getNamespaceUri(boundClass.getPackage());
    }

    private static String getLocalName(Class<?> boundClass) {
        XmlRootElement elementAnnotation = boundClass.getAnnotation(XmlRootElement.class);
        if (elementAnnotation != null && !"##default".equals(elementAnnotation.name())) {
            return elementAnnotation.name();
        }
        XmlType xmlTypeAnnotation = boundClass.getAnnotation(XmlType.class);
        if (xmlTypeAnnotation != null && !"##default".equals(xmlTypeAnnotation.name())) {
            return xmlTypeAnnotation.name();
        }
        return boundClass.getSimpleName();
    }

    private static String getNamespaceUri(Package pkg) {
        XmlSchema xmlSchemaAnnotation = pkg.getAnnotation(XmlSchema.class);
        return xmlSchemaAnnotation != null && !"##default".equals(xmlSchemaAnnotation.namespace()) ? xmlSchemaAnnotation.namespace() : null;
    }

    public static JMethod findGetter(FieldOutline field) {
        String getterName;
        JMethod m;
        ClassOutline classOutline = field.parent();
        String propertyName = field.getPropertyInfo().getName(true);
        if ("Any".equals(propertyName)) {
            propertyName = "Content";
        }
        if ((m = classOutline.implClass.getMethod(getterName = "get" + propertyName, new JType[0])) == null) {
            getterName = "is" + propertyName;
            m = classOutline.implClass.getMethod(getterName, new JType[0]);
        }
        return m;
    }

    public static JMethod findSetter(FieldOutline field) {
        ClassOutline classOutline = field.parent();
        String propertyName = field.getPropertyInfo().getName(true);
        if ("Any".equals(propertyName)) {
            propertyName = "Content";
        }
        String setterName = "set" + propertyName;
        for (JMethod method : classOutline.implClass.methods()) {
            if (!method.name().equals(setterName) || method.listParams().length != 1) continue;
            return method;
        }
        return null;
    }

    public static <P extends Plugin> P findPlugin(Options opt, Class<P> pluginClass) {
        return PluginContext.findPlugin(opt.activePlugins, pluginClass);
    }

    public static <P extends Plugin> P findPlugin(Iterable<Plugin> pluginCollection, Class<P> pluginClass) {
        for (Plugin plugin : pluginCollection) {
            if (!pluginClass.isInstance(plugin)) continue;
            return (P)plugin;
        }
        return null;
    }

    public static JClass extractMutableListClass(FieldOutline fieldOutline) {
        JClass customMutableListClass = (JClass)PluginContext.readPrivateField(fieldOutline, "coreList");
        return customMutableListClass == null ? fieldOutline.getRawType().owner().ref(ArrayList.class) : customMutableListClass.erasure();
    }

    private static Object readPrivateField(Object obj, String fieldName) {
        try {
            Class<?> cls = obj.getClass();
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }

    private boolean cloneThrows(Class<? extends Cloneable> cloneableClass) {
        if (cloneableClass.getSuperclass() == null) {
            return true;
        }
        try {
            Method cloneMethod = cloneableClass.getMethod(this.cloneMethodName, new Class[0]);
            Class<?>[] exceptionTypes = cloneMethod.getExceptionTypes();
            return exceptionTypes.length > 0 && CloneNotSupportedException.class.isAssignableFrom(exceptionTypes[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public JInvocation asList(JExpression expression) {
        return this.arraysClass.staticInvoke(AS_LIST).arg(expression);
    }

    public JInvocation unmodifiableList(JExpression expression) {
        return this.collectionsClass.staticInvoke(UNMODIFIABLE_LIST).arg(expression);
    }

    public boolean hasPlugin(Class<? extends Plugin> pluginClass) {
        for (Plugin plugin : this.opt.activePlugins) {
            if (!pluginClass.isInstance(plugin)) continue;
            return true;
        }
        return false;
    }

    public <P extends Plugin> P findPlugin(Class<P> pluginClass) {
        return PluginContext.findPlugin(this.opt, pluginClass);
    }

    public boolean canInstantiate(JType type) {
        return this.getClassOutline(type) != null && !((JClass)type).isAbstract();
    }

    public JExpression castOnDemand(JType fieldType, JExpression expression) {
        return this.classes.containsKey(fieldType.fullName()) ? expression : JExpr.cast((JType)fieldType, (JExpression)expression);
    }

    public ClassOutline getClassOutline(JType typeSpec) {
        return this.classes.get(typeSpec.fullName());
    }

    EnumOutline getEnumOutline(JType typeSpec) {
        return this.enums.get(typeSpec.fullName());
    }

    public JForEach loop(JBlock block, JExpression source, JType sourceElementType, JAssignmentTarget target, JType targetElementType, FieldOutline fieldOutline) {
        JConditional ifNull = block._if(source.eq(JExpr._null()));
        ifNull._then().assign(target, JExpr._null());
        ifNull._else().assign(target, (JExpression)JExpr._new((JClass)PluginContext.extractMutableListClass(fieldOutline).narrow(targetElementType)));
        return ifNull._else().forEach(sourceElementType, "_item", source);
    }

    public JInvocation newArrayList(JClass mutableListClass, JClass elementType) {
        return JExpr._new((JClass)mutableListClass.narrow(elementType));
    }

    public JDirectInnerClassRef ref(JClass outer, String name, boolean isInterface, boolean isAbstract, JClass superClass) {
        return new JDirectInnerClassRef(outer, name, isInterface, isAbstract, superClass);
    }

    public JDirectInnerClassRef ref(JClass outer, String name, boolean isInterface) {
        return new JDirectInnerClassRef(outer, name, isInterface, false, null);
    }

    public JDirectInnerClassRef ref(JClass outer, String name) {
        return new JDirectInnerClassRef(outer, name, false, false, null);
    }

    public JTypedInvocation invoke(JExpression lhs, String method) {
        return new JTypedInvocation(lhs, method);
    }

    public JTypedInvocation invoke(JType lhs, String method) {
        return new JTypedInvocation(lhs, method);
    }

    public JTypedInvocation invoke(String method) {
        return new JTypedInvocation(method);
    }

    public JTypedInvocation _super() {
        return this.invoke("super");
    }

    public CopyGenerator createCopyGenerator(JMethod method, boolean partial) {
        return partial ? new PartialCopyGenerator(this, method) : new FullCopyGenerator();
    }

    public void writeSourceFile(Class<?> classToBeWritten) {
        String resourcePath = "/" + classToBeWritten.getName().replace('.', '/') + ".java";
        JPackage jPackage = this.outline.getCodeModel()._package(classToBeWritten.getPackage().getName());
        JStaticJavaFile javaFile = new JStaticJavaFile(jPackage, classToBeWritten.getSimpleName(), classToBeWritten, null);
        jPackage.addResourceFile((JResourceFile)javaFile);
    }

    public void generateImmutableFieldInit(JBlock body, JExpression object, JFieldVar field) {
        ImmutablePlugin immutablePlugin = this.findPlugin(ImmutablePlugin.class);
        if (immutablePlugin != null) {
            immutablePlugin.immutableInit(this, body, object, field);
        }
    }

    public void generateImmutableFieldInit(JBlock body, JExpression object, PropertyOutline propertyOutline) {
        ImmutablePlugin immutablePlugin = this.findPlugin(ImmutablePlugin.class);
        if (immutablePlugin != null) {
            immutablePlugin.immutableInit(this, body, object, propertyOutline);
        }
    }

    JBlock catchCloneNotSupported(JBlock body, JClass elementType) {
        Class<?> elementRuntimeClass;
        try {
            elementRuntimeClass = Class.forName(elementType.binaryName());
        }
        catch (ClassNotFoundException e) {
            return body;
        }
        if (!this.cloneThrows(elementRuntimeClass)) {
            return body;
        }
        JTryBlock tryBlock = body._try();
        JCatchBlock catchBlock = tryBlock._catch(this.codeModel.ref(CloneNotSupportedException.class));
        JVar exceptionVar = catchBlock.param("e");
        catchBlock.body()._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(RuntimeException.class)).arg((JExpression)exceptionVar));
        return tryBlock.body();
    }

    boolean mustCatch(JClass fieldType) {
        Class<?> elementRuntimeClass;
        try {
            elementRuntimeClass = Class.forName(fieldType.binaryName());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return this.cloneThrows(elementRuntimeClass);
    }

    public <T> T getCustomization(Class<T> customizationClass, Deque<CCustomizable> schemaComponents) {
        QName qName = PluginContext.getQName(customizationClass);
        if (!schemaComponents.isEmpty()) {
            CCustomizable schemaComponent = schemaComponents.pop();
            CPluginCustomization pluginCustomization = schemaComponent.getCustomizations().find(qName.getNamespaceURI(), qName.getLocalPart());
            if (pluginCustomization == null) {
                return this.getCustomization(customizationClass, schemaComponents);
            }
            pluginCustomization.markAsAcknowledged();
            return (T)JAXB.unmarshal((Source)new DOMSource(pluginCustomization.element), customizationClass);
        }
        CPluginCustomization pluginCustomization = this.outline.getModel().getCustomizations().find(qName.getNamespaceURI(), qName.getLocalPart());
        if (pluginCustomization != null) {
            pluginCustomization.markAsAcknowledged();
            return (T)JAXB.unmarshal((Source)new DOMSource(pluginCustomization.element), customizationClass);
        }
        return null;
    }

    public <T> T getCustomization(Class<T> customizationClass, CCustomizable ... schemaComponents) {
        ArrayDeque<CCustomizable> schemaComponentDeque = new ArrayDeque<CCustomizable>(Arrays.asList(schemaComponents));
        return this.getCustomization(customizationClass, schemaComponentDeque);
    }

    public <T> T getCustomization(Class<T> customizationClass, T defaultValue, CCustomizable ... schemaComponents) {
        T val = this.getCustomization(customizationClass, schemaComponents);
        return val == null ? defaultValue : val;
    }

    public String getOptionName() {
        return "-X_pluginContext_";
    }

    public String getUsage() {
        return "";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        return true;
    }

    public JTypedInvocation _new(JClass type) {
        return new JTypedInvocation(type);
    }

    private String convertWord(String str, BiFunction<NameConverter, String, String> converterFunction) {
        String name = this.outline.getModel() != null ? converterFunction.apply(this.outline.getModel().getNameConverter(), str) : converterFunction.apply(NameConverter.standard, str);
        if (!JJavaName.isJavaIdentifier((String)name)) {
            return "_" + name;
        }
        return name;
    }

    String toVariableName(String str) {
        return this.convertWord(str, NameConverter::toVariableName);
    }

    String toPropertyName(String str) {
        return this.convertWord(str, NameConverter::toPropertyName);
    }

    boolean areVariableNamesEqual(String variable1, String variable2) {
        return this.areStringsEqual(variable1, variable2, this::toVariableName);
    }

    boolean arePropertyNamesEqual(String variable1, String variable2) {
        return this.areStringsEqual(variable1, variable2, this::toPropertyName);
    }

    private boolean areStringsEqual(String str1, String str2, Function<String, String> converterFunction) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return converterFunction.apply(str1).equals(converterFunction.apply(str2));
    }
}

