/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc;

import com.kscs.util.plugins.xjc.MetaInfoOutline;
import com.kscs.util.plugins.xjc.PluginContext;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

class SelectorGenerator {
    private static final Logger LOGGER = Logger.getLogger(SelectorGenerator.class.getName());
    final Class<?> selectorBaseClass;
    private final String selectorClassName;
    private final String rootSelectorClassName;
    final String selectorParamName;
    private final JType selectorParamType;
    private final JClass propertyPathClass;
    private final PluginContext pluginContext;
    private final Map<String, MetaInfoOutline> infoClasses = new LinkedHashMap<String, MetaInfoOutline>();

    public SelectorGenerator(PluginContext pluginContext, Class<?> selectorBaseClass, String selectorClassName, String rootSelectorClassName, String selectorParamName, JType selectorParamType, JClass propertyPathClass) {
        this.pluginContext = pluginContext;
        this.selectorBaseClass = selectorBaseClass;
        this.selectorClassName = selectorClassName;
        this.rootSelectorClassName = rootSelectorClassName;
        this.selectorParamName = selectorParamName;
        this.selectorParamType = selectorParamType;
        this.propertyPathClass = propertyPathClass;
        for (ClassOutline classOutline : pluginContext.outline.getClasses()) {
            this.infoClasses.put(classOutline.implClass.fullName(), this.generateMetaClass(classOutline));
        }
    }

    private MetaInfoOutline generateMetaClass(ClassOutline classOutline) {
        try {
            JDefinedClass definedClass = classOutline.implClass;
            JDefinedClass selectorClass = definedClass._class(17, this.selectorClassName);
            JTypeVar rootTypeParam = selectorClass.generify("TRoot");
            JTypeVar parentTypeParam = selectorClass.generify("TParent");
            rootTypeParam.bound(this.pluginContext.codeModel.ref(this.selectorBaseClass).narrow(new JClass[]{rootTypeParam, this.pluginContext.codeModel.wildcard()}));
            JMethod constructor = selectorClass.constructor(1);
            JVar rootParam = constructor.param(8, (JType)rootTypeParam, "root");
            JVar parentParam = constructor.param(8, (JType)parentTypeParam, "parent");
            JVar propertyNameParam = constructor.param(8, (JType)this.pluginContext.stringClass, "propertyName");
            if (this.selectorParamName != null) {
                JVar includeParam = constructor.param(8, this.getSelectorParamType(this.pluginContext.codeModel.wildcard(), (JType)definedClass.wildcard()), this.selectorParamName);
                constructor.body().invoke("super").arg((JExpression)rootParam).arg((JExpression)parentParam).arg((JExpression)propertyNameParam).arg((JExpression)includeParam);
            } else {
                constructor.body().invoke("super").arg((JExpression)rootParam).arg((JExpression)parentParam).arg((JExpression)propertyNameParam);
            }
            JClass productMapType = this.pluginContext.codeModel.ref(Map.class).narrow(String.class).narrow(this.propertyPathClass);
            JMethod buildChildrenMethod = selectorClass.method(1, (JType)productMapType, "buildChildren");
            buildChildrenMethod.annotate(Override.class);
            JVar productMapVar = buildChildrenMethod.body().decl(8, (JType)productMapType, "products", (JExpression)JExpr._new((JClass)this.pluginContext.codeModel.ref(HashMap.class).narrow(String.class).narrow(this.propertyPathClass)));
            if (classOutline.getSuperClass() == null) {
                selectorClass._extends(this.pluginContext.codeModel.ref(this.selectorBaseClass).narrow((JClass)rootTypeParam).narrow((JClass)parentTypeParam));
            }
            JDefinedClass rootSelectorClass = definedClass._class(17, this.rootSelectorClassName);
            rootSelectorClass._extends(selectorClass.narrow((JClass)rootSelectorClass).narrow(Void.class));
            JMethod rootSelectorConstructor = rootSelectorClass.constructor(0);
            if (this.selectorParamName != null) {
                JVar rootSelectorClassIncludeParam = rootSelectorConstructor.param(8, this.getSelectorParamType(this.pluginContext.voidClass, (JType)definedClass), this.selectorParamName);
                rootSelectorConstructor.body().invoke("super").arg(JExpr._null()).arg(JExpr._null()).arg(JExpr._null()).arg((JExpression)rootSelectorClassIncludeParam);
            } else {
                rootSelectorConstructor.body().invoke("super").arg(JExpr._null()).arg(JExpr._null()).arg(JExpr._null());
            }
            JMethod rootMethod = rootSelectorClass.method(17, (JType)rootSelectorClass, "_root");
            if (this.selectorParamName != null) {
                JVar rootIncludeParam = rootMethod.param(8, this.getSelectorParamType(this.pluginContext.voidClass, (JType)definedClass), this.selectorParamName);
                rootMethod.body()._return((JExpression)JExpr._new((JClass)rootSelectorClass).arg((JExpression)rootIncludeParam));
            } else {
                rootMethod.body()._return((JExpression)JExpr._new((JClass)rootSelectorClass));
            }
            return new MetaInfoOutline(this, classOutline, selectorClass, rootTypeParam, parentTypeParam, buildChildrenMethod, productMapVar);
        }
        catch (JClassAlreadyExistsException e) {
            LOGGER.warning("Attempt to generate already existing class");
            return null;
        }
    }

    public void generateMetaFields() {
        for (MetaInfoOutline entry : this.infoClasses.values()) {
            entry.generateMetaFields();
        }
    }

    PluginContext getPluginContext() {
        return this.pluginContext;
    }

    MetaInfoOutline getInfoClass(JType mainType) {
        return this.infoClasses.get(mainType.fullName());
    }

    JType getSelectorParamType(JClass instanceType, JType propertyType) {
        if (this.selectorParamType.isReference()) {
            return ((JClass)this.selectorParamType).narrow(instanceType).narrow(propertyType);
        }
        return this.selectorParamType;
    }
}

