/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.PropertyDirectoryResourceBundle;
import com.kscs.util.plugins.xjc.outline.PropertyOutline;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.outline.FieldOutline;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class PluginUtil {
    private static final ResourceBundle resourceBundle = PropertyDirectoryResourceBundle.getInstance(PluginUtil.class);

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(resourceBundle.getString(key), args);
    }

    private PluginUtil() {
    }

    public static JFieldVar getDeclaredField(FieldOutline fieldOutline) {
        return (JFieldVar)fieldOutline.parent().implClass.fields().get(fieldOutline.getPropertyInfo().getName(false));
    }

    public static JExpression nullSafe(JExpression test, JExpression source) {
        return JOp.cond((JExpression)test.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)source);
    }

    public static JExpression nullSafe(FieldOutline test, JExpression source) {
        return PluginUtil.nullSafe((JExpression)JExpr.ref((String)test.getPropertyInfo().getName(false)), source);
    }

    public static JExpression nullSafe(PropertyOutline test, JExpression source) {
        return PluginUtil.nullSafe((JExpression)JExpr.ref((String)test.getFieldName()), source);
    }

    public static JType getElementType(FieldOutline fieldOutline) {
        JFieldVar definedField = PluginUtil.getDeclaredField(fieldOutline);
        if (definedField != null) {
            if (fieldOutline.getPropertyInfo().isCollection()) {
                return definedField.type().isArray() ? definedField.type().elementType() : (JType)((JClass)definedField.type()).getTypeParameters().get(0);
            }
            return definedField.type();
        }
        return null;
    }

    public static <I, T extends I> T getConfiguredObject(Class<I> interfaceClass, Class<T> defaultClass) {
        Class<Object> strategyClass;
        String strategyClassName = System.getProperty(interfaceClass.getName());
        if (strategyClassName == null || strategyClassName.trim().isEmpty()) {
            strategyClass = defaultClass;
        } else {
            try {
                strategyClass = Class.forName(strategyClassName);
            }
            catch (ClassNotFoundException cnfe) {
                strategyClass = defaultClass;
            }
        }
        try {
            return strategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(PluginUtil.getMessage("error.no-such-constructor", strategyClassName), e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException(PluginUtil.getMessage("error.cannot-instatiate-strategy", strategyClassName), ex);
        }
    }
}

