/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.outline;

import com.kscs.util.plugins.xjc.SchemaAnnotationUtils;
import com.kscs.util.plugins.xjc.outline.DefinedPropertyOutline;
import com.kscs.util.plugins.xjc.outline.DefinedTypeOutline;
import com.kscs.util.plugins.xjc.outline.ReferencedRuntimeClassOutline;
import com.kscs.util.plugins.xjc.outline.ReferencedStubClassOutline;
import com.kscs.util.plugins.xjc.outline.TypeOutline;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DefinedClassOutline
implements DefinedTypeOutline {
    private final ClassOutline classOutline;
    private final List<DefinedPropertyOutline> declaredFields;
    private final TypeOutline superClass;

    public DefinedClassOutline(ClassOutline classOutline) {
        this.classOutline = classOutline;
        ArrayList<DefinedPropertyOutline> properties = new ArrayList<DefinedPropertyOutline>(classOutline.getDeclaredFields().length);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            properties.add(new DefinedPropertyOutline(fieldOutline));
        }
        this.declaredFields = Collections.unmodifiableList(properties);
        this.superClass = DefinedClassOutline.findSuperclass(this.classOutline);
    }

    private static TypeOutline findSuperclass(ClassOutline modelClass) {
        if (modelClass.getSuperClass() != null) {
            return new DefinedClassOutline(modelClass.getSuperClass());
        }
        try {
            Class<?> ungeneratedSuperClass = Class.forName(modelClass.implClass._extends().fullName());
            if (Object.class.equals(ungeneratedSuperClass)) {
                return null;
            }
            return new ReferencedRuntimeClassOutline(modelClass.implClass.owner(), ungeneratedSuperClass);
        }
        catch (ClassNotFoundException e) {
            return new ReferencedStubClassOutline(modelClass.implClass.owner(), modelClass.implClass._extends());
        }
    }

    @Override
    public List<DefinedPropertyOutline> getDeclaredFields() {
        return this.declaredFields;
    }

    @Override
    public TypeOutline getSuperClass() {
        return this.superClass;
    }

    @Override
    public JDefinedClass getImplClass() {
        return this.classOutline.implClass;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public Optional<String> getSchemaAnnotationText() {
        String annotationText = SchemaAnnotationUtils.getClassAnnotationDescription(this.classOutline.target);
        if (annotationText == null || annotationText.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(annotationText);
    }

    public ClassOutline getClassOutline() {
        return this.classOutline;
    }
}

