/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.outline;

import com.kscs.util.plugins.xjc.PluginContext;
import com.kscs.util.plugins.xjc.SchemaAnnotationUtils;
import com.kscs.util.plugins.xjc.outline.PropertyOutline;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.glassfish.jaxb.core.v2.model.core.Element;
import org.glassfish.jaxb.core.v2.model.core.ElementPropertyInfo;
import org.glassfish.jaxb.core.v2.model.core.ReferencePropertyInfo;
import org.glassfish.jaxb.core.v2.model.core.TypeInfo;
import org.glassfish.jaxb.core.v2.model.core.TypeRef;

public class DefinedPropertyOutline
implements PropertyOutline {
    private final FieldOutline fieldOutline;
    private final List<PropertyOutline.TagRef> referencedItems;
    private final Map<PropertyOutline.TagRef, String> referencedAnnotations;
    private final JClass jaxbElementClass;
    private final String annotationText;
    private final JClass mutableListClass;
    private final JDefinedClass referencedModelClass;
    private final boolean choice;

    public DefinedPropertyOutline(FieldOutline fieldOutline) {
        JCodeModel codeModel = fieldOutline.getRawType().owner();
        this.fieldOutline = fieldOutline;
        CPropertyInfo propertyInfo = fieldOutline.getPropertyInfo();
        this.jaxbElementClass = codeModel.ref(JAXBElement.class);
        ClassOutline classOutline = fieldOutline.parent();
        JDefinedClass jDefinedClass = this.referencedModelClass = fieldOutline.getRawType().fullName().contains(".") ? codeModel._getClass(fieldOutline.getRawType().fullName()) : DefinedPropertyOutline.resolveTypeName(classOutline.getImplClass(), fieldOutline.getRawType().fullName());
        if (propertyInfo instanceof ElementPropertyInfo) {
            ElementPropertyInfo elementPropertyInfo = (ElementPropertyInfo)propertyInfo;
            this.referencedItems = new ArrayList<PropertyOutline.TagRef>(elementPropertyInfo.getTypes().size());
            this.referencedAnnotations = new HashMap<PropertyOutline.TagRef, String>(elementPropertyInfo.getTypes().size());
            for (TypeRef typeRef : elementPropertyInfo.getTypes()) {
                PropertyOutline.TagRef tagRef = new PropertyOutline.TagRef(typeRef.getTagName(), (TypeInfo<NType, NClass>)typeRef.getTarget());
                this.referencedItems.add(tagRef);
                if (!(typeRef.getTarget() instanceof CClassInfo)) continue;
                String referencedItemAnnotation = SchemaAnnotationUtils.getClassAnnotationDescription((CClassInfo)typeRef.getTarget());
                this.referencedAnnotations.put(tagRef, referencedItemAnnotation);
            }
            this.annotationText = elementPropertyInfo.getTypes() != null && elementPropertyInfo.getTypes().size() > 1 ? null : SchemaAnnotationUtils.getFieldAnnotationDescription(propertyInfo);
        } else if (propertyInfo instanceof ReferencePropertyInfo) {
            ReferencePropertyInfo elementPropertyInfo = (ReferencePropertyInfo)propertyInfo;
            this.referencedItems = new ArrayList<PropertyOutline.TagRef>(elementPropertyInfo.getElements().size());
            this.referencedAnnotations = new HashMap<PropertyOutline.TagRef, String>(elementPropertyInfo.getElements().size());
            for (Element element : elementPropertyInfo.getElements()) {
                this.referencedItems.add(new PropertyOutline.TagRef(element.getElementName(), (TypeInfo<NType, NClass>)element));
            }
            this.annotationText = SchemaAnnotationUtils.getFieldAnnotationDescription(propertyInfo);
        } else {
            this.referencedItems = Collections.emptyList();
            this.referencedAnnotations = Collections.emptyMap();
            this.annotationText = SchemaAnnotationUtils.getFieldAnnotationDescription(propertyInfo);
        }
        this.mutableListClass = PluginContext.extractMutableListClass(fieldOutline);
        this.choice = this.referencedItems.size() > 1;
    }

    @Override
    public String getBaseName() {
        return this.fieldOutline.getPropertyInfo().getName(true);
    }

    @Override
    public String getFieldName() {
        return this.fieldOutline.getPropertyInfo().getName(false);
    }

    @Override
    public JType getRawType() {
        return this.fieldOutline.getRawType();
    }

    @Override
    public JType getElementType() {
        if (this.isCollection() && !this.getRawType().isArray()) {
            return (JType)((JClass)this.getRawType()).getTypeParameters().get(0);
        }
        return this.getRawType();
    }

    @Override
    public boolean isIndirect() {
        return this.jaxbElementClass.fullName().equals(this.getElementType().erasure().fullName());
    }

    @Override
    public JFieldVar getFieldVar() {
        String propertyName = this.fieldOutline.getPropertyInfo().getName(false);
        if ("any".equals(propertyName)) {
            propertyName = "content";
        }
        return (JFieldVar)this.fieldOutline.parent().implClass.fields().get(propertyName);
    }

    @Override
    public boolean hasGetter() {
        for (JMethod method : this.fieldOutline.parent().implClass.methods()) {
            if (!method.name().equals("get" + this.fieldOutline.getPropertyInfo().getName(true)) && !method.name().equals("is" + this.fieldOutline.getPropertyInfo().getName(true)) || !method.params().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCollection() {
        return this.fieldOutline.getPropertyInfo().isCollection();
    }

    @Override
    public List<PropertyOutline.TagRef> getChoiceProperties() {
        return this.referencedItems;
    }

    @Override
    public Optional<String> getSchemaAnnotationText() {
        if (this.annotationText == null || this.annotationText.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.annotationText);
    }

    @Override
    public Optional<String> getSchemaAnnotationText(PropertyOutline.TagRef tagRef) {
        if (this.referencedAnnotations == null || this.referencedAnnotations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.referencedAnnotations.get(tagRef));
    }

    public boolean isArray() {
        return this.getRawType().isArray();
    }

    @Override
    public JClass getMutableListClass() {
        return this.mutableListClass;
    }

    public FieldOutline getFieldOutline() {
        return this.fieldOutline;
    }

    @Override
    public JDefinedClass getReferencedModelClass() {
        return this.referencedModelClass;
    }

    private static JDefinedClass resolveTypeName(JDefinedClass scope, String typeName) {
        return DefinedPropertyOutline.iteratorToList(scope.classes()).stream().filter(dc -> dc.name().equals(typeName)).findFirst().orElse(scope.outer() != null ? DefinedPropertyOutline.resolveTypeName((JDefinedClass)scope.outer(), typeName) : DefinedPropertyOutline.iteratorToList(scope.getPackage().classes()).stream().filter(dc -> dc.name().equals(typeName)).findFirst().orElse(scope.owner()._getClass(typeName)));
    }

    private static <T> List<T> iteratorToList(Iterator<T> iterator) {
        ArrayList list = new ArrayList();
        iterator.forEachRemaining(list::add);
        return list;
    }

    public boolean isChoice() {
        return this.choice;
    }
}

