/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.outline;

import com.kscs.util.plugins.xjc.outline.PropertyOutline;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReferencedPropertyOutline
implements PropertyOutline {
    private final Field field;
    private final JCodeModel codeModel;
    private JType rawType = null;
    private boolean collection = false;

    public ReferencedPropertyOutline(JCodeModel codeModel, Field field) {
        this.codeModel = codeModel;
        this.field = field;
    }

    @Override
    public String getBaseName() {
        return this.field.getName().substring(0, 1).toUpperCase() + this.field.getName().substring(1);
    }

    @Override
    public String getFieldName() {
        return this.field.getName();
    }

    @Override
    public JType getElementType() {
        this.initRawType();
        return this.rawType;
    }

    @Override
    public JType getRawType() {
        if (this.isCollection() && !this.field.getType().isArray()) {
            return this.codeModel.ref(this.field.getType()).narrow(this.getElementType());
        }
        return this.codeModel._ref(this.field.getType());
    }

    private void initRawType() {
        if (this.rawType == null) {
            Class type;
            Class<?> declaredType = this.field.getType();
            if (declaredType.isArray()) {
                type = declaredType.getComponentType();
                this.collection = true;
            } else if (Collection.class.isAssignableFrom(declaredType)) {
                type = (Class)((ParameterizedType)this.field.getGenericType()).getActualTypeArguments()[0];
                this.collection = true;
            } else {
                type = declaredType;
            }
            this.rawType = this.codeModel._ref(type);
        }
    }

    @Override
    public JFieldVar getFieldVar() {
        return null;
    }

    @Override
    public boolean hasGetter() {
        Method method;
        try {
            method = this.field.getDeclaringClass().getMethod("get" + this.getBaseName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                method = this.field.getDeclaringClass().getMethod("is" + this.getBaseName(), new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                method = null;
            }
        }
        return method != null;
    }

    @Override
    public boolean isCollection() {
        this.initRawType();
        return this.collection;
    }

    @Override
    public boolean isIndirect() {
        return this.getElementType().erasure().fullName().equals(this.codeModel.ref(JAXBElement.class).fullName());
    }

    @Override
    public List<PropertyOutline.TagRef> getChoiceProperties() {
        return Collections.emptyList();
    }

    @Override
    public JClass getMutableListClass() {
        return this.codeModel.ref(this.field.getType());
    }

    @Override
    public JDefinedClass getReferencedModelClass() {
        return null;
    }
}

