/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.outline;

import com.kscs.util.plugins.xjc.outline.PropertyOutline;
import com.kscs.util.plugins.xjc.outline.ReferencedPropertyOutline;
import com.kscs.util.plugins.xjc.outline.TypeOutline;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ReferencedRuntimeClassOutline
implements TypeOutline {
    private final Class<?> referencedClass;
    private final JCodeModel codeModel;
    private final List<PropertyOutline> declaredFields;
    private final ReferencedRuntimeClassOutline superClassOutline;

    public ReferencedRuntimeClassOutline(JCodeModel codeModel, Class<?> referencedClass) {
        this.codeModel = codeModel;
        this.referencedClass = referencedClass;
        this.declaredFields = new ArrayList<PropertyOutline>(referencedClass.getDeclaredFields().length);
        for (Field field : referencedClass.getDeclaredFields()) {
            this.declaredFields.add(new ReferencedPropertyOutline(codeModel, field));
        }
        this.superClassOutline = this.referencedClass.getSuperclass() != null && !Object.class.equals(this.referencedClass.getSuperclass()) ? new ReferencedRuntimeClassOutline(this.codeModel, this.referencedClass.getSuperclass()) : null;
    }

    public List<PropertyOutline> getDeclaredFields() {
        return this.declaredFields;
    }

    @Override
    public ReferencedRuntimeClassOutline getSuperClass() {
        return this.superClassOutline;
    }

    @Override
    public JClass getImplClass() {
        return this.codeModel.ref(this.referencedClass);
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }
}

