/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.crypto;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.security.auth.Destroyable;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;
import net.consensys.cava.bytes.MutableBytes;
import net.consensys.cava.crypto.Hash;
import net.consensys.cava.crypto.InvalidSEC256K1SecretKeyStoreException;
import net.consensys.cava.io.file.Files;
import net.consensys.cava.units.bigints.UInt256;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;

public final class SECP256K1 {
    private static final String ALGORITHM = "ECDSA";
    private static final String CURVE_NAME = "secp256k1";
    private static final String PROVIDER = "BC";

    private SECP256K1() {
    }

    @Nullable
    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        byte[] compEnc = Parameters.X_9_INTEGER_CONVERTER.integerToBytes(xBN, 1 + Parameters.X_9_INTEGER_CONVERTER.getByteLength(Parameters.CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        try {
            return Parameters.CURVE.getCurve().decodePoint(compEnc);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static BigInteger recoverFromSignature(int v, BigInteger r, BigInteger s, Bytes32 messageHash) {
        assert (v == 0 || v == 1);
        assert (r.signum() >= 0);
        assert (s.signum() >= 0);
        assert (messageHash != null);
        ECPoint R = SECP256K1.decompressKey(r, (v & 1) == 1);
        if (R == null || !R.multiply(Parameters.CURVE_ORDER).isInfinity()) {
            return null;
        }
        BigInteger e = messageHash.toUnsignedBigInteger();
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(Parameters.CURVE_ORDER);
        BigInteger rInv = r.modInverse(Parameters.CURVE_ORDER);
        BigInteger srInv = rInv.multiply(s).mod(Parameters.CURVE_ORDER);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(Parameters.CURVE_ORDER);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)Parameters.CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
        if (q.isInfinity()) {
            return null;
        }
        byte[] qBytes = q.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
    }

    public static Signature sign(byte[] data, KeyPair keyPair) {
        return SECP256K1.signHashed(Hash.keccak256(data), keyPair);
    }

    public static Signature sign(Bytes data, KeyPair keyPair) {
        return SECP256K1.signHashed(Hash.keccak256(data), keyPair);
    }

    public static Signature signHashed(byte[] hash, KeyPair keyPair) {
        return SECP256K1.signHashed(Bytes32.wrap((byte[])hash), keyPair);
    }

    public static Signature signHashed(Bytes32 hash, KeyPair keyPair) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(keyPair.secretKey().bytes().toUnsignedBigInteger(), Parameters.CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(hash.toArrayUnsafe());
        BigInteger r = components[0];
        BigInteger s = components[1];
        if (s.compareTo(Parameters.HALF_CURVE_ORDER) > 0) {
            s = Parameters.CURVE_ORDER.subtract(s);
        }
        int recId = -1;
        BigInteger publicKeyBI = keyPair.publicKey().bytes().toUnsignedBigInteger();
        for (int i = 0; i < 2; ++i) {
            BigInteger k = SECP256K1.recoverFromSignature(i, r, s, hash);
            if (k == null || !k.equals(publicKeyBI)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Unexpected error - could not construct a recoverable key.");
        }
        byte v = (byte)recId;
        return new Signature(v, r, s);
    }

    public static boolean verify(byte[] data, Signature signature, PublicKey publicKey) {
        return SECP256K1.verifyHashed(Hash.keccak256(data), signature, publicKey);
    }

    public static boolean verify(Bytes data, Signature signature, PublicKey publicKey) {
        return SECP256K1.verifyHashed(Hash.keccak256(data), signature, publicKey);
    }

    public static boolean verifyHashed(Bytes32 hash, Signature signature, PublicKey publicKey) {
        return SECP256K1.verifyHashed(hash.toArrayUnsafe(), signature, publicKey);
    }

    public static boolean verifyHashed(byte[] hash, Signature signature, PublicKey publicKey) {
        ECDSASigner signer = new ECDSASigner();
        Bytes toDecode = Bytes.wrap((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{4}), publicKey.bytes()});
        ECPublicKeyParameters params = new ECPublicKeyParameters(Parameters.CURVE.getCurve().decodePoint(toDecode.toArray()), Parameters.CURVE);
        signer.init(false, (CipherParameters)params);
        try {
            return signer.verifySignature(hash, signature.r, signature.s);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static class Signature {
        private final byte v;
        private final BigInteger r;
        private final BigInteger s;

        public static Signature fromBytes(Bytes bytes) {
            Preconditions.checkNotNull((Object)bytes);
            Preconditions.checkArgument((bytes.size() == 65 ? 1 : 0) != 0, (String)"Signature must be 65 bytes, but got %s instead", (int)bytes.size());
            BigInteger r = bytes.slice(0, 32).toUnsignedBigInteger();
            BigInteger s = bytes.slice(32, 32).toUnsignedBigInteger();
            return new Signature(bytes.get(64), r, s);
        }

        public static Signature create(byte v, BigInteger r, BigInteger s) {
            return new Signature(v, r, s);
        }

        Signature(byte v, BigInteger r, BigInteger s) {
            Preconditions.checkArgument((v == 0 || v == 1 ? 1 : 0) != 0, (String)"Invalid v-value, should be 0 or 1, got %s", (int)v);
            Preconditions.checkNotNull((Object)r);
            Preconditions.checkNotNull((Object)s);
            Preconditions.checkArgument((r.compareTo(BigInteger.ONE) >= 0 && r.compareTo(Parameters.CURVE_ORDER) < 0 ? 1 : 0) != 0, (String)"Invalid r-value, should be >= 1 and < %s, got %s", (Object)Parameters.CURVE_ORDER, (Object)r);
            Preconditions.checkArgument((s.compareTo(BigInteger.ONE) >= 0 && s.compareTo(Parameters.CURVE_ORDER) < 0 ? 1 : 0) != 0, (String)"Invalid s-value, should be >= 1 and < %s, got %s", (Object)Parameters.CURVE_ORDER, (Object)s);
            this.v = v;
            this.r = r;
            this.s = s;
        }

        public byte v() {
            return this.v;
        }

        public BigInteger r() {
            return this.r;
        }

        public BigInteger s() {
            return this.s;
        }

        public boolean isCanonical() {
            return this.s.compareTo(Parameters.HALF_CURVE_ORDER) <= 0;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Signature)) {
                return false;
            }
            Signature that = (Signature)other;
            return this.r.equals(that.r) && this.s.equals(that.s) && this.v == that.v;
        }

        public Bytes bytes() {
            MutableBytes signature = MutableBytes.create((int)65);
            UInt256.valueOf((BigInteger)this.r).toBytes().copyTo(signature, 0);
            UInt256.valueOf((BigInteger)this.s).toBytes().copyTo(signature, 32);
            signature.set(64, this.v);
            return signature;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.r, this.s, this.v});
        }

        public String toString() {
            return "Signature{r=" + this.r + ", s=" + this.s + ", v=" + this.v + '}';
        }
    }

    public static class KeyPair {
        private final SecretKey secretKey;
        private final PublicKey publicKey;

        public static KeyPair create(SecretKey secretKey, PublicKey publicKey) {
            return new KeyPair(secretKey, publicKey);
        }

        public static KeyPair fromSecretKey(SecretKey secretKey) {
            return new KeyPair(secretKey, PublicKey.fromSecretKey(secretKey));
        }

        public static KeyPair random() {
            java.security.KeyPair rawKeyPair = Parameters.KEY_PAIR_GENERATOR.generateKeyPair();
            BCECPrivateKey privateKey = (BCECPrivateKey)rawKeyPair.getPrivate();
            BCECPublicKey publicKey = (BCECPublicKey)rawKeyPair.getPublic();
            BigInteger privateKeyValue = privateKey.getD();
            byte[] publicKeyBytes = publicKey.getQ().getEncoded(false);
            BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length));
            return new KeyPair(SecretKey.fromInteger(privateKeyValue), PublicKey.fromInteger(publicKeyValue));
        }

        public static KeyPair load(Path file) throws IOException, InvalidSEC256K1SecretKeyStoreException {
            return KeyPair.fromSecretKey(SecretKey.load(file));
        }

        private KeyPair(SecretKey secretKey, PublicKey publicKey) {
            Preconditions.checkNotNull((Object)secretKey);
            Preconditions.checkNotNull((Object)publicKey);
            this.secretKey = secretKey;
            this.publicKey = publicKey;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.secretKey, this.publicKey});
        }

        public boolean equals(Object other) {
            if (!(other instanceof KeyPair)) {
                return false;
            }
            KeyPair that = (KeyPair)other;
            return this.secretKey.equals(that.secretKey) && this.publicKey.equals(that.publicKey);
        }

        public SecretKey secretKey() {
            return this.secretKey;
        }

        public PublicKey publicKey() {
            return this.publicKey;
        }

        public void store(Path file) throws IOException {
            this.secretKey.store(file);
        }
    }

    public static class PublicKey {
        private static final int BYTE_LENGTH = 64;
        private final Bytes keyBytes;

        public static PublicKey fromSecretKey(SecretKey secretKey) {
            BigInteger privKey = secretKey.bytes().toUnsignedBigInteger();
            if (privKey.bitLength() > Parameters.CURVE_ORDER.bitLength()) {
                privKey = privKey.mod(Parameters.CURVE_ORDER);
            }
            ECPoint point = new FixedPointCombMultiplier().multiply(Parameters.CURVE.getG(), privKey);
            return PublicKey.fromBytes(Bytes.wrap((byte[])Arrays.copyOfRange(point.getEncoded(false), 1, 65)));
        }

        private static Bytes toBytes64(byte[] backing) {
            if (backing.length == 64) {
                return Bytes.wrap((byte[])backing);
            }
            if (backing.length > 64) {
                return Bytes.wrap((byte[])backing, (int)(backing.length - 64), (int)64);
            }
            MutableBytes res = MutableBytes.create((int)64);
            Bytes.wrap((byte[])backing).copyTo(res, 64 - backing.length);
            return res;
        }

        public static PublicKey fromInteger(BigInteger privateKey) {
            Preconditions.checkNotNull((Object)privateKey);
            return PublicKey.fromBytes(PublicKey.toBytes64(privateKey.toByteArray()));
        }

        public static PublicKey fromBytes(Bytes bytes) {
            return new PublicKey(bytes);
        }

        @Nullable
        public static PublicKey recoverFromSignature(byte[] data, Signature signature) {
            return PublicKey.recoverFromHashAndSignature(Hash.keccak256(data), signature);
        }

        @Nullable
        public static PublicKey recoverFromSignature(Bytes data, Signature signature) {
            return PublicKey.recoverFromHashAndSignature(Hash.keccak256(data), signature);
        }

        @Nullable
        public static PublicKey recoverFromHashAndSignature(byte[] hash, Signature signature) {
            return PublicKey.recoverFromHashAndSignature(Bytes32.wrap((byte[])hash), signature);
        }

        @Nullable
        public static PublicKey recoverFromHashAndSignature(Bytes32 hash, Signature signature) {
            BigInteger publicKeyBI = SECP256K1.recoverFromSignature(signature.v(), signature.r(), signature.s(), hash);
            return publicKeyBI != null ? PublicKey.fromInteger(publicKeyBI) : null;
        }

        private PublicKey(Bytes bytes) {
            Preconditions.checkNotNull((Object)bytes);
            Preconditions.checkArgument((bytes.size() == 64 ? 1 : 0) != 0, (String)"Key must be %s bytes long, got %s", (int)64, (int)bytes.size());
            this.keyBytes = bytes;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PublicKey)) {
                return false;
            }
            PublicKey that = (PublicKey)other;
            return this.keyBytes.equals(that.keyBytes);
        }

        public int hashCode() {
            return this.keyBytes.hashCode();
        }

        public Bytes bytes() {
            return this.keyBytes;
        }

        public byte[] bytesArray() {
            return this.keyBytes.toArrayUnsafe();
        }

        public String toString() {
            return this.keyBytes.toString();
        }
    }

    public static class SecretKey
    implements Destroyable {
        private Bytes32 keyBytes;

        protected void finalize() {
            this.destroy();
        }

        @Override
        public void destroy() {
            if (this.keyBytes != null) {
                byte[] b = this.keyBytes.toArrayUnsafe();
                this.keyBytes = null;
                Arrays.fill(b, (byte)0);
            }
        }

        public static SecretKey fromInteger(BigInteger key) {
            Preconditions.checkNotNull((Object)key);
            byte[] bytes = key.toByteArray();
            int offset = 0;
            while (bytes[offset] == 0) {
                ++offset;
            }
            if (bytes.length - offset > 32) {
                throw new IllegalArgumentException("key integer is too large");
            }
            return SecretKey.fromBytes(Bytes32.leftPad((Bytes)Bytes.wrap((byte[])bytes, (int)offset, (int)(bytes.length - offset))));
        }

        public static SecretKey fromBytes(Bytes32 bytes) {
            return new SecretKey(bytes.copy());
        }

        public static SecretKey load(Path file) throws IOException, InvalidSEC256K1SecretKeyStoreException {
            ByteBuffer byteBuffer = ByteBuffer.allocate(65);
            CharBuffer charBuffer = CharBuffer.allocate(64);
            try {
                FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);
                while (byteBuffer.hasRemaining() && channel.read(byteBuffer) > 0) {
                }
                channel.close();
                if (byteBuffer.remaining() > 1) {
                    throw new InvalidSEC256K1SecretKeyStoreException();
                }
                byteBuffer.flip();
                for (int i = 0; i < 64; ++i) {
                    charBuffer.put((char)byteBuffer.get());
                }
                if (byteBuffer.limit() == 65 && byteBuffer.get(64) != 10 && byteBuffer.get(64) != 13) {
                    throw new InvalidSEC256K1SecretKeyStoreException();
                }
                charBuffer.flip();
                SecretKey secretKey = SecretKey.fromBytes(Bytes32.fromHexString((CharSequence)charBuffer));
                return secretKey;
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidSEC256K1SecretKeyStoreException();
            }
            finally {
                Arrays.fill(byteBuffer.array(), (byte)0);
                Arrays.fill(charBuffer.array(), '\u0000');
            }
        }

        private SecretKey(Bytes32 bytes) {
            Preconditions.checkNotNull((Object)bytes);
            this.keyBytes = bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store(Path file) throws IOException {
            Preconditions.checkState((this.keyBytes != null ? 1 : 0) != 0, (Object)"SecretKey has been destroyed");
            byte[] bytes = new byte[64];
            CharBuffer hexChars = (CharBuffer)this.keyBytes.appendHexTo((Appendable)CharBuffer.allocate(64));
            try {
                hexChars.flip();
                for (int i = 0; i < 64; ++i) {
                    bytes[i] = (byte)hexChars.get();
                }
                Files.atomicReplace((Path)file, (byte[])bytes);
            }
            finally {
                Arrays.fill(bytes, (byte)0);
                Arrays.fill(hexChars.array(), '\u0000');
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SecretKey)) {
                return false;
            }
            Preconditions.checkState((this.keyBytes != null ? 1 : 0) != 0, (Object)"SecretKey has been destroyed");
            SecretKey other = (SecretKey)obj;
            return this.keyBytes.equals(other.keyBytes);
        }

        public int hashCode() {
            Preconditions.checkState((this.keyBytes != null ? 1 : 0) != 0, (Object)"SecretKey has been destroyed");
            return this.keyBytes.hashCode();
        }

        public Bytes32 bytes() {
            Preconditions.checkState((this.keyBytes != null ? 1 : 0) != 0, (Object)"SecretKey has been destroyed");
            return this.keyBytes;
        }

        public byte[] bytesArray() {
            Preconditions.checkState((this.keyBytes != null ? 1 : 0) != 0, (Object)"SecretKey has been destroyed");
            return this.keyBytes.toArrayUnsafe();
        }
    }

    static final class Parameters {
        static final ECDomainParameters CURVE;
        static final BigInteger CURVE_ORDER;
        static final BigInteger HALF_CURVE_ORDER;
        static final KeyPairGenerator KEY_PAIR_GENERATOR;
        static final X9IntegerConverter X_9_INTEGER_CONVERTER;

        Parameters() {
        }

        static {
            try {
                Class.forName("org.bouncycastle.asn1.sec.SECNamedCurves");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("BouncyCastle is not available on the classpath, see https://www.bouncycastle.org/latest_releases.html");
            }
            X9ECParameters params = SECNamedCurves.getByName((String)SECP256K1.CURVE_NAME);
            CURVE = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
            CURVE_ORDER = CURVE.getN();
            HALF_CURVE_ORDER = CURVE_ORDER.shiftRight(1);
            if (CURVE_ORDER.compareTo(SecP256K1Curve.q) >= 0) {
                throw new IllegalStateException("secp256k1.n should be smaller than secp256k1.q, but is not");
            }
            try {
                KEY_PAIR_GENERATOR = KeyPairGenerator.getInstance(SECP256K1.ALGORITHM, SECP256K1.PROVIDER);
            }
            catch (NoSuchProviderException e) {
                throw new IllegalStateException("BouncyCastleProvider is not available, see https://www.bouncycastle.org/wiki/display/JA1/Provider+Installation", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Algorithm should be available but was not", e);
            }
            ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(SECP256K1.CURVE_NAME);
            try {
                KEY_PAIR_GENERATOR.initialize(ecGenParameterSpec, new SecureRandom());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new IllegalStateException("Algorithm parameter should be available but was not", e);
            }
            X_9_INTEGER_CONVERTER = new X9IntegerConverter();
        }
    }
}

