/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.crypto.sodium;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.crypto.sodium.Sodium;
import net.consensys.cava.crypto.sodium.SodiumException;

public final class Auth {
    private Auth() {
    }

    public static Bytes auth(Bytes input, Key key) {
        return Bytes.wrap((byte[])Auth.auth(input.toArrayUnsafe(), key));
    }

    public static byte[] auth(byte[] input, Key key) {
        Preconditions.checkArgument((key.ptr != null ? 1 : 0) != 0, (Object)"Key has been destroyed");
        long abytes = Sodium.crypto_auth_bytes();
        if (abytes > Integer.MAX_VALUE) {
            throw new IllegalStateException("crypto_auth_bytes: " + abytes + " is too large");
        }
        byte[] tag = new byte[(int)abytes];
        int rc = Sodium.crypto_auth(tag, input, input.length, key.ptr);
        if (rc != 0) {
            throw new SodiumException("crypto_auth_bytes: failed with result " + rc);
        }
        return tag;
    }

    public static boolean verify(Bytes tag, Bytes input, Key key) {
        return Auth.verify(tag.toArrayUnsafe(), input.toArrayUnsafe(), key);
    }

    public static boolean verify(byte[] tag, byte[] input, Key key) {
        Preconditions.checkArgument((key.ptr != null ? 1 : 0) != 0, (Object)"Key has been destroyed");
        long abytes = Sodium.crypto_auth_bytes();
        if ((long)tag.length != abytes) {
            throw new IllegalArgumentException("tag must be " + abytes + " bytes, got " + tag.length);
        }
        int rc = Sodium.crypto_auth_verify(tag, input, input.length, key.ptr);
        return rc == 0;
    }

    public static final class Key
    implements Destroyable {
        @Nullable
        private Pointer ptr;
        private final int length;

        private Key(Pointer ptr, int length) {
            this.ptr = ptr;
            this.length = length;
        }

        protected void finalize() {
            this.destroy();
        }

        @Override
        public void destroy() {
            if (this.ptr != null) {
                Pointer p = this.ptr;
                this.ptr = null;
                Sodium.sodium_free(p);
            }
        }

        @Override
        public boolean isDestroyed() {
            return this.ptr == null;
        }

        public static Key fromBytes(Bytes bytes) {
            return Key.fromBytes(bytes.toArrayUnsafe());
        }

        public static Key fromBytes(byte[] bytes) {
            if ((long)bytes.length != Sodium.crypto_auth_keybytes()) {
                throw new IllegalArgumentException("key must be " + Sodium.crypto_auth_keybytes() + " bytes, got " + bytes.length);
            }
            return Sodium.dup(bytes, Key::new);
        }

        public static int length() {
            long keybytes = Sodium.crypto_auth_keybytes();
            if (keybytes > Integer.MAX_VALUE) {
                throw new SodiumException("crypto_auth_keybytes: " + keybytes + " is too large");
            }
            return (int)keybytes;
        }

        public static Key random() {
            int length = Key.length();
            Pointer ptr = Sodium.malloc(length);
            try {
                Sodium.randombytes_buf(ptr, length);
                return new Key(ptr, length);
            }
            catch (Throwable e) {
                Sodium.sodium_free(ptr);
                throw e;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Preconditions.checkState((this.ptr != null ? 1 : 0) != 0, (Object)"Key has been destroyed");
            Key other = (Key)obj;
            return other.ptr != null && Sodium.sodium_memcmp(this.ptr, other.ptr, this.length) == 0;
        }

        public int hashCode() {
            Preconditions.checkState((this.ptr != null ? 1 : 0) != 0, (Object)"Key has been destroyed");
            return Sodium.hashCode(this.ptr, this.length);
        }

        public Bytes bytes() {
            return Bytes.wrap((byte[])this.bytesArray());
        }

        public byte[] bytesArray() {
            Preconditions.checkState((this.ptr != null ? 1 : 0) != 0, (Object)"Key has been destroyed");
            return Sodium.reify(this.ptr, this.length);
        }
    }
}

