/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.eth;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.consensys.cava.bytes.Bytes;

public final class Address {
    private static final int SIZE = 20;
    private final Bytes delegate;

    public static Address fromBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        Preconditions.checkArgument((bytes.size() == 20 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)20, (int)bytes.size());
        return new Address(bytes);
    }

    public static Address fromHexString(String str) {
        return Address.fromBytes(Bytes.fromHexString((CharSequence)str));
    }

    private Address(Bytes value) {
        this.delegate = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return this.delegate.equals(other.delegate);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.delegate});
    }

    public String toString() {
        return "Address{" + this.delegate.toHexString() + '}';
    }

    public String toHexString() {
        return this.delegate.toHexString();
    }

    public Bytes toBytes() {
        return this.delegate;
    }
}

