/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.eth;

import java.util.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.eth.BlockBody;
import net.consensys.cava.eth.BlockHeader;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;

public final class Block {
    private final BlockHeader header;
    private final BlockBody body;

    public static Block fromBytes(Bytes encoded) {
        return (Block)RLP.decodeList((Bytes)encoded, Block::readFrom);
    }

    public static Block fromHexString(String str) {
        return (Block)RLP.decodeList((Bytes)Bytes.fromHexString((CharSequence)str), Block::readFrom);
    }

    public static Block readFrom(RLPReader reader) {
        BlockHeader header = (BlockHeader)reader.readList(BlockHeader::readFrom);
        BlockBody body = BlockBody.readFrom(reader);
        return new Block(header, body);
    }

    public Block(BlockHeader header, BlockBody body) {
        Objects.requireNonNull(header);
        Objects.requireNonNull(body);
        this.header = header;
        this.body = body;
    }

    public BlockBody body() {
        return this.body;
    }

    public BlockHeader header() {
        return this.header;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return com.google.common.base.Objects.equal((Object)this.header, (Object)other.header) && com.google.common.base.Objects.equal((Object)this.body, (Object)other.body);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.header, this.body});
    }

    public String toString() {
        return "Block{header=" + this.header + ", body=" + this.body + '}';
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::writeTo);
    }

    public void writeTo(RLPWriter writer) {
        writer.writeList(this.header::writeTo);
        this.body.writeTo(writer);
    }
}

