/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.eth;

import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.eth.Address;
import net.consensys.cava.eth.Hash;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;
import net.consensys.cava.units.bigints.UInt256;
import net.consensys.cava.units.ethereum.Gas;

public final class BlockHeader {
    @Nullable
    private final Hash parentHash;
    private final Hash ommersHash;
    private final Address coinbase;
    private final Hash stateRoot;
    private final Hash transactionsRoot;
    private final Hash receiptsRoot;
    private final Bytes logsBloom;
    private final UInt256 difficulty;
    private final UInt256 number;
    private final Gas gasLimit;
    private final Gas gasUsed;
    private final Instant timestamp;
    private final Bytes extraData;
    private final Hash mixHash;
    private final Bytes nonce;
    private Hash hash;

    public static BlockHeader fromBytes(Bytes encoded) {
        Objects.requireNonNull(encoded);
        return (BlockHeader)RLP.decodeList((Bytes)encoded, BlockHeader::readFrom);
    }

    static BlockHeader readFrom(RLPReader reader) {
        Bytes parentHashBytes = reader.readValue();
        return new BlockHeader(parentHashBytes.isEmpty() ? null : Hash.fromBytes(parentHashBytes), Hash.fromBytes(reader.readValue()), Address.fromBytes(reader.readValue()), Hash.fromBytes(reader.readValue()), Hash.fromBytes(reader.readValue()), Hash.fromBytes(reader.readValue()), reader.readValue(), UInt256.fromBytes((Bytes)reader.readValue()), UInt256.fromBytes((Bytes)reader.readValue()), Gas.valueOf((UInt256)reader.readUInt256()), Gas.valueOf((UInt256)reader.readUInt256()), Instant.ofEpochSecond(reader.readLong()), reader.readValue(), Hash.fromBytes(reader.readValue()), reader.readValue());
    }

    public BlockHeader(@Nullable Hash parentHash, Hash ommersHash, Address coinbase, Hash stateRoot, Hash transactionsRoot, Hash receiptsRoot, Bytes logsBloom, UInt256 difficulty, UInt256 number, Gas gasLimit, Gas gasUsed, Instant timestamp, Bytes extraData, Hash mixHash, Bytes nonce) {
        Objects.requireNonNull(ommersHash);
        Objects.requireNonNull(coinbase);
        Objects.requireNonNull(stateRoot);
        Objects.requireNonNull(transactionsRoot);
        Objects.requireNonNull(receiptsRoot);
        Objects.requireNonNull(logsBloom);
        Objects.requireNonNull(difficulty);
        Objects.requireNonNull(number);
        Objects.requireNonNull(gasLimit);
        Objects.requireNonNull(gasUsed);
        Objects.requireNonNull(timestamp);
        Objects.requireNonNull(extraData);
        Objects.requireNonNull(mixHash);
        Objects.requireNonNull(nonce);
        this.parentHash = parentHash;
        this.ommersHash = ommersHash;
        this.coinbase = coinbase;
        this.stateRoot = stateRoot;
        this.transactionsRoot = transactionsRoot;
        this.receiptsRoot = receiptsRoot;
        this.logsBloom = logsBloom;
        this.difficulty = difficulty;
        this.number = number;
        this.gasLimit = gasLimit;
        this.gasUsed = gasUsed;
        this.timestamp = timestamp;
        this.extraData = extraData;
        this.mixHash = mixHash;
        this.nonce = nonce;
    }

    public Address coinbase() {
        return this.coinbase;
    }

    public UInt256 difficulty() {
        return this.difficulty;
    }

    public Bytes extraData() {
        return this.extraData;
    }

    public Gas gasLimit() {
        return this.gasLimit;
    }

    public Gas gasUsed() {
        return this.gasUsed;
    }

    public Hash hash() {
        if (this.hash == null) {
            Bytes rlp = this.toBytes();
            this.hash = Hash.hash(rlp);
        }
        return this.hash;
    }

    public Bytes logsBloom() {
        return this.logsBloom;
    }

    public Hash mixHash() {
        return this.mixHash;
    }

    public Bytes nonce() {
        return this.nonce;
    }

    public UInt256 number() {
        return this.number;
    }

    public Hash ommersHash() {
        return this.ommersHash;
    }

    @Nullable
    public Hash parentHash() {
        return this.parentHash;
    }

    public Hash receiptsRoot() {
        return this.receiptsRoot;
    }

    public Hash stateRoot() {
        return this.stateRoot;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Hash transactionsRoot() {
        return this.transactionsRoot;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockHeader)) {
            return false;
        }
        BlockHeader other = (BlockHeader)obj;
        return com.google.common.base.Objects.equal((Object)this.parentHash, (Object)other.parentHash) && this.ommersHash.equals(other.ommersHash) && this.coinbase.equals(other.coinbase) && this.stateRoot.equals(other.stateRoot) && this.transactionsRoot.equals(other.transactionsRoot) && this.receiptsRoot.equals(other.receiptsRoot) && this.logsBloom.equals(other.logsBloom) && this.difficulty.equals((Object)other.difficulty) && this.number.equals((Object)other.number) && this.gasLimit.equals((Object)other.gasLimit) && this.gasUsed.equals((Object)other.gasUsed) && this.timestamp.equals(other.timestamp) && this.extraData.equals(other.extraData) && this.mixHash.equals(other.mixHash) && this.nonce.equals(other.nonce);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.parentHash, this.ommersHash, this.coinbase, this.stateRoot, this.transactionsRoot, this.receiptsRoot, this.logsBloom, this.difficulty, this.number, this.gasLimit, this.gasUsed, this.timestamp, this.extraData, this.mixHash, this.nonce});
    }

    public String toString() {
        return "BlockHeader{parentHash=" + this.parentHash + ", ommersHash=" + this.ommersHash + ", coinbase=" + this.coinbase + ", stateRoot=" + this.stateRoot + ", transactionsRoot=" + this.transactionsRoot + ", receiptsRoot=" + this.receiptsRoot + ", logsBloom=" + this.logsBloom + ", difficulty=" + this.difficulty + ", number=" + this.number + ", gasLimit=" + this.gasLimit + ", gasUsed=" + this.gasUsed + ", timestamp=" + this.timestamp + ", extraData=" + this.extraData + ", mixHash=" + this.mixHash + ", nonce=" + this.nonce + '}';
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::writeTo);
    }

    void writeTo(RLPWriter writer) {
        writer.writeValue(this.parentHash != null ? this.parentHash.toBytes() : Bytes.EMPTY);
        writer.writeValue(this.ommersHash.toBytes());
        writer.writeValue(this.coinbase.toBytes());
        writer.writeValue(this.stateRoot.toBytes());
        writer.writeValue(this.transactionsRoot.toBytes());
        writer.writeValue(this.receiptsRoot.toBytes());
        writer.writeValue(this.logsBloom);
        writer.writeValue(this.difficulty.toMinimalBytes());
        writer.writeValue(this.number.toMinimalBytes());
        writer.writeValue(this.gasLimit.toMinimalBytes());
        writer.writeValue(this.gasUsed.toMinimalBytes());
        writer.writeLong(this.timestamp.getEpochSecond());
        writer.writeValue(this.extraData);
        writer.writeValue(this.mixHash.toBytes());
        writer.writeValue(this.nonce);
    }
}

