/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.eth;

import com.google.common.base.Preconditions;
import java.util.Objects;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.bytes.Bytes32;

public final class Hash {
    private static final int SIZE = 32;
    private final Bytes32 delegate;

    public static Hash fromBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        Preconditions.checkArgument((bytes.size() == 32 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)32, (int)bytes.size());
        return new Hash(Bytes32.wrap((Bytes)bytes));
    }

    public static Hash fromBytes(Bytes32 bytes) {
        return new Hash(bytes);
    }

    public static Hash fromHexString(String str) {
        return new Hash(Bytes32.fromHexStringLenient((CharSequence)str));
    }

    public static Hash hash(Bytes value) {
        return new Hash(net.consensys.cava.crypto.Hash.keccak256((Bytes)value));
    }

    private Hash(Bytes32 value) {
        Objects.requireNonNull(value);
        this.delegate = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Hash)) {
            return false;
        }
        Hash hash = (Hash)obj;
        return this.delegate.equals(hash.delegate);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.delegate});
    }

    public String toString() {
        return "Hash{" + this.delegate.toHexString() + '}';
    }

    public String toHexString() {
        return this.delegate.toHexString();
    }

    public Bytes toBytes() {
        return this.delegate;
    }
}

