/*
 * Decompiled with CFR 0.152.
 */
package net.consensys.cava.eth;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nullable;
import net.consensys.cava.bytes.Bytes;
import net.consensys.cava.crypto.SECP256K1;
import net.consensys.cava.eth.Address;
import net.consensys.cava.eth.Hash;
import net.consensys.cava.rlp.RLP;
import net.consensys.cava.rlp.RLPException;
import net.consensys.cava.rlp.RLPReader;
import net.consensys.cava.rlp.RLPWriter;
import net.consensys.cava.units.bigints.UInt256;
import net.consensys.cava.units.ethereum.Gas;
import net.consensys.cava.units.ethereum.Wei;

public final class Transaction {
    private static final int V_BASE = 27;
    private final UInt256 nonce;
    private final Wei gasPrice;
    private final Gas gasLimit;
    @Nullable
    private final Address to;
    private final Wei value;
    private final SECP256K1.Signature signature;
    private final Bytes payload;
    private volatile Hash hash;
    private volatile Address sender;
    private volatile Boolean validSignature;

    public static Transaction fromBytes(Bytes encoded) {
        return Transaction.fromBytes(encoded, false);
    }

    public static Transaction fromBytes(Bytes encoded, boolean lenient) {
        Objects.requireNonNull(encoded);
        return (Transaction)RLP.decode((Bytes)encoded, (boolean)lenient, reader -> {
            Transaction tx = (Transaction)reader.readList(Transaction::readFrom);
            if (!reader.isComplete()) {
                throw new RLPException("Additional bytes present at the end of the encoded transaction");
            }
            return tx;
        });
    }

    public static Transaction readFrom(RLPReader reader) {
        SECP256K1.Signature signature;
        Address address;
        UInt256 nonce = reader.readUInt256();
        Wei gasPrice = Wei.valueOf((UInt256)reader.readUInt256());
        Gas gasLimit = Gas.valueOf((long)reader.readLong());
        Bytes addressBytes = reader.readValue();
        try {
            address = addressBytes.isEmpty() ? null : Address.fromBytes(addressBytes);
        }
        catch (IllegalArgumentException e) {
            throw new RLPException("Value is the wrong size to be an address", (Throwable)e);
        }
        Wei value = Wei.valueOf((UInt256)reader.readUInt256());
        Bytes payload = reader.readValue();
        byte encodedV = reader.readByte();
        Bytes rbytes = reader.readValue();
        if (rbytes.size() > 32) {
            throw new RLPException("r-value of the signature is " + rbytes.size() + ", it should be at most 32 bytes");
        }
        BigInteger r = rbytes.toUnsignedBigInteger();
        Bytes sbytes = reader.readValue();
        if (sbytes.size() > 32) {
            throw new RLPException("s-value of the signature is " + sbytes.size() + ", it should be at most 32 bytes");
        }
        BigInteger s = sbytes.toUnsignedBigInteger();
        if (!reader.isComplete()) {
            throw new RLPException("Additional bytes present at the end of the encoding");
        }
        byte v = (byte)(encodedV - 27);
        try {
            signature = SECP256K1.Signature.create((byte)v, (BigInteger)r, (BigInteger)s);
        }
        catch (IllegalArgumentException e) {
            throw new RLPException("Invalid signature: " + e.getMessage());
        }
        try {
            return new Transaction(nonce, gasPrice, gasLimit, address, value, payload, signature);
        }
        catch (IllegalArgumentException e) {
            throw new RLPException(e.getMessage(), (Throwable)e);
        }
    }

    public Transaction(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, SECP256K1.KeyPair keyPair) {
        this(nonce, gasPrice, gasLimit, to, value, payload, Transaction.generateSignature(nonce, gasPrice, gasLimit, to, value, payload, keyPair));
    }

    public Transaction(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, SECP256K1.Signature signature) {
        Objects.requireNonNull(nonce);
        Preconditions.checkArgument((nonce.compareTo(UInt256.ZERO) >= 0 ? 1 : 0) != 0, (Object)"nonce must be >= 0");
        Objects.requireNonNull(gasPrice);
        Objects.requireNonNull(value);
        Objects.requireNonNull(signature);
        Objects.requireNonNull(payload);
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.signature = signature;
        this.payload = payload;
    }

    public UInt256 nonce() {
        return this.nonce;
    }

    public Wei gasPrice() {
        return this.gasPrice;
    }

    public Gas gasLimit() {
        return this.gasLimit;
    }

    @Nullable
    public Address to() {
        return this.to;
    }

    public boolean isContractCreation() {
        return this.to == null;
    }

    public Wei value() {
        return this.value;
    }

    public SECP256K1.Signature signature() {
        return this.signature;
    }

    public Bytes payload() {
        return this.payload;
    }

    public Hash hash() {
        if (this.hash != null) {
            return this.hash;
        }
        Bytes rlp = this.toBytes();
        this.hash = Hash.hash(rlp);
        return this.hash;
    }

    @Nullable
    public Address sender() {
        if (this.validSignature != null) {
            return this.sender;
        }
        return this.verifySignatureAndGetSender();
    }

    @Nullable
    private Address verifySignatureAndGetSender() {
        Bytes data = Transaction.signatureData(this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.payload);
        SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.recoverFromSignature((Bytes)data, (SECP256K1.Signature)this.signature);
        if (publicKey == null) {
            this.validSignature = false;
        } else {
            this.sender = Address.fromBytes(Bytes.wrap((byte[])net.consensys.cava.crypto.Hash.keccak256((byte[])publicKey.bytesArray()), (int)12, (int)20));
            this.validSignature = true;
        }
        return this.sender;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        Transaction that = (Transaction)obj;
        return this.nonce.equals((Object)that.nonce) && this.gasPrice.equals((Object)that.gasPrice) && this.gasLimit.equals((Object)that.gasLimit) && com.google.common.base.Objects.equal((Object)this.to, (Object)that.to) && this.value.equals((Object)that.value) && this.signature.equals((Object)that.signature) && this.payload.equals(that.payload);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.signature, this.payload});
    }

    public String toString() {
        return String.format("Transaction{nonce=%s, gasPrice=%s, gasLimit=%s, to=%s, value=%s, signature=%s, payload=%s", this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.signature, this.payload);
    }

    public Bytes toBytes() {
        return RLP.encodeList(this::writeTo);
    }

    public void writeTo(RLPWriter writer) {
        writer.writeUInt256(this.nonce);
        writer.writeUInt256(this.gasPrice.toUInt256());
        writer.writeLong(this.gasLimit.toLong());
        writer.writeValue(this.to != null ? this.to.toBytes() : Bytes.EMPTY);
        writer.writeUInt256(this.value.toUInt256());
        writer.writeValue(this.payload);
        writer.writeByte((byte)(this.signature.v() + 27));
        writer.writeBigInteger(this.signature.r());
        writer.writeBigInteger(this.signature.s());
    }

    private static SECP256K1.Signature generateSignature(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload, SECP256K1.KeyPair keyPair) {
        return SECP256K1.sign((Bytes)Transaction.signatureData(nonce, gasPrice, gasLimit, to, value, payload), (SECP256K1.KeyPair)keyPair);
    }

    private static Bytes signatureData(UInt256 nonce, Wei gasPrice, Gas gasLimit, @Nullable Address to, Wei value, Bytes payload) {
        return RLP.encodeList(writer -> {
            writer.writeUInt256(nonce);
            writer.writeValue(gasPrice.toMinimalBytes());
            writer.writeValue(gasLimit.toMinimalBytes());
            writer.writeValue(to != null ? to.toBytes() : Bytes.EMPTY);
            writer.writeValue(value.toMinimalBytes());
            writer.writeValue(payload);
        });
    }
}

