/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.View;
import android.view.Window;
import androidx.annotation.Keep;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.consentmanager.cm_sdk_android_v3.ConsentLayerUIConfig;
import net.consentmanager.cm_sdk_android_v3.DefaultDialogFactory;
import net.consentmanager.cm_sdk_android_v3.DialogFactory;
import net.consentmanager.cm_sdk_android_v3.WebViewContainer;
import net.consentmanager.cm_sdk_android_v3.WebViewManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0010J\f\u0010\u0017\u001a\u00020\u0010*\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerDialog;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "activity", "Landroid/app/Activity;", "config", "Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerUIConfig;", "webViewContainer", "Lnet/consentmanager/cm_sdk_android_v3/WebViewContainer;", "webViewManager", "Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;", "dialogFactory", "Lnet/consentmanager/cm_sdk_android_v3/DialogFactory;", "(Landroid/app/Activity;Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerUIConfig;Lnet/consentmanager/cm_sdk_android_v3/WebViewContainer;Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;Lnet/consentmanager/cm_sdk_android_v3/DialogFactory;)V", "dialog", "Landroid/app/Dialog;", "dismiss", "", "isShowing", "", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "show", "applyBackgroundStyle", "Landroid/view/Window;", "cm-sdk-android-v3_release"})
@Keep
public final class ConsentLayerDialog
implements DefaultLifecycleObserver {
    @NotNull
    private final Activity activity;
    @NotNull
    private final ConsentLayerUIConfig config;
    @NotNull
    private final WebViewContainer webViewContainer;
    @NotNull
    private final WebViewManager webViewManager;
    @NotNull
    private final DialogFactory dialogFactory;
    @Nullable
    private Dialog dialog;

    public ConsentLayerDialog(@NotNull Activity activity, @NotNull ConsentLayerUIConfig config, @NotNull WebViewContainer webViewContainer, @NotNull WebViewManager webViewManager, @NotNull DialogFactory dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)webViewContainer, (String)"webViewContainer");
        Intrinsics.checkNotNullParameter((Object)webViewManager, (String)"webViewManager");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        this.activity = activity;
        this.config = config;
        this.webViewContainer = webViewContainer;
        this.webViewManager = webViewManager;
        this.dialogFactory = dialogFactory;
    }

    public /* synthetic */ ConsentLayerDialog(Activity activity, ConsentLayerUIConfig consentLayerUIConfig, WebViewContainer webViewContainer, WebViewManager webViewManager, DialogFactory dialogFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            dialogFactory = new DefaultDialogFactory();
        }
        this(activity, consentLayerUIConfig, webViewContainer, webViewManager, dialogFactory);
    }

    /*
     * WARNING - void declaration
     */
    public final void show() {
        void $this$show_u24lambda_u242;
        Dialog dialog;
        this.dismiss();
        Dialog dialog2 = dialog = this.dialogFactory.createDialog(this.activity);
        ConsentLayerDialog consentLayerDialog = this;
        boolean bl = false;
        Context context = $this$show_u24lambda_u242.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        $this$show_u24lambda_u242.setContentView((View)this.webViewContainer.createContainer(context));
        $this$show_u24lambda_u242.setCancelable(this.config.isCancelable());
        Window window = $this$show_u24lambda_u242.getWindow();
        if (window != null) {
            Window window2;
            Window $this$show_u24lambda_u242_u24lambda_u240 = window2 = window;
            boolean bl2 = false;
            $this$show_u24lambda_u242_u24lambda_u240.setLayout(-1, -1);
            $this$show_u24lambda_u242_u24lambda_u240.setBackgroundDrawableResource(17170445);
            Intrinsics.checkNotNull((Object)$this$show_u24lambda_u242_u24lambda_u240);
            this.applyBackgroundStyle($this$show_u24lambda_u242_u24lambda_u240);
        }
        $this$show_u24lambda_u242.setOnDismissListener(ConsentLayerDialog::show$lambda$2$lambda$1);
        $this$show_u24lambda_u242.show();
        Log.d((String)"CMPConsentLayerDialog", (String)"Dialog shown");
        consentLayerDialog.dialog = dialog;
        if (this.activity instanceof LifecycleOwner) {
            ((LifecycleOwner)this.activity).getLifecycle().addObserver((LifecycleObserver)this);
        }
    }

    private final void applyBackgroundStyle(Window $this$applyBackgroundStyle) {
        ConsentLayerUIConfig.BackgroundStyle backgroundStyle = this.config.getBackgroundStyle();
        if (backgroundStyle instanceof ConsentLayerUIConfig.BackgroundStyle.Dimmed) {
            $this$applyBackgroundStyle.setDimAmount(((ConsentLayerUIConfig.BackgroundStyle.Dimmed)this.config.getBackgroundStyle()).alpha);
        } else if (backgroundStyle instanceof ConsentLayerUIConfig.BackgroundStyle.Solid) {
            $this$applyBackgroundStyle.setBackgroundDrawable(null);
        } else if (backgroundStyle instanceof ConsentLayerUIConfig.BackgroundStyle.None) {
            $this$applyBackgroundStyle.setDimAmount(0.0f);
        }
    }

    public final void dismiss() {
        block1: {
            Log.d((String)"CMPConsentLayerDialog", (String)"dismiss() called");
            Dialog dialog = this.dialog;
            if (dialog != null) {
                dialog.dismiss();
            }
            this.dialog = null;
            Activity activity = this.activity;
            LifecycleOwner lifecycleOwner = activity instanceof LifecycleOwner ? (LifecycleOwner)activity : null;
            if (lifecycleOwner == null || (lifecycleOwner = lifecycleOwner.getLifecycle()) == null) break block1;
            lifecycleOwner.removeObserver((LifecycleObserver)this);
        }
    }

    public final boolean isShowing() {
        Dialog dialog = this.dialog;
        return dialog != null ? dialog.isShowing() : false;
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Log.d((String)"CMPConsentLayerDialog", (String)"onDestroy called");
        this.dismiss();
    }

    private static final void show$lambda$2$lambda$1(DialogInterface it) {
        Log.d((String)"CMPConsentLayerDialog", (String)"Dialog dismissed");
    }
}

