/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.java;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.webkit.WebView;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.consentmanager.cm_sdk_android_v3.CMPManager;
import net.consentmanager.cm_sdk_android_v3.CMPManagerDelegate;
import net.consentmanager.cm_sdk_android_v3.ConsentLayerUIConfig;
import net.consentmanager.cm_sdk_android_v3.JavaFriendlyResult;
import net.consentmanager.cm_sdk_android_v3.UrlConfig;

public class JavaCMPManager {
    private final CMPManager cmpManager;
    private WebView webView;

    private JavaCMPManager(CMPManager cmpManager) {
        this.cmpManager = cmpManager;
    }

    public static JavaCMPManager getInstance(Context context, UrlConfig urlConfig, ConsentLayerUIConfig webViewConfig, CMPManagerDelegate delegate) {
        CMPManager kotlinManager = CMPManager.Companion.getInstance(context, urlConfig, webViewConfig, delegate);
        return new JavaCMPManager(kotlinManager);
    }

    public void setWebView(WebView webView) {
        this.webView = webView;
        if (this.cmpManager != null) {
            this.cmpManager.setWebView(webView);
        }
    }

    public void setActivity(Activity activity) {
        this.cmpManager.setActivity(activity);
    }

    public boolean hasUserChoice() {
        return this.cmpManager.hasUserChoice();
    }

    public boolean hasPurposeConsent(String id) {
        return this.cmpManager.hasPurposeConsent(id);
    }

    public boolean hasVendorConsent(String id) {
        return this.cmpManager.hasVendorConsent(id);
    }

    public String exportCMPInfo() {
        return this.cmpManager.exportCMPInfo();
    }

    public List<String> getAllPurposesIDs() {
        return this.cmpManager.getAllPurposesIDs();
    }

    public List<String> getEnabledPurposesIDs() {
        return this.cmpManager.getEnabledPurposesIDs();
    }

    public List<String> getDisabledPurposesIDs() {
        return this.cmpManager.getDisabledPurposesIDs();
    }

    public List<String> getAllVendorsIDs() {
        return this.cmpManager.getAllVendorsIDs();
    }

    public List<String> getEnabledVendorsIDs() {
        return this.cmpManager.getEnabledVendorsIDs();
    }

    public List<String> getDisabledVendorsIDs() {
        return this.cmpManager.getDisabledVendorsIDs();
    }

    public void resetConsentManagementData() {
        this.cmpManager.resetConsentManagementData();
    }

    public void checkWithServerAndOpenIfNecessary(Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.checkWithServerAndOpenIfNecessary((Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void openConsentLayer(Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.openConsentLayer((Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void checkIfConsentIsRequired(Consumer<Boolean> completion) {
        this.cmpManager.checkIfConsentIsRequired((Function1<? super Boolean, Unit>)((Function1)isRequired -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.accept((Boolean)isRequired);
            }
            return Unit.INSTANCE;
        }));
    }

    public void acceptVendors(List<String> vendors, Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.acceptVendors(vendors, (Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void rejectVendors(List<String> vendors, Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.rejectVendors(vendors, (Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void acceptPurposes(List<String> purposes, boolean updatePurpose, Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.acceptPurposes(purposes, updatePurpose, (Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void rejectPurposes(List<String> purposes, boolean updateVendor, Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.rejectPurposes(purposes, updateVendor, (Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void rejectAll(Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.rejectAll((Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void acceptAll(Function<JavaFriendlyResult<Unit>, Void> completion) {
        this.cmpManager.acceptAll((Function1<? super Result<Unit>, Unit>)((Function1)result -> {
            if (Build.VERSION.SDK_INT >= 24) {
                completion.apply(new JavaFriendlyResult(result));
            }
            return Unit.INSTANCE;
        }));
    }

    public void onApplicationPause() {
        this.cmpManager.onApplicationPause();
    }

    public void onApplicationResume() {
        this.cmpManager.onApplicationResume();
    }

    public void onActivityDestroyed() {
        this.cmpManager.onActivityDestroyed();
    }
}

