package net.consentmanager.cm_sdk_android_v3

import android.app.Activity
import android.app.Dialog
import android.util.Log
import android.view.ViewGroup
import android.view.Window
import androidx.annotation.Keep
import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner

@Keep
class ConsentLayerDialog(
    private val activity: Activity,
    private val config: ConsentLayerUIConfig,
    private val webViewContainer: WebViewContainer,
    private val webViewManager: WebViewManager,
    private val dialogFactory: DialogFactory = DefaultDialogFactory()
) : DefaultLifecycleObserver {
    private var dialog: Dialog? = null

    fun show() {
        dismiss()

        dialog = dialogFactory.createDialog(activity).apply {
            setContentView(webViewContainer.createContainer(context))
            setCancelable(config.isCancelable)
            window?.apply {
                setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
                setBackgroundDrawableResource(android.R.color.transparent)
                applyBackgroundStyle()
            }
            setOnDismissListener {
                Log.d("CMPConsentLayerDialog", "Dialog dismissed")
//                webViewManager.destroyWebView()
            }
            show()
            Log.d("CMPConsentLayerDialog", "Dialog shown")

        }

        if (activity is LifecycleOwner) {
            activity.lifecycle.addObserver(this)
        }
    }

    private fun Window.applyBackgroundStyle() {
        when (config.backgroundStyle) {
            is ConsentLayerUIConfig.BackgroundStyle.Dimmed -> setDimAmount(config.backgroundStyle.alpha)
            is ConsentLayerUIConfig.BackgroundStyle.Solid -> setBackgroundDrawable(null)
            is ConsentLayerUIConfig.BackgroundStyle.None -> setDimAmount(0f)
        }
    }

    fun dismiss() {
        Log.d("CMPConsentLayerDialog", "dismiss() called")

        dialog?.dismiss()
        dialog = null

        (activity as? LifecycleOwner)?.lifecycle?.removeObserver(this)
    }

    fun isShowing(): Boolean = dialog?.isShowing == true

    override fun onDestroy(owner: LifecycleOwner) {
        Log.d("CMPConsentLayerDialog", "onDestroy called")

        dismiss()
    }
}
