package net.consentmanager.cm_sdk_android_v3

import android.content.Context
import android.view.ViewGroup
import android.webkit.WebView
import android.widget.FrameLayout
import androidx.annotation.Keep

@Keep
class WebViewContainer(private val webView: WebView) {
    fun createContainer(context: Context): FrameLayout {
        return FrameLayout(context).apply {
            addWebViewSafely(this)
        }
    }

    private fun addWebViewSafely(container: FrameLayout) {
        webView.parent?.let { parent ->
            if (parent is ViewGroup) {
                parent.removeView(webView)
            }
        }
        container.addView(webView, ViewGroup.LayoutParams(
            ViewGroup.LayoutParams.MATCH_PARENT,
            ViewGroup.LayoutParams.MATCH_PARENT
        ))
    }
}
