/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import androidx.annotation.Keep;
import androidx.annotation.RequiresApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.consentmanager.cm_sdk_android_v3.NetworkMonitor;
import net.consentmanager.cm_sdk_android_v3.NetworkMonitorDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u000e\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitor;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "delegate", "Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitorDelegate;", "getDelegate", "()Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitorDelegate;", "setDelegate", "(Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitorDelegate;)V", "networkCallback", "net/consentmanager/cm_sdk_android_v3/NetworkMonitor$networkCallback$1", "Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitor$networkCallback$1;", "isConnected", "", "startMonitoring", "", "stopMonitoring", "cm-sdk-android-v3_release"})
@Keep
public final class NetworkMonitor {
    @NotNull
    private final Context context;
    @Nullable
    private NetworkMonitorDelegate delegate;
    @NotNull
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final networkCallback.1 networkCallback;

    public NetworkMonitor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Object object = this.context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connectivityManager = (ConnectivityManager)object;
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkMonitor this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    NetworkMonitorDelegate networkMonitorDelegate = this.this$0.getDelegate();
                    if (networkMonitorDelegate == null) break block0;
                    networkMonitorDelegate.networkStatusDidChange(true);
                }
            }

            public void onLost(@NotNull Network network) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    NetworkMonitorDelegate networkMonitorDelegate = this.this$0.getDelegate();
                    if (networkMonitorDelegate == null) break block0;
                    networkMonitorDelegate.networkStatusDidChange(false);
                }
            }
        };
    }

    @Nullable
    public final NetworkMonitorDelegate getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(@Nullable NetworkMonitorDelegate networkMonitorDelegate) {
        this.delegate = networkMonitorDelegate;
    }

    public final void startMonitoring() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        this.connectivityManager.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    public final void stopMonitoring() {
        this.connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    @RequiresApi(value=23)
    public final boolean isConnected() {
        NetworkCapabilities capabilities;
        Network network = this.connectivityManager.getActiveNetwork();
        NetworkCapabilities networkCapabilities = capabilities = this.connectivityManager.getNetworkCapabilities(network);
        return networkCapabilities != null ? networkCapabilities.hasCapability(12) : false;
    }
}

