/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Keep;
import androidx.annotation.RequiresApi;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import net.consentmanager.cm_sdk_android_v3.CMPUserPreferencesService;
import net.consentmanager.cm_sdk_android_v3.NetworkMonitor;
import net.consentmanager.cm_sdk_android_v3.RetryManager;
import net.consentmanager.cm_sdk_android_v3.UseCase;
import net.consentmanager.cm_sdk_android_v3.WebViewManager;
import net.consentmanager.cm_sdk_android_v3.WebViewManagerDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001e\u001a\u00020\rJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0007J\b\u0010#\u001a\u00020$H\u0002J\u001e\u0010%\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+J\u0014\u0010,\u001a\u00020\r2\n\u0010-\u001a\u00060.j\u0002`/H\u0002J\b\u00100\u001a\u00020\rH\u0002J\u0006\u00101\u001a\u00020\fJ3\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u00112\u0018\u00105\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00f8\u0001\u0000J\u001a\u00106\u001a\u00020\r2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nR%\u0010\t\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r\u0018\u00010\nX\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;", "", "userPreferences", "Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "networkMonitor", "Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitor;", "(Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesService;Lkotlinx/coroutines/CoroutineScope;Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitor;)V", "completionHandler", "Lkotlin/Function1;", "Lkotlin/Result;", "", "", "currentUrl", "", "currentUseCase", "Lnet/consentmanager/cm_sdk_android_v3/UseCase;", "delegate", "Lnet/consentmanager/cm_sdk_android_v3/WebViewManagerDelegate;", "getDelegate", "()Lnet/consentmanager/cm_sdk_android_v3/WebViewManagerDelegate;", "setDelegate", "(Lnet/consentmanager/cm_sdk_android_v3/WebViewManagerDelegate;)V", "json", "Lkotlinx/serialization/json/Json;", "retryManager", "Lnet/consentmanager/cm_sdk_android_v3/RetryManager;", "webView", "Landroid/webkit/WebView;", "cancelOperations", "createWebView", "activityRef", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "createWebViewClient", "Landroid/webkit/WebViewClient;", "executeCompletion", "result", "(Ljava/lang/Object;)V", "handleConsentReceived", "consent", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "handleFailure", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "injectJavaScript", "isWebViewDestroyed", "loadConsentURL", "url", "useCase", "completion", "performRetry", "JavaScriptInterface", "cm-sdk-android-v3_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nWebViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewManager.kt\nnet/consentmanager/cm_sdk_android_v3/WebViewManager\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 4 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,202:1\n92#2:203\n32#3:204\n80#4:205\n*S KotlinDebug\n*F\n+ 1 WebViewManager.kt\nnet/consentmanager/cm_sdk_android_v3/WebViewManager\n*L\n123#1:203\n123#1:204\n123#1:205\n*E\n"})
public final class WebViewManager {
    @NotNull
    private final CMPUserPreferencesService userPreferences;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final NetworkMonitor networkMonitor;
    @Nullable
    private WebViewManagerDelegate delegate;
    @Nullable
    private WebView webView;
    @Nullable
    private UseCase currentUseCase;
    @Nullable
    private Function1<? super Result<Boolean>, Unit> completionHandler;
    @Nullable
    private RetryManager retryManager;
    @NotNull
    private final Json json;
    @Nullable
    private String currentUrl;

    public WebViewManager(@NotNull CMPUserPreferencesService userPreferences, @NotNull CoroutineScope coroutineScope, @NotNull NetworkMonitor networkMonitor) {
        Intrinsics.checkNotNullParameter((Object)userPreferences, (String)"userPreferences");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)networkMonitor, (String)"networkMonitor");
        this.userPreferences = userPreferences;
        this.coroutineScope = coroutineScope;
        this.networkMonitor = networkMonitor;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }

    public /* synthetic */ WebViewManager(CMPUserPreferencesService cMPUserPreferencesService, CoroutineScope coroutineScope, NetworkMonitor networkMonitor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain()));
        }
        this(cMPUserPreferencesService, coroutineScope, networkMonitor);
    }

    @Nullable
    public final WebViewManagerDelegate getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(@Nullable WebViewManagerDelegate webViewManagerDelegate) {
        this.delegate = webViewManagerDelegate;
    }

    private final WebViewClient createWebViewClient() {
        return new WebViewClient(this){
            final /* synthetic */ WebViewManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPageStarted(@Nullable WebView view, @Nullable String url, @Nullable Bitmap favicon) {
                Log.d((String)"CMPWebViewManager", (String)("Page started loading: " + url));
            }

            public void onPageFinished(@Nullable WebView view, @Nullable String url) {
                Log.d((String)"CMPWebViewManager", (String)("Page finished loading: " + url));
                WebViewManager.access$injectJavaScript(this.this$0);
            }

            @RequiresApi(value=23)
            public void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
                block0: {
                    WebResourceError webResourceError = error;
                    Log.e((String)"WebViewManager", (String)("Error loading page: " + (webResourceError != null ? webResourceError.getDescription() : null)));
                    WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                    if (webViewManagerDelegate == null) break block0;
                    WebResourceError webResourceError2 = error;
                    webViewManagerDelegate.didReceiveError("Error loading page: " + (webResourceError2 != null ? webResourceError2.getDescription() : null));
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"SetJavaScriptEnabled"})
    @Nullable
    public final WebView createWebView(@NotNull WeakReference<Activity> activityRef) {
        block5: {
            void $this$createWebView_u24lambda_u240;
            WebView webView;
            Activity activity;
            block4: {
                Intrinsics.checkNotNullParameter(activityRef, (String)"activityRef");
                Log.d((String)"CMPWebViewManager", (String)"Creating WebView");
                activity = (Activity)activityRef.get();
                if (activity == null) {
                    Log.e((String)"CMPWebViewManager", (String)"Activity reference is null, cannot create WebView");
                    return null;
                }
                if (this.webView == null) break block4;
                WebView webView2 = this.webView;
                boolean bl = webView2 != null ? !webView2.isAttachedToWindow() : false;
                if (!bl) break block5;
            }
            WebView webView3 = webView = new WebView((Context)activity);
            WebViewManager webViewManager = this;
            boolean bl = false;
            $this$createWebView_u24lambda_u240.getSettings().setJavaScriptEnabled(true);
            $this$createWebView_u24lambda_u240.getSettings().setDomStorageEnabled(true);
            $this$createWebView_u24lambda_u240.addJavascriptInterface((Object)new JavaScriptInterface(), "AndroidSDK");
            $this$createWebView_u24lambda_u240.setWebViewClient(this.createWebViewClient());
            webViewManager.webView = webView;
        }
        return this.webView;
    }

    public final void loadConsentURL(@NotNull String url, @NotNull UseCase useCase, @NotNull Function1<? super Result<Boolean>, Unit> completion) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)useCase), (String)"useCase");
            Intrinsics.checkNotNullParameter(completion, (String)"completion");
            Log.d((String)"CMPWebViewManager", (String)("Loading URL: " + url));
            this.currentUrl = url;
            this.currentUseCase = useCase;
            this.completionHandler = completion;
            WebView webView = this.webView;
            if (webView == null) break block0;
            webView.loadUrl(url);
        }
    }

    private final void injectJavaScript() {
        block0: {
            Log.d((String)"CMPWebViewManager", (String)"Injecting JavaScript");
            WebView webView = this.webView;
            if (webView == null) break block0;
            webView.evaluateJavascript("\n            (function() {\n                window.cmpToSDK_sendStatus = function(consent, jsonObject) {\n                    jsonObject.cmpString = consent;\n                    AndroidSDK.postMessage('consent', JSON.stringify(jsonObject));\n                };\n                window.cmpToSDK_showConsentLayer = function() {\n                    AndroidSDK.postMessage('open', 'true');\n                };\n                window.onerror = function(message, source, lineno, colno, error) {\n                    AndroidSDK.postMessage('error', JSON.stringify({\n                        message: message,\n                        source: source,\n                        lineno: lineno,\n                        colno: colno,\n                        error: error ? error.toString() : null\n                    }));\n                };\n            })();\n        ", arg_0 -> WebViewManager.injectJavaScript$lambda$1(this, arg_0));
        }
    }

    private final void handleFailure(Exception error) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, error, null){
            int label;
            final /* synthetic */ WebViewManager this$0;
            final /* synthetic */ Exception $error;
            {
                this.this$0 = $receiver;
                this.$error = $error;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                        if (webViewManagerDelegate != null) {
                            String string = this.$error.getMessage();
                            if (string == null) {
                                string = "Unknown error occurred";
                            }
                            webViewManagerDelegate.didReceiveError(string);
                        }
                        WebViewManager.access$executeCompletion(this.this$0, Result.constructor-impl((Object)ResultKt.createFailure((Throwable)this.$error)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void handleConsentReceived(@NotNull String consent, @NotNull JsonObject jsonObject) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)consent, (String)"consent");
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            try {
                StringFormat $this$encodeToString$iv = (StringFormat)this.json;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
                boolean $i$f$cast = false;
                String jsonString = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)jsonObject);
                this.userPreferences.saveConsentData(jsonString, consent);
                WebViewManagerDelegate webViewManagerDelegate = this.delegate;
                if (webViewManagerDelegate != null) {
                    webViewManagerDelegate.didReceiveConsentMessage(consent, jsonObject);
                }
                Function1<? super Result<Boolean>, Unit> function1 = this.completionHandler;
                if (function1 == null) break block3;
                function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)false)));
            }
            catch (Exception e) {
                WebViewManagerDelegate webViewManagerDelegate = this.delegate;
                if (webViewManagerDelegate == null) break block3;
                webViewManagerDelegate.didReceiveError("Error decoding JSON: " + e.getMessage());
            }
        }
    }

    private final void executeCompletion(Object result) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, result, null){
            int label;
            final /* synthetic */ WebViewManager this$0;
            final /* synthetic */ Object $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Function1 function1 = WebViewManager.access$getCompletionHandler$p(this.this$0);
                        if (function1 != null) {
                            function1.invoke((Object)Result.box-impl((Object)this.$result));
                        }
                        WebViewManager.access$setCompletionHandler$p(this.this$0, null);
                        WebViewManager.access$setCurrentUseCase$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void cancelOperations() {
        block2: {
            WebView webView = this.webView;
            if (webView != null) {
                webView.stopLoading();
            }
            Function1<? super Result<Boolean>, Unit> function1 = this.completionHandler;
            if (function1 != null) {
                function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Operation cancelled")))));
            }
            this.completionHandler = null;
            this.currentUseCase = null;
            RetryManager retryManager = this.retryManager;
            if (retryManager == null) break block2;
            retryManager.reset();
        }
    }

    public final void performRetry(@NotNull Function1<? super Boolean, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        WebView webView = this.webView;
        boolean bl = false;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(webView, completion, null){
            int label;
            final /* synthetic */ WebView $webView;
            final /* synthetic */ Function1<Boolean, Unit> $completion;
            {
                this.$webView = $webView;
                this.$completion = $completion;
                super(2, $completion2);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$webView != null) {
                            Unit unit;
                            String string = this.$webView.getUrl();
                            if (string != null) {
                                String string2 = string;
                                WebView webView = this.$webView;
                                Function1<Boolean, Unit> function1 = this.$completion;
                                String url = string2;
                                boolean bl = false;
                                webView.loadUrl(url);
                                function1.invoke((Object)Boxing.boxBoolean((boolean)true));
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            if (unit == null) {
                                this.$completion.invoke((Object)Boxing.boxBoolean((boolean)false));
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final boolean isWebViewDestroyed() {
        return this.webView == null;
    }

    private static final void injectJavaScript$lambda$1(WebViewManager this$0, String result) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Log.d((String)"CMPWebViewManager", (String)("JavaScript injection result: " + result));
                if (!Intrinsics.areEqual((Object)result, (Object)"null")) break block0;
                Log.d((String)"CMPWebViewManager", (String)"JavaScript injected successfully.");
                RetryManager retryManager = this$0.retryManager;
                if (retryManager == null) break block1;
                retryManager.reset();
                break block1;
            }
            Log.d((String)"CMPWebViewManager", (String)("Error injecting JavaScript: " + result));
            RetryManager retryManager = this$0.retryManager;
            if (retryManager == null) break block1;
            retryManager.retry((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this$0){
                final /* synthetic */ WebViewManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(boolean success) {
                    if (!success) {
                        WebViewManager.access$handleFailure(this.this$0, new Exception("Failed to inject JavaScript"));
                    }
                }
            }));
        }
    }

    public static final /* synthetic */ void access$injectJavaScript(WebViewManager $this) {
        $this.injectJavaScript();
    }

    public static final /* synthetic */ void access$executeCompletion(WebViewManager $this, Object result) {
        $this.executeCompletion(result);
    }

    public static final /* synthetic */ Function1 access$getCompletionHandler$p(WebViewManager $this) {
        return $this.completionHandler;
    }

    public static final /* synthetic */ void access$setCompletionHandler$p(WebViewManager $this, Function1 function1) {
        $this.completionHandler = function1;
    }

    public static final /* synthetic */ void access$setCurrentUseCase$p(WebViewManager $this, UseCase useCase) {
        $this.currentUseCase = useCase;
    }

    public static final /* synthetic */ Json access$getJson$p(WebViewManager $this) {
        return $this.json;
    }

    public static final /* synthetic */ UseCase access$getCurrentUseCase$p(WebViewManager $this) {
        return $this.currentUseCase;
    }

    public static final /* synthetic */ RetryManager access$getRetryManager$p(WebViewManager $this) {
        return $this.retryManager;
    }

    public static final /* synthetic */ void access$handleFailure(WebViewManager $this, Exception error) {
        $this.handleFailure(error);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/WebViewManager$JavaScriptInterface;", "", "(Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;)V", "postMessage", "", "type", "", "message", "cm-sdk-android-v3_release"})
    public final class JavaScriptInterface {
        @JavascriptInterface
        public final void postMessage(@NotNull String type, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Log.d((String)"CMPWebViewManager", (String)("Received message: type=" + type + ", message=" + message));
            BuildersKt.launch$default((CoroutineScope)WebViewManager.this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(type, message, WebViewManager.this, null){
                int label;
                final /* synthetic */ String $type;
                final /* synthetic */ String $message;
                final /* synthetic */ WebViewManager this$0;
                {
                    this.$type = $type;
                    this.$message = $message;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            switch (this.$type) {
                                case "consent": {
                                    Log.d((String)"CMPWebViewManager", (String)("Received consent message: " + this.$message));
                                    JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)WebViewManager.access$getJson$p(this.this$0).parseToJsonElement(this.$message));
                                    Object object2 = (JsonElement)jsonObject.get((Object)"cmpString");
                                    if (object2 == null || (object2 = object2.toString()) == null) {
                                        return Unit.INSTANCE;
                                    }
                                    Object consent = object2;
                                    if (WebViewManager.access$getCurrentUseCase$p(this.this$0) == UseCase.PERFORM_DRY_CHECK_CONSENT) {
                                        WebViewManager.access$executeCompletion(this.this$0, Result.constructor-impl((Object)Boxing.boxBoolean((boolean)false)));
                                        break;
                                    }
                                    this.this$0.handleConsentReceived((String)consent, jsonObject);
                                    break;
                                }
                                case "open": {
                                    Log.d((String)"CMPWebViewManager", (String)"Received open message");
                                    if (WebViewManager.access$getCurrentUseCase$p(this.this$0) == UseCase.CHECK_CONSENT || WebViewManager.access$getCurrentUseCase$p(this.this$0) == UseCase.PERFORM_DRY_CHECK_CONSENT) {
                                        WebViewManager.access$executeCompletion(this.this$0, Result.constructor-impl((Object)Boxing.boxBoolean((boolean)true)));
                                        break;
                                    }
                                    WebViewManager.access$executeCompletion(this.this$0, Result.constructor-impl((Object)Boxing.boxBoolean((boolean)false)));
                                    WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                                    if (webViewManagerDelegate != null) {
                                        webViewManagerDelegate.didReceiveOpenMessage();
                                    }
                                    break;
                                }
                                case "error": {
                                    WebViewManagerDelegate webViewManagerDelegate = this.this$0.getDelegate();
                                    if (webViewManagerDelegate != null) {
                                        webViewManagerDelegate.didReceiveError(this.$message);
                                    }
                                    WebViewManager.access$executeCompletion(this.this$0, Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception(this.$message))));
                                }
                            }
                            RetryManager retryManager = WebViewManager.access$getRetryManager$p(this.this$0);
                            if (retryManager != null) {
                                retryManager.reset();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }
}

