/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.annotation.SuppressLint;
import androidx.annotation.Keep;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.consentmanager.cm_sdk_android_v3.CMPUrlBuilder;
import net.consentmanager.cm_sdk_android_v3.CMPUrlParams;
import net.consentmanager.cm_sdk_android_v3.UseCase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\tH\u0002J*\u0010\u000b\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000f\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0010\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0011\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\tH\u0002J*\u0010\u0012\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0013\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0014\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\tH\u0002J*\u0010\u0015\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n0\tH\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u0018\u001a\u00020\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/CMPUrlBuilder;", "", "()V", "SDK_VERSION", "", "URL_V5", "appendAcceptParams", "", "queryParams", "", "Lkotlin/Pair;", "appendCheckConsentParams", "params", "Lnet/consentmanager/cm_sdk_android_v3/CMPUrlParams;", "appendCommonParams", "appendDisablePurposesParams", "appendDisableVendorsParams", "appendDryParams", "appendEnablePurposesParams", "appendEnableVendorsParams", "appendImportParams", "appendOpenConsentParams", "appendRejectParams", "build", "dateAndRandomNumberAsString", "cm-sdk-android-v3_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nUrlBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlBuilder.kt\nnet/consentmanager/cm_sdk_android_v3/CMPUrlBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
public final class CMPUrlBuilder {
    @NotNull
    public static final CMPUrlBuilder INSTANCE = new CMPUrlBuilder();
    @NotNull
    private static final String URL_V5 = "https://%s/delivery/appcmp_v5.php?cdid=%s";
    @NotNull
    private static final String SDK_VERSION = "3.0.0";

    private CMPUrlBuilder() {
    }

    @NotNull
    public final String build(@NotNull CMPUrlParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = URL_V5;
        Object[] objectArray = new Object[]{params.getDomain(), params.getId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String baseUrl = string2;
        List queryParams = new ArrayList();
        this.appendCommonParams(queryParams, params);
        switch (WhenMappings.$EnumSwitchMapping$0[params.getUseCase().ordinal()]) {
            case 1: 
            case 2: {
                this.appendCheckConsentParams(queryParams, params);
                break;
            }
            case 3: {
                this.appendOpenConsentParams(queryParams, params);
                break;
            }
            case 4: 
            case 5: {
                this.appendDryParams(queryParams);
                break;
            }
            case 6: {
                this.appendImportParams(queryParams);
                break;
            }
            case 7: {
                this.appendEnablePurposesParams(queryParams, params);
                break;
            }
            case 8: {
                this.appendDisablePurposesParams(queryParams, params);
                break;
            }
            case 9: {
                this.appendEnableVendorsParams(queryParams, params);
                break;
            }
            case 10: {
                this.appendDisableVendorsParams(queryParams, params);
                break;
            }
            case 11: {
                this.appendAcceptParams(queryParams);
                break;
            }
            case 12: {
                this.appendRejectParams(queryParams);
            }
        }
        String queryString2 = CollectionsKt.joinToString$default((Iterable)queryParams, (CharSequence)"&", null, null, (int)0, null, (Function1)build.queryString.1.INSTANCE, (int)30, null);
        String finalUrl = baseUrl + '&' + queryString2;
        if (params.getConsent() != null) {
            String stamp = this.dateAndRandomNumberAsString();
            finalUrl = finalUrl + "#cmpimport=" + URLEncoder.encode(params.getConsent(), "UTF-8") + "&zt=" + stamp;
        }
        return finalUrl;
    }

    private final void appendCommonParams(List<Pair<String, String>> queryParams, CMPUrlParams params) {
        String it;
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"sdkv", (Object)SDK_VERSION));
        String string = params.getAppName();
        if (string != null) {
            it = string;
            boolean bl = false;
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"appname", (Object)StringsKt.replace$default((String)it, (String)" ", (String)"-", (boolean)false, (int)4, null)));
        }
        String string2 = params.getLanguage();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmplang", (Object)it));
        }
        String string3 = params.getBundleID();
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"appid", (Object)it));
        }
        String string4 = params.getIdfa();
        if (string4 != null) {
            it = string4;
            boolean bl = false;
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"idfa", (Object)it));
        }
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpatt", (Object)String.valueOf(params.getAttStatus())));
        if (params.isDebugMode()) {
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpdebug", (Object)""));
        }
    }

    private final void appendCheckConsentParams(List<Pair<String, String>> queryParams, CMPUrlParams params) {
        Integer n = params.getDesignId();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"usedesign", (Object)String.valueOf(it)));
        }
        if (params.getJumpToSettingsPage()) {
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreencustom", (Object)""));
        }
    }

    private final void appendOpenConsentParams(List<Pair<String, String>> queryParams, CMPUrlParams params) {
        this.appendCheckConsentParams(queryParams, params);
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreen", (Object)""));
        if (params.isTV()) {
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"tvsdk", (Object)"1"));
        }
    }

    private final void appendDryParams(List<Pair<String, String>> queryParams) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpskipcookies", (Object)"1"));
    }

    private final void appendImportParams(List<Pair<String, String>> queryParams) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpskipcookies", (Object)"1"));
    }

    private final void appendEnablePurposesParams(List<Pair<String, String>> queryParams, CMPUrlParams params) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpsetpurposes", (Object)CollectionsKt.joinToString$default((Iterable)params.getAddPurposes(), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null)));
        if (!params.getUpdateVendors()) {
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpdontfixpurposes", (Object)""));
        }
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpautoaccept", (Object)"1"));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreen", (Object)""));
    }

    private final void appendDisablePurposesParams(List<Pair<String, String>> queryParams, CMPUrlParams params) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpsetpurposes", (Object)CollectionsKt.joinToString$default((Iterable)params.getAddPurposes(), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null)));
        if (!params.getUpdateVendors()) {
            queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpdontfixpurposes", (Object)""));
        }
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpautoreject", (Object)""));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreen", (Object)""));
    }

    private final void appendEnableVendorsParams(List<Pair<String, String>> queryParams, CMPUrlParams params) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpsetvendors", (Object)CollectionsKt.joinToString$default((Iterable)params.getAddVendors(), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null)));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpautoaccept", (Object)"1"));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreen", (Object)""));
    }

    private final void appendDisableVendorsParams(List<Pair<String, String>> queryParams, CMPUrlParams params) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpsetvendors", (Object)CollectionsKt.joinToString$default((Iterable)params.getAddVendors(), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null)));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpautoreject", (Object)""));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreen", (Object)""));
    }

    private final void appendAcceptParams(List<Pair<String, String>> queryParams) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpautoaccept", (Object)"1"));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreen", (Object)""));
    }

    private final void appendRejectParams(List<Pair<String, String>> queryParams) {
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpautoreject", (Object)""));
        queryParams.add((Pair<String, String>)TuplesKt.to((Object)"cmpscreen", (Object)""));
    }

    @SuppressLint(value={"DefaultLocale"})
    private final String dateAndRandomNumberAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmss", Locale.US);
        String dateString = dateFormat.format(new Date());
        int randomNumber = RangesKt.random((IntRange)new IntRange(0, 9999), (Random)((Random)Random.Default));
        String string = "%s%04d";
        Object[] objectArray = new Object[]{dateString, randomNumber};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UseCase.values().length];
            try {
                nArray[UseCase.VERIFY_CONSENT_ON_INITIALIZE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.CHECK_CONSENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.OPEN_CONSENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.PERFORM_DRY_CHECK_CONSENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.PERFORM_DRY_CHECK_WITH_CACHE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.IMPORT_CONSENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.ENABLE_CONSENT_PURPOSES.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.DISABLE_CONSENT_PURPOSES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.ENABLE_CONSENT_VENDORS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.DISABLE_CONSENT_VENDORS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.ACCEPT_ALL_CONSENT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.REJECT_ALL_CONSENT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UseCase.RESET_CONSENT_SETTINGS.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

