/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.Keep;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import kotlinx.serialization.json.JsonPrimitive;
import net.consentmanager.cm_sdk_android_v3.CMPUserPreferencesService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesServiceImpl;", "Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesService;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "consentStringKey", "", "jsonKey", "prefs", "Landroid/content/SharedPreferences;", "convertBinaryStringToJsonObject", "Lkotlinx/serialization/json/JsonObject;", "binaryString", "convertMapToBinaryString", "jsonObject", "getConsentData", "Lkotlin/Pair;", "reconstructJsonFromPrefs", "resetConsentManagementData", "", "saveConsentData", "json", "consentString", "cm-sdk-android-v3_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nCMPUserPreferencesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMPUserPreferencesService.kt\nnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,106:1\n1#2:107\n1045#3:108\n28#4,4:109\n28#4,3:113\n31#4:119\n1183#5,3:116\n*S KotlinDebug\n*F\n+ 1 CMPUserPreferencesService.kt\nnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesServiceImpl\n*L\n67#1:108\n74#1:109,4\n99#1:113,3\n99#1:119\n100#1:116,3\n*E\n"})
public final class CMPUserPreferencesServiceImpl
implements CMPUserPreferencesService {
    @NotNull
    private final SharedPreferences prefs;
    @NotNull
    private final String jsonKey;
    @NotNull
    private final String consentStringKey;

    public CMPUserPreferencesServiceImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sharedPreferences = context.getSharedPreferences("CMPPrefs", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.prefs = sharedPreferences;
        this.jsonKey = "consentJson";
        this.consentStringKey = "consentString";
    }

    @Override
    public void saveConsentData(@NotNull String json2, @NotNull String consentString) {
        JsonElement it;
        SharedPreferences.Editor editor;
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)consentString, (String)"consentString");
        JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(json2));
        SharedPreferences.Editor $this$saveConsentData_u24lambda_u2412 = editor = this.prefs.edit();
        boolean bl = false;
        $this$saveConsentData_u24lambda_u2412.putString(this.jsonKey, json2);
        $this$saveConsentData_u24lambda_u2412.putString(this.consentStringKey, consentString);
        $this$saveConsentData_u24lambda_u2412.putString("IABTCF_TCString", consentString);
        JsonElement jsonElement = (JsonElement)jsonObject.get((Object)"vendorConsents");
        if (jsonElement != null) {
            it = jsonElement;
            boolean bl2 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_VendorConsents", this.convertMapToBinaryString(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)"purposeConsents");
        if (jsonElement2 != null) {
            it = jsonElement2;
            boolean bl3 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_PurposeConsents", this.convertMapToBinaryString(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement3 = (JsonElement)jsonObject.get((Object)"specialFeatureOptins");
        if (jsonElement3 != null) {
            it = jsonElement3;
            boolean bl4 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_SpecialFeaturesOptIns", this.convertMapToBinaryString(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement4 = (JsonElement)jsonObject.get((Object)"publisherConsent");
        if (jsonElement4 != null) {
            it = jsonElement4;
            boolean bl5 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_PublisherConsent", JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
        }
        JsonElement jsonElement5 = (JsonElement)jsonObject.get((Object)"purposeLI");
        if (jsonElement5 != null) {
            it = jsonElement5;
            boolean bl6 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_PurposeLegitimateInterests", this.convertMapToBinaryString(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement6 = (JsonElement)jsonObject.get((Object)"vendorLI");
        if (jsonElement6 != null) {
            it = jsonElement6;
            boolean bl7 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_VendorLegitimateInterests", this.convertMapToBinaryString(JsonElementKt.getJsonObject((JsonElement)it)));
        }
        JsonElement jsonElement7 = (JsonElement)jsonObject.get((Object)"gdprApplies");
        if (jsonElement7 != null) {
            it = jsonElement7;
            boolean bl8 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_gdprApplies", JsonElementKt.getBoolean((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)it)) ? "1" : "0");
        }
        JsonElement jsonElement8 = (JsonElement)jsonObject.get((Object)"cmpId");
        if (jsonElement8 != null) {
            it = jsonElement8;
            boolean bl9 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_CmpSdkID", JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
        }
        JsonElement jsonElement9 = (JsonElement)jsonObject.get((Object)"cmpVersion");
        if (jsonElement9 != null) {
            it = jsonElement9;
            boolean bl10 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_CmpSdkVersion", JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
        }
        JsonElement jsonElement10 = (JsonElement)jsonObject.get((Object)"tcfPolicyVersion");
        if (jsonElement10 != null) {
            it = jsonElement10;
            boolean bl11 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_PolicyVersion", JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
        }
        JsonElement jsonElement11 = (JsonElement)jsonObject.get((Object)"uspstring");
        if (jsonElement11 != null) {
            it = jsonElement11;
            boolean bl12 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABUSPrivacy_String", JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
        }
        JsonElement jsonElement12 = (JsonElement)jsonObject.get((Object)"addtlConsent");
        if (jsonElement12 != null) {
            it = jsonElement12;
            boolean bl13 = false;
            $this$saveConsentData_u24lambda_u2412.putString("IABTCF_AddtlConsent", JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
        }
        editor.apply();
        Log.d((String)"CMPUserPrefsService", (String)"Consent data saved");
    }

    @Override
    @NotNull
    public Pair<String, String> getConsentData() {
        String json2 = this.prefs.getString(this.jsonKey, null);
        String consentString = this.prefs.getString(this.consentStringKey, null);
        return json2 == null && consentString != null ? new Pair((Object)this.reconstructJsonFromPrefs(), (Object)consentString) : new Pair((Object)json2, (Object)consentString);
    }

    private final String convertMapToBinaryString(JsonObject jsonObject) {
        Iterable $this$sortedBy$iv = jsonObject.keySet();
        boolean $i$f$sortedBy = false;
        List sortedKeys = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                Integer n = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)it, (CharSequence)"c"));
                it = (String)b;
                Comparable comparable = Integer.valueOf(n != null ? n : Integer.MAX_VALUE);
                bl = false;
                Integer n2 = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)it, (CharSequence)"c"));
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : Integer.MAX_VALUE));
            }
        });
        return CollectionsKt.joinToString$default((Iterable)sortedKeys, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(jsonObject){
            final /* synthetic */ JsonObject $jsonObject;
            {
                this.$jsonObject = $jsonObject;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                JsonElement jsonElement = (JsonElement)this.$jsonObject.get((Object)key);
                return (jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getBoolean((JsonPrimitive)jsonElement) : false) ? (CharSequence)"1" : (CharSequence)"0";
            }
        }), (int)30, null);
    }

    private final String reconstructJsonFromPrefs() {
        JsonObjectBuilder builder$iv;
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$reconstructJsonFromPrefs_u24lambda_u2414 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"cmpString", (String)this.prefs.getString("IABTCF_TCString", ""));
        $this$reconstructJsonFromPrefs_u24lambda_u2414.put("vendorConsents", (JsonElement)this.convertBinaryStringToJsonObject(this.prefs.getString("IABTCF_VendorConsents", "")));
        $this$reconstructJsonFromPrefs_u24lambda_u2414.put("purposeConsents", (JsonElement)this.convertBinaryStringToJsonObject(this.prefs.getString("IABTCF_PurposeConsents", "")));
        $this$reconstructJsonFromPrefs_u24lambda_u2414.put("specialFeatureOptins", (JsonElement)this.convertBinaryStringToJsonObject(this.prefs.getString("IABTCF_SpecialFeaturesOptIns", "")));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"publisherConsent", (String)this.prefs.getString("IABTCF_PublisherConsent", ""));
        $this$reconstructJsonFromPrefs_u24lambda_u2414.put("purposeLI", (JsonElement)this.convertBinaryStringToJsonObject(this.prefs.getString("IABTCF_PurposeLegitimateInterests", "")));
        $this$reconstructJsonFromPrefs_u24lambda_u2414.put("vendorLI", (JsonElement)this.convertBinaryStringToJsonObject(this.prefs.getString("IABTCF_VendorLegitimateInterests", "")));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"gdprApplies", (Boolean)Intrinsics.areEqual((Object)this.prefs.getString("IABTCF_gdprApplies", "0"), (Object)"1"));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"cmpId", (String)this.prefs.getString("IABTCF_CmpSdkID", ""));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"cmpVersion", (String)this.prefs.getString("IABTCF_CmpSdkVersion", ""));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"tcfPolicyVersion", (String)this.prefs.getString("IABTCF_PolicyVersion", ""));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"uspstring", (String)this.prefs.getString("IABUSPrivacy_String", ""));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$reconstructJsonFromPrefs_u24lambda_u2414, (String)"addtlConsent", (String)this.prefs.getString("IABTCF_AddtlConsent", ""));
        JsonObject jsonObject = builder$iv.build();
        return jsonObject.toString();
    }

    @Override
    public void resetConsentManagementData() {
        this.prefs.edit().clear().apply();
        Log.d((String)"CMPUserPrefsService", (String)"Consent data cleared");
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject convertBinaryStringToJsonObject(String binaryString) {
        JsonObjectBuilder builder$iv;
        CharSequence charSequence = binaryString;
        if (charSequence == null || charSequence.length() == 0) {
            return new JsonObject(MapsKt.emptyMap());
        }
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$convertBinaryStringToJsonObject_u24lambda_u2416 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        CharSequence $this$forEachIndexed$iv = binaryString;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void char_;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl2 = false;
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$convertBinaryStringToJsonObject_u24lambda_u2416, (String)("" + 'c' + (index + 1)), (Boolean)(char_ == 49 ? 1 : 0));
        }
        return builder$iv.build();
    }
}

