/*
 * Decompiled with CFR 0.152.
 */
package net.consentmanager.cm_sdk_android_v3;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.webkit.WebView;
import androidx.annotation.Keep;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.json.JsonObject;
import net.consentmanager.cm_sdk_android_v3.CMPConsentModel;
import net.consentmanager.cm_sdk_android_v3.CMPManager;
import net.consentmanager.cm_sdk_android_v3.CMPManagerDelegate;
import net.consentmanager.cm_sdk_android_v3.CMPUrlBuilder;
import net.consentmanager.cm_sdk_android_v3.CMPUrlParams;
import net.consentmanager.cm_sdk_android_v3.CMPUserPreferencesService;
import net.consentmanager.cm_sdk_android_v3.CMPUserPreferencesServiceImpl;
import net.consentmanager.cm_sdk_android_v3.ConsentLayerDialog;
import net.consentmanager.cm_sdk_android_v3.ConsentLayerUIConfig;
import net.consentmanager.cm_sdk_android_v3.NetworkMonitor;
import net.consentmanager.cm_sdk_android_v3.NetworkMonitorDelegate;
import net.consentmanager.cm_sdk_android_v3.RetryManager;
import net.consentmanager.cm_sdk_android_v3.UrlConfig;
import net.consentmanager.cm_sdk_android_v3.UseCase;
import net.consentmanager.cm_sdk_android_v3.WebViewContainer;
import net.consentmanager.cm_sdk_android_v3.WebViewManager;
import net.consentmanager.cm_sdk_android_v3.WebViewManagerDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u0000 b2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001bB'\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ#\u0010 \u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J9\u0010%\u001a\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020*2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J1\u0010+\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020(0'2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J\u001a\u0010-\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020!0#J#\u0010.\u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J\b\u0010/\u001a\u00020!H\u0002J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020!H\u0016J\u0018\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020(2\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020(H\u0016J\b\u0010;\u001a\u00020!H\u0016J\b\u0010<\u001a\u00020!H\u0002J\u0006\u0010=\u001a\u00020(J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020(0'J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020(0'J\n\u0010@\u001a\u0004\u0018\u00010AH\u0002J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020(0'J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020(0'J\f\u0010D\u001a\b\u0012\u0004\u0012\u00020(0'J\f\u0010E\u001a\b\u0012\u0004\u0012\u00020(0'J\u000e\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020(J\u0006\u0010H\u001a\u00020*J\u000e\u0010I\u001a\u00020*2\u0006\u0010G\u001a\u00020(JE\u0010J\u001a\u00020!2\u0006\u00102\u001a\u0002032\u0016\b\u0002\u0010K\u001a\u0010\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020M\u0018\u00010L2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0$\u0012\u0004\u0012\u00020!0#H\u0002\u00f8\u0001\u0000J\u0010\u0010N\u001a\u00020!2\u0006\u0010O\u001a\u00020*H\u0016J\u0006\u0010P\u001a\u00020!J\u0006\u0010Q\u001a\u00020!J\u0006\u0010R\u001a\u00020!J\u0010\u0010S\u001a\u00020!2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020!2\u0006\u0010T\u001a\u00020UH\u0016J#\u0010W\u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J#\u0010X\u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J9\u0010Y\u001a\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010Z\u001a\u00020*2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J1\u0010[\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020(0'2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0$\u0012\u0004\u0012\u00020!0#\u00f8\u0001\u0000J\u0006\u0010\\\u001a\u00020!J\u000e\u0010]\u001a\u00020!2\u0006\u0010^\u001a\u00020\u000fJ\u000e\u0010_\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010`\u001a\u00020!H\u0002J\b\u0010a\u001a\u00020!H\u0002R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006c"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/CMPManager;", "Lnet/consentmanager/cm_sdk_android_v3/WebViewManagerDelegate;", "Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitorDelegate;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "context", "Landroid/content/Context;", "urlConfig", "Lnet/consentmanager/cm_sdk_android_v3/UrlConfig;", "webViewConfig", "Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerUIConfig;", "delegate", "Lnet/consentmanager/cm_sdk_android_v3/CMPManagerDelegate;", "(Landroid/content/Context;Lnet/consentmanager/cm_sdk_android_v3/UrlConfig;Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerUIConfig;Lnet/consentmanager/cm_sdk_android_v3/CMPManagerDelegate;)V", "activityContext", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "consentLayerDialog", "Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerDialog;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "networkMonitor", "Lnet/consentmanager/cm_sdk_android_v3/NetworkMonitor;", "retryManager", "Lnet/consentmanager/cm_sdk_android_v3/RetryManager;", "userPreferences", "Lnet/consentmanager/cm_sdk_android_v3/CMPUserPreferencesService;", "webView", "Landroid/webkit/WebView;", "webViewContainer", "Lnet/consentmanager/cm_sdk_android_v3/WebViewContainer;", "webViewManager", "Lnet/consentmanager/cm_sdk_android_v3/WebViewManager;", "acceptAll", "", "completion", "Lkotlin/Function1;", "Lkotlin/Result;", "acceptPurposes", "purposes", "", "", "updatePurpose", "", "acceptVendors", "vendors", "checkIfConsentIsRequired", "checkWithServerAndOpenIfNecessary", "cleanUp", "createUrlParams", "Lnet/consentmanager/cm_sdk_android_v3/CMPUrlParams;", "useCase", "Lnet/consentmanager/cm_sdk_android_v3/UseCase;", "didNotNeedOpenConsentLayer", "didReceiveConsentMessage", "consent", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "didReceiveError", "error", "didReceiveOpenMessage", "dismissConsentLayer", "exportCMPInfo", "getAllPurposesIDs", "getAllVendorsIDs", "getConsentModel", "Lnet/consentmanager/cm_sdk_android_v3/CMPConsentModel;", "getDisabledPurposesIDs", "getDisabledVendorsIDs", "getEnabledPurposesIDs", "getEnabledVendorsIDs", "hasPurposeConsent", "id", "hasUserChoice", "hasVendorConsent", "loadConsentURLWithUseCase", "additionalParams", "", "", "networkStatusDidChange", "isConnected", "onActivityDestroyed", "onApplicationPause", "onApplicationResume", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onResume", "openConsentLayer", "rejectAll", "rejectPurposes", "updateVendor", "rejectVendors", "resetConsentManagementData", "setActivity", "activity", "setWebView", "setupWebView", "showConsentLayer", "Companion", "cm-sdk-android-v3_release"})
@Keep
@SourceDebugExtension(value={"SMAP\nCMPManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMPManager.kt\nnet/consentmanager/cm_sdk_android_v3/CMPManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
public final class CMPManager
implements WebViewManagerDelegate,
NetworkMonitorDelegate,
DefaultLifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final UrlConfig urlConfig;
    @NotNull
    private final ConsentLayerUIConfig webViewConfig;
    @NotNull
    private final CMPManagerDelegate delegate;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CMPUserPreferencesService userPreferences;
    @NotNull
    private final WebViewManager webViewManager;
    @NotNull
    private final NetworkMonitor networkMonitor;
    @NotNull
    private final RetryManager retryManager;
    @Nullable
    private WeakReference<Activity> activityContext;
    @Nullable
    private ConsentLayerDialog consentLayerDialog;
    @Nullable
    private WebView webView;
    @Nullable
    private WebViewContainer webViewContainer;
    @NotNull
    private static final AtomicReference<CMPManager> instanceRef = new AtomicReference<Object>(null);

    private CMPManager(Context context, UrlConfig urlConfig, ConsentLayerUIConfig webViewConfig, CMPManagerDelegate delegate) {
        this.context = context;
        this.urlConfig = urlConfig;
        this.webViewConfig = webViewConfig;
        this.delegate = delegate;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain()));
        this.userPreferences = new CMPUserPreferencesServiceImpl(this.context);
        this.networkMonitor = new NetworkMonitor(this.context);
        this.networkMonitor.setDelegate(this);
        this.webViewManager = new WebViewManager(this.userPreferences, this.coroutineScope, this.networkMonitor);
        this.webViewManager.setDelegate(this);
        this.retryManager = new RetryManager(3, 2000L, this.webViewManager, null, 8, null);
        this.setupWebView();
    }

    public final void setActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activityContext = new WeakReference<Activity>(activity);
        this.setupWebView();
    }

    public final void setWebView(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this.webView = webView;
        this.setupWebView();
    }

    /*
     * WARNING - void declaration
     */
    private final void setupWebView() {
        WebViewContainer webViewContainer;
        Activity activity = this.activityContext;
        if (activity == null || (activity = (Activity)activity.get()) == null) {
            return;
        }
        Activity activity2 = activity;
        this.webView = this.webViewManager.createWebView(new WeakReference<Activity>(activity2));
        CMPManager cMPManager = this;
        WebView webView = this.webView;
        if (webView != null) {
            void it;
            WebView webView2 = webView;
            CMPManager cMPManager2 = cMPManager;
            boolean bl = false;
            webViewContainer = new WebViewContainer((WebView)it);
            cMPManager = cMPManager2;
        } else {
            webViewContainer = null;
        }
        cMPManager.webViewContainer = webViewContainer;
    }

    private final void showConsentLayer() {
        block8: {
            ConsentLayerUIConfig config;
            WeakReference<Activity> activity;
            block7: {
                Log.d((String)"CMPManager", (String)"Showing consent layer");
                WeakReference<Activity> weakReference = this.activityContext;
                if (weakReference == null) {
                    CMPManager $this$showConsentLayer_u24lambda_u241 = this;
                    boolean bl = false;
                    $this$showConsentLayer_u24lambda_u241.delegate.didReceiveError("No valid activity context available");
                    return;
                }
                activity = weakReference;
                config = this.webViewConfig;
                if (this.webView == null) {
                    WebView webView = this.webView = this.webViewManager.createWebView(activity);
                    Intrinsics.checkNotNull((Object)webView);
                    this.webViewContainer = new WebViewContainer(webView);
                }
                if (this.consentLayerDialog == null) break block7;
                ConsentLayerDialog consentLayerDialog = this.consentLayerDialog;
                boolean bl = consentLayerDialog != null ? !consentLayerDialog.isShowing() : false;
                if (!bl) break block8;
            }
            Log.d((String)"CMPManager", (String)"Creating new consent layer dialog");
            ConsentLayerDialog consentLayerDialog = this.consentLayerDialog;
            if (consentLayerDialog != null) {
                consentLayerDialog.dismiss();
            }
            Object t = activity.get();
            Intrinsics.checkNotNull(t);
            Activity activity2 = (Activity)t;
            WebViewContainer webViewContainer = this.webViewContainer;
            Intrinsics.checkNotNull((Object)webViewContainer);
            ConsentLayerDialog consentLayerDialog2 = this.consentLayerDialog = new ConsentLayerDialog(activity2, config, webViewContainer, this.webViewManager, null, 16, null);
            if (consentLayerDialog2 != null) {
                consentLayerDialog2.show();
            }
        }
        this.delegate.didShowConsentLayer();
    }

    private final void dismissConsentLayer() {
        Log.d((String)"CMPManager", (String)"Dismissing consent layer");
        ConsentLayerDialog consentLayerDialog = this.consentLayerDialog;
        if (consentLayerDialog != null) {
            consentLayerDialog.dismiss();
        }
        this.consentLayerDialog = null;
    }

    private final CMPUrlParams createUrlParams(UseCase useCase) {
        CMPConsentModel cMPConsentModel = this.getConsentModel();
        return new CMPUrlParams(this.urlConfig.getId(), this.urlConfig.getDomain(), useCase, cMPConsentModel != null ? cMPConsentModel.exportCMPInfo() : null, this.urlConfig.getLanguage(), this.urlConfig.getAppName(), this.context.getPackageName(), null, null, false, null, false, false, false, false, false, null, null, false, 0, false, 2096512, null);
    }

    private final CMPConsentModel getConsentModel() {
        CMPConsentModel cMPConsentModel;
        String jsonString;
        String string = jsonString = (String)this.userPreferences.getConsentData().component1();
        if (string != null) {
            String it = string;
            boolean bl = false;
            cMPConsentModel = CMPConsentModel.Companion.fromJson(it);
        } else {
            cMPConsentModel = null;
        }
        return cMPConsentModel;
    }

    public final boolean hasUserChoice() {
        CMPConsentModel cMPConsentModel = this.getConsentModel();
        return cMPConsentModel != null ? cMPConsentModel.hasUserChoice() : false;
    }

    public final boolean hasPurposeConsent(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CMPConsentModel cMPConsentModel = this.getConsentModel();
        return cMPConsentModel != null ? cMPConsentModel.hasPurposeConsent(id) : false;
    }

    public final boolean hasVendorConsent(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CMPConsentModel cMPConsentModel = this.getConsentModel();
        return cMPConsentModel != null ? cMPConsentModel.hasVendorConsent(id) : false;
    }

    @NotNull
    public final String exportCMPInfo() {
        Object object = this.getConsentModel();
        if (object == null || (object = ((CMPConsentModel)object).exportCMPInfo()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final List<String> getAllPurposesIDs() {
        Object object = this.getConsentModel();
        if (object == null || (object = ((CMPConsentModel)object).getAllPurposesIDs()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<String> getEnabledPurposesIDs() {
        Object object = this.getConsentModel();
        if (object == null || (object = ((CMPConsentModel)object).getEnabledPurposesIDs()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<String> getDisabledPurposesIDs() {
        Object object = this.getConsentModel();
        if (object == null || (object = ((CMPConsentModel)object).getDisabledPurposesIDs()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<String> getAllVendorsIDs() {
        Object object = this.getConsentModel();
        if (object == null || (object = ((CMPConsentModel)object).getAllVendorsIDs()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<String> getEnabledVendorsIDs() {
        Object object = this.getConsentModel();
        if (object == null || (object = ((CMPConsentModel)object).getEnabledVendorsIDs()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<String> getDisabledVendorsIDs() {
        Object object = this.getConsentModel();
        if (object == null || (object = ((CMPConsentModel)object).getDisabledVendorsIDs()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final void resetConsentManagementData() {
        this.userPreferences.resetConsentManagementData();
    }

    public final void checkWithServerAndOpenIfNecessary(@NotNull Function1<? super Result<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        WeakReference<Activity> weakReference = this.activityContext;
        if ((weakReference != null ? (Activity)weakReference.get() : null) == null) {
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("Activity reference is null. Call setActivity() before checking consent.")))));
            return;
        }
        CMPManager.loadConsentURLWithUseCase$default(this, UseCase.VERIFY_CONSENT_ON_INITIALIZE, null, (Function1)new Function1<Result<? extends Boolean>, Unit>(this, completion){
            final /* synthetic */ CMPManager this$0;
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.this$0 = $receiver;
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                block3: {
                    Object object = result;
                    Function1<Result<Unit>, Unit> function1 = this.this$0;
                    Object object2 = this.$completion;
                    if (Result.isSuccess-impl((Object)object)) {
                        boolean needsConsent = (Boolean)object;
                        boolean bl = false;
                        if (needsConsent) {
                            CMPManager.access$showConsentLayer(function1);
                        } else {
                            CMPManager.access$getDelegate$p(function1).didCloseConsentLayer();
                        }
                        object2.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)Unit.INSTANCE)));
                    }
                    function1 = this.$completion;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) break block3;
                    Object error = object2 = throwable;
                    boolean bl = false;
                    function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure(error))));
                }
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void openConsentLayer(@NotNull Function1<? super Result<Unit>, Unit> completion) {
        WebView webView;
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Log.d((String)"CMPManager", (String)"Force opening consent layer");
        CMPManager cMPManager = this;
        WeakReference<Activity> weakReference = this.activityContext;
        if (weakReference != null) {
            void it;
            WeakReference<Activity> weakReference2 = weakReference;
            CMPManager cMPManager2 = cMPManager;
            boolean bl = false;
            webView = this.webViewManager.createWebView((WeakReference<Activity>)it);
            cMPManager = cMPManager2;
        } else {
            webView = null;
        }
        cMPManager.webView = webView;
        WebView webView2 = this.webView;
        Intrinsics.checkNotNull((Object)webView2);
        this.webViewContainer = new WebViewContainer(webView2);
        CMPManager.loadConsentURLWithUseCase$default(this, UseCase.OPEN_CONSENT, null, (Function1)new Function1<Result<? extends Boolean>, Unit>(this, completion){
            final /* synthetic */ CMPManager this$0;
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.this$0 = $receiver;
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                block1: {
                    Object object = result;
                    Function1<Result<Unit>, Unit> function1 = this.this$0;
                    Object object2 = this.$completion;
                    if (Result.isSuccess-impl((Object)object)) {
                        boolean it = (Boolean)object;
                        boolean bl = false;
                        CMPManager.access$showConsentLayer(function1);
                        CMPManager.access$getDelegate$p(function1).didShowConsentLayer();
                        object2.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)Unit.INSTANCE)));
                    }
                    function1 = this.$completion;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable == null) break block1;
                    Object error = object2 = throwable;
                    boolean bl = false;
                    Log.e((String)"CMPManager", (String)("Error in forceOpenConsentLayer: " + ((Throwable)error).getMessage()));
                    function1.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)error))));
                }
            }
        }, 2, null);
    }

    public final void checkIfConsentIsRequired(@NotNull Function1<? super Boolean, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        CMPManager.loadConsentURLWithUseCase$default(this, UseCase.PERFORM_DRY_CHECK_CONSENT, null, (Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Boolean, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                block1: {
                    Throwable throwable;
                    Object object = result;
                    Function1<Boolean, Unit> function1 = this.$completion;
                    if (Result.isSuccess-impl((Object)object)) {
                        boolean needsConsent = (Boolean)object;
                        boolean bl = false;
                        function1.invoke((Object)needsConsent);
                    }
                    function1 = this.$completion;
                    Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                    if (throwable2 == null) break block1;
                    Throwable it = throwable = throwable2;
                    boolean bl = false;
                    function1.invoke((Object)true);
                }
            }
        }, 2, null);
    }

    public final void acceptVendors(@NotNull List<String> vendors, @NotNull Function1<? super Result<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter(vendors, (String)"vendors");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        this.loadConsentURLWithUseCase(UseCase.ENABLE_CONSENT_VENDORS, MapsKt.mapOf((Pair)TuplesKt.to((Object)"addVendors", vendors)), (Function1<? super Result<Boolean>, Unit>)((Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                Object object;
                Function1<Result<Unit>, Unit> function1 = this.$completion;
                Object object2 = result;
                if (Result.isSuccess-impl((Object)object2)) {
                    boolean bl = (Boolean)object2;
                    Function1<Result<Unit>, Unit> function12 = function1;
                    boolean bl2 = false;
                    function1 = function12;
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                } else {
                    object = Result.constructor-impl((Object)object2);
                }
                function1.invoke((Object)Result.box-impl((Object)object));
            }
        }));
    }

    public final void rejectVendors(@NotNull List<String> vendors, @NotNull Function1<? super Result<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter(vendors, (String)"vendors");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        this.loadConsentURLWithUseCase(UseCase.DISABLE_CONSENT_VENDORS, MapsKt.mapOf((Pair)TuplesKt.to((Object)"addVendors", vendors)), (Function1<? super Result<Boolean>, Unit>)((Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                Object object;
                Function1<Result<Unit>, Unit> function1 = this.$completion;
                Object object2 = result;
                if (Result.isSuccess-impl((Object)object2)) {
                    boolean bl = (Boolean)object2;
                    Function1<Result<Unit>, Unit> function12 = function1;
                    boolean bl2 = false;
                    function1 = function12;
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                } else {
                    object = Result.constructor-impl((Object)object2);
                }
                function1.invoke((Object)Result.box-impl((Object)object));
            }
        }));
    }

    public final void acceptPurposes(@NotNull List<String> purposes, boolean updatePurpose, @NotNull Function1<? super Result<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter(purposes, (String)"purposes");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"addPurposes", purposes), TuplesKt.to((Object)"updateVendors", (Object)updatePurpose)};
        this.loadConsentURLWithUseCase(UseCase.ENABLE_CONSENT_PURPOSES, MapsKt.mapOf((Pair[])pairArray), (Function1<? super Result<Boolean>, Unit>)((Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                Object object;
                Function1<Result<Unit>, Unit> function1 = this.$completion;
                Object object2 = result;
                if (Result.isSuccess-impl((Object)object2)) {
                    boolean bl = (Boolean)object2;
                    Function1<Result<Unit>, Unit> function12 = function1;
                    boolean bl2 = false;
                    function1 = function12;
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                } else {
                    object = Result.constructor-impl((Object)object2);
                }
                function1.invoke((Object)Result.box-impl((Object)object));
            }
        }));
    }

    public final void rejectPurposes(@NotNull List<String> purposes, boolean updateVendor, @NotNull Function1<? super Result<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter(purposes, (String)"purposes");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"addPurposes", purposes), TuplesKt.to((Object)"updateVendors", (Object)updateVendor)};
        this.loadConsentURLWithUseCase(UseCase.DISABLE_CONSENT_PURPOSES, MapsKt.mapOf((Pair[])pairArray), (Function1<? super Result<Boolean>, Unit>)((Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                Object object;
                Function1<Result<Unit>, Unit> function1 = this.$completion;
                Object object2 = result;
                if (Result.isSuccess-impl((Object)object2)) {
                    boolean bl = (Boolean)object2;
                    Function1<Result<Unit>, Unit> function12 = function1;
                    boolean bl2 = false;
                    function1 = function12;
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                } else {
                    object = Result.constructor-impl((Object)object2);
                }
                function1.invoke((Object)Result.box-impl((Object)object));
            }
        }));
    }

    public final void rejectAll(@NotNull Function1<? super Result<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        this.loadConsentURLWithUseCase(UseCase.REJECT_ALL_CONSENT, MapsKt.mapOf((Pair)TuplesKt.to((Object)"rejectAll", (Object)true)), (Function1<? super Result<Boolean>, Unit>)((Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                Object object;
                Function1<Result<Unit>, Unit> function1 = this.$completion;
                Object object2 = result;
                if (Result.isSuccess-impl((Object)object2)) {
                    boolean bl = (Boolean)object2;
                    Function1<Result<Unit>, Unit> function12 = function1;
                    boolean bl2 = false;
                    function1 = function12;
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                } else {
                    object = Result.constructor-impl((Object)object2);
                }
                function1.invoke((Object)Result.box-impl((Object)object));
            }
        }));
    }

    public final void acceptAll(@NotNull Function1<? super Result<Unit>, Unit> completion) {
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        this.loadConsentURLWithUseCase(UseCase.ACCEPT_ALL_CONSENT, MapsKt.mapOf((Pair)TuplesKt.to((Object)"acceptAll", (Object)true)), (Function1<? super Result<Boolean>, Unit>)((Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Result<Unit>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                Object object;
                Function1<Result<Unit>, Unit> function1 = this.$completion;
                Object object2 = result;
                if (Result.isSuccess-impl((Object)object2)) {
                    boolean bl = (Boolean)object2;
                    Function1<Result<Unit>, Unit> function12 = function1;
                    boolean bl2 = false;
                    function1 = function12;
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                } else {
                    object = Result.constructor-impl((Object)object2);
                }
                function1.invoke((Object)Result.box-impl((Object)object));
            }
        }));
    }

    private final void loadConsentURLWithUseCase(UseCase useCase, Map<String, ? extends Object> additionalParams, Function1<? super Result<Boolean>, Unit> completion) {
        CMPUrlParams params = this.createUrlParams(useCase);
        Map<String, ? extends Object> map = additionalParams;
        if (map != null) {
            Map<String, ? extends Object> it = map;
            boolean bl = false;
            params.apply(it);
        }
        String urlString = CMPUrlBuilder.INSTANCE.build(params);
        System.out.println((Object)("Debug: URL for " + (Object)((Object)useCase) + " - " + urlString));
        this.webViewManager.loadConsentURL(urlString, useCase, (Function1<? super Result<Boolean>, Unit>)((Function1)new Function1<Result<? extends Boolean>, Unit>(completion){
            final /* synthetic */ Function1<Result<Boolean>, Unit> $completion;
            {
                this.$completion = $completion;
                super(1);
            }

            public final void invoke(@NotNull Object result) {
                this.$completion.invoke((Object)Result.box-impl((Object)result));
            }
        }));
    }

    static /* synthetic */ void loadConsentURLWithUseCase$default(CMPManager cMPManager, UseCase useCase, Map map, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        cMPManager.loadConsentURLWithUseCase(useCase, map, (Function1<? super Result<Boolean>, Unit>)function1);
    }

    public final void onApplicationPause() {
        this.webViewManager.cancelOperations();
        Log.d((String)"CMPManager", (String)"Application paused");
    }

    public final void onApplicationResume() {
        Log.d((String)"CMPManager", (String)"Application resumed");
    }

    @Override
    public void didReceiveConsentMessage(@NotNull String consent, @NotNull JsonObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)consent, (String)"consent");
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Log.d((String)"CMPManager", (String)"Consent message received");
        this.delegate.didReceiveConsent(consent, jsonObject);
        this.dismissConsentLayer();
    }

    @Override
    public void didReceiveOpenMessage() {
        Log.d((String)"CMPManager", (String)"Open message received");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CMPManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CMPManager.access$showConsentLayer(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.delegate.didShowConsentLayer();
    }

    @Override
    public void didNotNeedOpenConsentLayer() {
        Log.d((String)"CMPManager", (String)"Close message received");
    }

    @Override
    public void didReceiveError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Log.e((String)"CMPManager", (String)("Error received: " + error));
        this.delegate.didReceiveError(error);
    }

    @Override
    public void networkStatusDidChange(boolean isConnected) {
        if (isConnected) {
            this.retryManager.retry((Function1<? super Boolean, Unit>)((Function1)networkStatusDidChange.1.INSTANCE));
        }
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Log.d((String)"CMPManager", (String)"Activity is being destroyed");
        if (owner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.RESUMED)) {
            Log.d((String)"CMPManager", (String)"Configuration is changing, not cleaning up");
            return;
        }
        this.cleanUp();
    }

    private final void cleanUp() {
        WeakReference<Activity> weakReference = this.activityContext;
        if (weakReference != null) {
            weakReference.clear();
        }
        this.dismissConsentLayer();
        this.webViewContainer = null;
    }

    /*
     * WARNING - void declaration
     */
    public void onResume(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Log.d((String)"CMPManager", (String)"Activity resumed");
        WeakReference<Activity> activity = this.activityContext;
        if (activity != null && this.webViewManager.isWebViewDestroyed()) {
            WebViewContainer webViewContainer;
            WebView webView = this.webViewManager.createWebView(activity);
            CMPManager cMPManager = this;
            WebView webView2 = webView;
            if (webView2 != null) {
                void it;
                WebView webView3 = webView2;
                CMPManager cMPManager2 = cMPManager;
                boolean bl = false;
                webViewContainer = new WebViewContainer((WebView)it);
                cMPManager = cMPManager2;
            } else {
                webViewContainer = null;
            }
            cMPManager.webViewContainer = webViewContainer;
        }
    }

    public final void onActivityDestroyed() {
        this.activityContext = null;
        this.dismissConsentLayer();
        this.webView = null;
        this.webViewContainer = null;
    }

    public /* synthetic */ CMPManager(Context context, UrlConfig urlConfig, ConsentLayerUIConfig webViewConfig, CMPManagerDelegate delegate, DefaultConstructorMarker $constructor_marker) {
        this(context, urlConfig, webViewConfig, delegate);
    }

    public static final /* synthetic */ void access$showConsentLayer(CMPManager $this) {
        $this.showConsentLayer();
    }

    public static final /* synthetic */ CMPManagerDelegate access$getDelegate$p(CMPManager $this) {
        return $this.delegate;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/consentmanager/cm_sdk_android_v3/CMPManager$Companion;", "", "()V", "instanceRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lnet/consentmanager/cm_sdk_android_v3/CMPManager;", "getInstance", "context", "Landroid/content/Context;", "urlConfig", "Lnet/consentmanager/cm_sdk_android_v3/UrlConfig;", "webViewConfig", "Lnet/consentmanager/cm_sdk_android_v3/ConsentLayerUIConfig;", "delegate", "Lnet/consentmanager/cm_sdk_android_v3/CMPManagerDelegate;", "cm-sdk-android-v3_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CMPManager getInstance(@NotNull Context context, @NotNull UrlConfig urlConfig, @NotNull ConsentLayerUIConfig webViewConfig, @NotNull CMPManagerDelegate delegate) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)urlConfig, (String)"urlConfig");
            Intrinsics.checkNotNullParameter((Object)webViewConfig, (String)"webViewConfig");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            CMPManager cMPManager = (CMPManager)instanceRef.get();
            if (cMPManager == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    CMPManager cMPManager2 = (CMPManager)instanceRef.get();
                    if (cMPManager2 == null) {
                        CMPManager cMPManager3;
                        Context context2 = context.getApplicationContext();
                        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
                        CMPManager it = cMPManager3 = new CMPManager(context2, urlConfig, webViewConfig, delegate, null);
                        boolean bl2 = false;
                        instanceRef.set(it);
                        cMPManager2 = cMPManager3;
                    }
                    CMPManager cMPManager4 = cMPManager2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl23 : MonitorExitStatement: MONITOREXIT : var5_5
                    cMPManager = cMPManager4;
                }
            }
            return cMPManager;
        }

        public static /* synthetic */ CMPManager getInstance$default(Companion companion, Context context, UrlConfig urlConfig, ConsentLayerUIConfig consentLayerUIConfig, CMPManagerDelegate cMPManagerDelegate, int n, Object object) {
            if ((n & 4) != 0) {
                consentLayerUIConfig = new ConsentLayerUIConfig(null, null, 0.0f, false, false, false, 63, null);
            }
            return companion.getInstance(context, urlConfig, consentLayerUIConfig, cMPManagerDelegate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

