package net.consentmanager.cm_sdk_android_v3


import android.graphics.Color
import androidx.annotation.Keep

@Keep
class ConsentLayerUIConfig @JvmOverloads constructor(
    val position: Position = Position.FULL_SCREEN,
    val backgroundStyle: BackgroundStyle = BackgroundStyle.Dimmed(Color.BLACK, 0.5f),
    val cornerRadius: Float = 0f,
    val respectsSafeArea: Boolean = true,
    val isCancelable: Boolean = true,
    val allowsOrientationChanges: Boolean = true
) {
    @Keep
    class Position private constructor(val value: Int) {
        companion object {
            @JvmField val FULL_SCREEN = Position(0)
            @JvmField val HALF_SCREEN_TOP = Position(1)
            @JvmField val HALF_SCREEN_BOTTOM = Position(2)

            @JvmStatic
            fun custom(width: Int, height: Int): Position {
                return Position(3, width, height)
            }
        }

        private var width: Int = 0
        private var height: Int = 0

        private constructor(value: Int, width: Int, height: Int) : this(value) {
            this.width = width
            this.height = height
        }

        fun getWidth(): Int = width
        fun getHeight(): Int = height
    }

    @Keep
    sealed class BackgroundStyle {
        class Dimmed(@JvmField val color: Int, @JvmField val alpha: Float) : BackgroundStyle()
        class Solid(@JvmField val color: Int) : BackgroundStyle()
        object None : BackgroundStyle()

        companion object {
            @JvmStatic fun dimmed(color: Int, alpha: Float): BackgroundStyle = Dimmed(color, alpha)
            @JvmStatic fun solid(color: Int): BackgroundStyle = Solid(color)
            @JvmStatic fun none(): BackgroundStyle = None
        }
    }
}